/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.events;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import java.util.HashMap;
import javax.slee.management.SleeState;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;

public class Test1115042Test
extends AbstractSleeTCKTest {
    private static final String RA_NAME = "Test1115042RA";
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    private static final String RESOURCE_DU_PATH_PARAM = "RADUPath";
    private MessageHandlerRegistry out;
    private RMIObjectChannel in;
    private FutureResult futureResult;

    public TCKTestResult run() throws Exception {
        String raEntityName = "Test1115042RA_Entity";
        this.futureResult = new FutureResult(this.getLog());
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        this.getLog().debug("Create RA Entity...");
        ResourceAdaptorID raID = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
        ConfigProperties configProperties = new ConfigProperties();
        resourceMBean.createResourceAdaptorEntity(raID, raEntityName, configProperties);
        this.getLog().debug("Activate the RA Entity...");
        resourceMBean.activateResourceAdaptorEntity(raEntityName);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Type", new Integer(1));
        this.out.sendMessage(map);
        TCKTestResult res = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!res.isPassed()) {
            return res;
        }
        this.futureResult = new FutureResult(this.getLog());
        this.getLog().debug("Stop the SLEE...");
        this.utils().getSleeManagementMBeanProxy().stop();
        Thread.sleep(5000L);
        SleeState state = this.utils().getSleeManagementMBeanProxy().getState();
        if (!SleeState.STOPPING.equals((Object)state)) {
            return TCKTestResult.error("SLEE should have transitioned into the STOPPING state but was found to reside in the state " + state);
        }
        this.getLog().debug("SLEE is now in the STOPPING state.");
        map = new HashMap();
        map.put("Type", new Integer(2));
        this.out.sendMessage(map);
        return this.futureResult.waitForResult(this.utils().getTestTimeout());
    }

    public void setUp() throws Exception {
        this.setupService(RESOURCE_DU_PATH_PARAM);
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1115042Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1115042Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1115042Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1115042Test.this.setError(msg, e);
            }
        });
        this.out = this.utils().getMessageHandlerRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.in.clearQueue();
            this.utils().removeRAEntities();
        }
        finally {
            super.tearDown();
        }
    }

    protected void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed();
        }
    }

    protected void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
        }
    }

    protected void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
        }
    }
}

