/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceTest;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import java.util.HashMap;
import javax.slee.management.ResourceAdaptorEntityState;

public class Test1115248Test
extends BaseResourceTest {
    public TCKTestResult run() throws Exception {
        this.getLog().info("Creating activity in RA to prevent transition to stopped state during deactivation");
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("assertion", new Integer(1115248));
        arguments.put("argument", "startActivity");
        HashMap results = this.sendMessage(47, arguments);
        if (results == null) {
            throw new TCKTestErrorException("Test timed out while waiting for response from test component");
        }
        Object result = results.get("result");
        if (result instanceof Exception) {
            throw new TCKTestFailureException(1115248, "Unexpected exception thrown during activity creation:", (Exception)result);
        }
        if (!Boolean.TRUE.equals(result)) {
            throw new TCKTestErrorException("Unexpected result received from test component: " + result);
        }
        String raEntityName = this.getResourceAdaptorEntityName();
        this.getLog().info("Stopping RA Entity: " + raEntityName);
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        resourceMBean.deactivateResourceAdaptorEntity(raEntityName);
        this.getLog().info("Waiting for RA Entity to enter Stopping state");
        ResourceAdaptorEntityState raState = null;
        long timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
        while (System.currentTimeMillis() < timeout && !(raState = resourceMBean.getState(raEntityName)).isStopping()) {
            Thread.sleep(500L);
        }
        if (!ResourceAdaptorEntityState.STOPPING.equals(raState)) {
            throw new TCKTestErrorException("RA did not transition into the Stopping state within test timeout");
        }
        this.getLog().info("Asking RA to call startActivity() while in stopping state");
        arguments = new HashMap();
        arguments.put("assertion", new Integer(1115248));
        results = this.sendMessage(47, arguments);
        raState = resourceMBean.getState(raEntityName);
        if (!ResourceAdaptorEntityState.STOPPING.equals((Object)raState)) {
            throw new TCKTestErrorException("RA entity was no in STOPPING state when it should have been");
        }
        if (results == null) {
            throw new TCKTestErrorException("Test timed out while waiting for response from test component");
        }
        result = results.get("result");
        if (result instanceof Exception) {
            throw new TCKTestFailureException(1115248, "Unexpected exception thrown during test:", (Exception)result);
        }
        if (Boolean.FALSE.equals(result)) {
            throw new TCKTestFailureException(1115248, "startActivity() failed to throw a IllegalStateException while in Stopping state");
        }
        if (!Boolean.TRUE.equals(result)) {
            throw new TCKTestErrorException("Unexpected result received from test component: " + result);
        }
        this.getLog().info("Asking RA to resume raStopping");
        arguments = new HashMap();
        arguments.put("assertion", new Integer(1115248));
        arguments.put("argument", "endActivity");
        results = this.sendMessage(40, arguments);
        if (results == null) {
            throw new TCKTestErrorException("Test timed out while waiting for response from test component");
        }
        result = results.get("result");
        if (result instanceof Exception) {
            throw new TCKTestFailureException(1115248, "Unexpected exception thrown during activity creation:", (Exception)result);
        }
        if (!Boolean.TRUE.equals(result)) {
            throw new TCKTestErrorException("Unexpected result received from test component: " + result);
        }
        this.getLog().info("Waiting for RA Entity to enter Inactive state");
        raState = null;
        timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
        while (System.currentTimeMillis() < timeout && !(raState = resourceMBean.getState(raEntityName)).isInactive()) {
            Thread.sleep(500L);
        }
        if (!ResourceAdaptorEntityState.INACTIVE.equals((Object)raState)) {
            throw new TCKTestErrorException("RA did not transition into the Inactive state within test timeout");
        }
        this.getLog().info("Asking RA to call startActivity() while in Inactive state");
        arguments = new HashMap();
        arguments.put("assertion", new Integer(1115248));
        results = this.sendMessage(47, arguments);
        if (results == null) {
            throw new TCKTestErrorException("Test timed out while waiting for response from test component");
        }
        result = results.get("result");
        if (result instanceof Exception) {
            throw new TCKTestFailureException(1115248, "Unexpected exception thrown during test:", (Exception)result);
        }
        if (Boolean.FALSE.equals(result)) {
            throw new TCKTestFailureException(1115248, "startActivity() failed to throw a IllegalStateException while in Inactive state");
        }
        if (!Boolean.TRUE.equals(result)) {
            throw new TCKTestErrorException("Unexpected result received from test component: " + result);
        }
        return TCKTestResult.passed();
    }
}

