/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceTest;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.util.HashMap;

public class Test1115238Test
extends BaseResourceTest {
    private static final int ASSERTION_ID = 1115238;

    public TCKTestResult run() throws Exception {
        int sequenceID = this.nextMessageID();
        ResponseListener listener = new ResponseListener(sequenceID);
        this.sendMessage(43, new Integer(1115238), listener, sequenceID);
        Object sbbResult = listener.getSbbResult();
        Object raResult = listener.getRAResult();
        if (raResult == null) {
            throw new TCKTestErrorException("Test timed out while waiting for response from test resource adaptor component");
        }
        if (sbbResult == null) {
            throw new TCKTestFailureException(1115238, "Test timed out while waiting for event confirmation from sbb");
        }
        if (raResult instanceof Exception) {
            throw new TCKTestFailureException(1115238, "An exception was thrown by test resource adaptor while firing an event on a new activity", (Exception)raResult);
        }
        if (!Boolean.TRUE.equals(raResult)) {
            throw new TCKTestErrorException("Unexpected result received from test resource adaptor component: " + raResult);
        }
        if (!Boolean.TRUE.equals(sbbResult)) {
            throw new TCKTestErrorException("Unexpected result received from test sbb component: " + sbbResult);
        }
        return TCKTestResult.passed();
    }

    private class ResponseListener
    implements MessageHandler {
        private Future sbbFuture = new Future();
        private Future raFuture = new Future();
        private int expectedResponse = -1;

        public ResponseListener(int sequenceID) {
            this.expectedResponse = sequenceID;
        }

        public boolean handleMessage(Object obj) throws RemoteException {
            Test1115238Test.this.getLog().info("Received message from test component: " + obj);
            if (!(obj instanceof TCKMessage)) {
                Test1115238Test.this.getLog().error("Unhandled message type: " + obj);
                return false;
            }
            TCKMessage message = (TCKMessage)obj;
            if (message.getSequenceID() != this.expectedResponse) {
                return true;
            }
            HashMap results = (HashMap)message.getArgument();
            Object raResult = results.get("result1");
            Object sbbResult = results.get("result2");
            if (raResult != null && !this.raFuture.isSet()) {
                this.raFuture.setValue(raResult);
            } else if (sbbResult != null && !this.sbbFuture.isSet()) {
                this.sbbFuture.setValue(sbbResult);
            }
            return true;
        }

        public Object getSbbResult() {
            Object result;
            try {
                result = this.sbbFuture.getValue(Test1115238Test.this.utils().getTestTimeout());
            }
            catch (Future.TimeoutException e) {
                return null;
            }
            return result;
        }

        public Object getRAResult() {
            Object result;
            try {
                result = this.raFuture.getValue(Test1115238Test.this.utils().getTestTimeout());
            }
            catch (Future.TimeoutException e) {
                return null;
            }
            return result;
        }
    }
}

