/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.rautils.BaseTCKRA;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.resource.adaptor11.TCKActivityHandleImpl;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.slee.EventTypeID;
import javax.slee.SLEEException;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.UnrecognizedEventException;
import javax.slee.UnrecognizedServiceException;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FireEventException;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.IllegalEventException;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.UnrecognizedActivityHandleException;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.Transaction;

public class EndpointResourceAdaptor
extends BaseTCKRA {
    private int lastSequenceID = 0;
    private TCKActivityHandleImpl lastActivityHandle = null;
    private SleeEndpoint endpoint;
    private SleeTransactionManager transactionManager;
    private boolean isConfigured = false;
    private MessageHandler messageHandler = null;

    public void activityUnreferenced(ActivityHandle handle) {
        this.getLog().info("activityUnreferenced(): " + handle + " (ending)");
        try {
            this.endpoint.endActivity(handle);
        }
        catch (UnrecognizedActivityHandleException unrecognizedActivityHandleException) {
            // empty catch block
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.isConfigured = true;
    }

    public void raUnconfigure() {
        this.isConfigured = false;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        super.setResourceAdaptorContext(context);
        this.setTracer(context.getTracer("Endpoint RA"));
        try {
            MessageHandlerRegistry registry = TCKRAUtils.lookupMessageHandlerRegistry();
            this.messageHandler = new EndpointMessageListener(this);
            registry.registerMessageHandler(this.messageHandler);
        }
        catch (Exception e) {
            this.getLog().severe("An error occured during setResourceAdaptorContext()", e);
        }
        this.endpoint = context.getSleeEndpoint();
        this.transactionManager = context.getSleeTransactionManager();
    }

    public void unsetResourceAdaptorContext() {
        this.transactionManager = null;
        this.endpoint = null;
        try {
            MessageHandlerRegistry registry = TCKRAUtils.lookupMessageHandlerRegistry();
            if (this.messageHandler != null) {
                registry.unregisterMessageHandler(this.messageHandler);
            }
        }
        catch (Exception e) {
            this.getLog().severe("An error occured during unsetResourceAdaptorContext()", e);
        }
        this.setTracer(null);
        super.unsetResourceAdaptorContext();
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void executeTestLogic(Object obj) throws Exception {
        this.getLog().info("Received message from sbb: " + obj.toString());
        int assertion = -1;
        if (obj instanceof Integer) {
            assertion = (Integer)obj;
        }
        HashMap results = null;
        switch (assertion) {
            case 1115303: {
                results = this.test1115303b();
                break;
            }
            case 1115276: {
                results = this.test1115276b();
                break;
            }
            case 1115232: {
                results = this.test1115232b();
                break;
            }
            case 1115233: {
                results = this.test1115233b();
                break;
            }
            case 1115234: {
                results = this.test1115234b();
                break;
            }
            case 1115277: {
                results = this.test1115277b();
                break;
            }
            case 1115278: {
                results = this.test1115278b();
                break;
            }
            case 1115316: {
                results = this.test1115316b();
                break;
            }
            default: {
                this.getLog().warning("Unhandled message received from sbb: " + obj);
            }
        }
        if (results != null) {
            this.sendEndpointMessage(this.lastSequenceID, 0, results);
        }
    }

    private ResourceAdaptorContext getContext() {
        return super.getResourceAdaptorContext();
    }

    private void sendEndpointMessage(int sequenceID, int method) {
        this.sendEndpointMessage(sequenceID, method, null);
    }

    private void sendEndpointMessage(int sequenceID, int method, Object argument) {
        this.sendMessage(new TCKMessage(this.getRAUID(), sequenceID, method, argument));
    }

    private void fireEvent(ActivityHandle handle, int sequenceID) throws IllegalEventException, NullPointerException, IllegalArgumentException, UnrecognizedServiceException, SLEEException, UnrecognizedActivityHandleException, ActivityIsEndingException, UnrecognizedEventException, FireEventException {
        this.fireEvent(handle, sequenceID, null);
    }

    private void fireEvent(ActivityHandle handle, int sequenceID, Object payload) throws IllegalEventException, NullPointerException, IllegalArgumentException, UnrecognizedServiceException, SLEEException, UnrecognizedActivityHandleException, ActivityIsEndingException, UnrecognizedEventException, FireEventException {
        EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        FireableEventType eventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
        this.endpoint.fireEvent(handle, eventType, (Object)new SimpleEvent(sequenceID, payload), null, null);
    }

    private void fireEventTransacted(ActivityHandle handle, int sequenceID, Object payload) throws IllegalEventException, NullPointerException, IllegalArgumentException, UnrecognizedServiceException, SLEEException, UnrecognizedActivityHandleException, ActivityIsEndingException, UnrecognizedEventException, FireEventException {
        EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        FireableEventType eventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
        this.endpoint.fireEventTransacted(handle, eventType, (Object)new SimpleEvent(sequenceID, payload), null, null);
    }

    private void fireEventTransacted(ActivityHandle handle, int sequenceID) throws IllegalEventException, NullPointerException, IllegalArgumentException, UnrecognizedServiceException, SLEEException, UnrecognizedActivityHandleException, ActivityIsEndingException, UnrecognizedEventException, FireEventException {
        this.fireEventTransacted(handle, sequenceID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115211() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115211);
        boolean activityStarted = false;
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                activityStarted = true;
                Transaction suspended = this.transactionManager.suspend();
                try {
                    this.transactionManager.beginSleeTransaction();
                    try {
                        try {
                            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                            results.put("result", Boolean.FALSE);
                        }
                        catch (ActivityAlreadyExistsException e) {
                            results.put("result", Boolean.TRUE);
                        }
                    }
                    finally {
                        this.transactionManager.commit();
                    }
                }
                finally {
                    this.transactionManager.resume(suspended);
                }
            }
            finally {
                this.transactionManager.commit();
                if (activityStarted) {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    private HashMap test1115214() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115214);
        try {
            this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
            results.put("result", Boolean.FALSE);
        }
        catch (TransactionRequiredLocalException trle) {
            results.put("result", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115215() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        boolean activityStarted = false;
        try {
            TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115215);
            try {
                this.transactionManager.beginSleeTransaction();
                try {
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                    activityStarted = true;
                    Transaction suspended = this.transactionManager.suspend();
                    try {
                        this.transactionManager.beginSleeTransaction();
                        try {
                            this.endpoint.endActivityTransacted((ActivityHandle)handle);
                            results.put("result1", Boolean.FALSE);
                        }
                        catch (UnrecognizedActivityHandleException e) {
                            results.put("result1", Boolean.TRUE);
                        }
                        catch (Exception e) {
                            results.put("result1", e);
                        }
                        finally {
                            this.transactionManager.rollback();
                        }
                    }
                    finally {
                        this.transactionManager.resume(suspended);
                    }
                }
                finally {
                    this.transactionManager.commit();
                }
                try {
                    this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                    results.put("result2", Boolean.FALSE);
                }
                catch (ActivityAlreadyExistsException e) {
                    results.put("result2", Boolean.TRUE);
                }
                catch (Exception e) {
                    results.put("result2", e);
                }
                this.transactionManager.beginSleeTransaction();
                try {
                    try {
                        this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                        results.put("result3", Boolean.FALSE);
                    }
                    catch (ActivityAlreadyExistsException e) {
                        results.put("result3", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result3", e);
                    }
                }
                finally {
                    this.transactionManager.rollback();
                }
            }
            finally {
                if (activityStarted) {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115217() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        try {
            TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115217);
            this.getLog().info("Starting transaction 1");
            this.transactionManager.beginSleeTransaction();
            try {
                this.getLog().info("Starting activity transacted: " + handle);
                this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
            }
            finally {
                this.getLog().info("Rolling back transaction 1");
                this.transactionManager.rollback();
            }
            this.getLog().info("Starting transaction 2");
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.getLog().info("Starting activity transacted: " + handle);
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                    results.put("result", Boolean.TRUE);
                }
                catch (ActivityAlreadyExistsException e) {
                    results.put("result", Boolean.FALSE);
                }
                catch (Exception e) {
                    results.put("result", e);
                }
            }
            finally {
                this.getLog().info("Rolling back transaction 2");
                this.transactionManager.rollback();
            }
            try {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.getLog().info("Ignoring exception caught during test cleanup", e);
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115231() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115231);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.endpoint.endActivityTransacted((ActivityHandle)handle);
                results.put("result", Boolean.FALSE);
            }
            catch (TransactionRequiredLocalException trle) {
                results.put("result", Boolean.TRUE);
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    private HashMap test1115232(int sequenceID) {
        TCKActivityHandleImpl handle;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        this.lastActivityHandle = handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115232);
        results.put("result-ra1", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.fireEvent(handle, sequenceID);
        }
        catch (Exception e) {
            results.put("result-ra1", e);
        }
        return results;
    }

    private HashMap test1115232b() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        results.put("result-ra2", Boolean.TRUE);
        try {
            this.endpoint.endActivityTransacted((ActivityHandle)this.lastActivityHandle);
        }
        catch (Exception e) {
            results.put("result-ra2", e);
        }
        return results;
    }

    private HashMap test1115233(int sequenceID) {
        TCKActivityHandleImpl handle;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        this.lastActivityHandle = handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115233);
        results.put("result-ra1", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.fireEvent(handle, sequenceID);
        }
        catch (Exception e) {
            results.put("result-ra1", e);
        }
        return results;
    }

    private HashMap test1115233b() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        results.put("result-ra2", Boolean.TRUE);
        try {
            this.endpoint.endActivityTransacted((ActivityHandle)this.lastActivityHandle);
        }
        catch (Exception e) {
            results.put("result-ra2", e);
        }
        return results;
    }

    private HashMap test1115234(int sequenceID) {
        TCKActivityHandleImpl handle;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        this.lastActivityHandle = handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115234);
        results.put("result-ra1", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.getLog().info("Firing event A (non-transacted)");
            this.fireEvent(handle, sequenceID, "A");
        }
        catch (Exception e) {
            results.put("result-ra1", e);
        }
        return results;
    }

    private HashMap test1115234b() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        results.put("result-ra2", Boolean.TRUE);
        try {
            this.getLog().info("Ending activity (transacted)");
            this.endpoint.endActivityTransacted((ActivityHandle)this.lastActivityHandle);
            this.getLog().info("Firing event B (non-transacted)");
            this.fireEvent(this.lastActivityHandle, this.lastSequenceID, "B");
        }
        catch (Exception e) {
            results.put("result-ra2", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115238(int sequenceID) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115238);
        results.put("result1", Boolean.TRUE);
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                try {
                    this.fireEvent(handle, sequenceID);
                }
                finally {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            this.getLog().severe("An error occured during test event firing for Test1115238Test", e);
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115240() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115240);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                try {
                    this.fireEventTransacted(handle, 0);
                    results.put("result", Boolean.FALSE);
                }
                catch (TransactionRequiredLocalException trle) {
                    results.put("result", Boolean.TRUE);
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115241(int sequenceID) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115241);
        results.put("result1", Boolean.TRUE);
        try {
            this.getLog().info("Beginning transaction");
            this.transactionManager.beginSleeTransaction();
            try {
                this.getLog().info("Starting activity (transacted): " + handle);
                this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                try {
                    this.getLog().info("Firing event (transacted)");
                    this.fireEventTransacted(handle, sequenceID);
                }
                finally {
                    this.getLog().info("Ending activity (transacted)");
                    this.endpoint.endActivityTransacted((ActivityHandle)handle);
                }
            }
            finally {
                this.getLog().info("Committing transaction");
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115242(int sequenceID) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115242);
        results.put("result1", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.transactionManager.beginSleeTransaction();
                try {
                    this.fireEventTransacted(handle, sequenceID);
                }
                finally {
                    this.transactionManager.rollback();
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115247() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115247);
        try {
            this.endpoint.startActivity(null, null);
            results.put("result1", Boolean.FALSE);
        }
        catch (NullPointerException npe) {
            results.put("result1", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        try {
            this.endpoint.startActivity(null, new Object());
            results.put("result2", Boolean.FALSE);
        }
        catch (NullPointerException npe) {
            results.put("result2", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result2", e);
        }
        boolean failed = false;
        try {
            this.endpoint.startActivity((ActivityHandle)handle, null);
            results.put("result3", Boolean.FALSE);
            failed = true;
        }
        catch (NullPointerException npe) {
            results.put("result3", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result3", e);
        }
        finally {
            if (failed) {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                try {
                    this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                    results.put("result4", Boolean.FALSE);
                }
                catch (ActivityAlreadyExistsException aaee) {
                    results.put("result4", Boolean.TRUE);
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result4", e);
        }
        return results;
    }

    private HashMap test1115248(Object argument) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        if ("startActivity".equals(argument)) {
            this.getLog().info("Creating activity in RA to prevent RA Entity from stopping");
            this.lastActivityHandle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115246);
            try {
                this.endpoint.startActivity((ActivityHandle)this.lastActivityHandle, (Object)this.lastActivityHandle);
                results.put("result", Boolean.TRUE);
            }
            catch (Exception e) {
                results.put("result", e);
            }
            return results;
        }
        if ("endActivity".equals(argument)) {
            this.getLog().info("Removing activity from RA to allow RA to transition into the Inactive state");
            try {
                this.endpoint.endActivity((ActivityHandle)this.lastActivityHandle);
                results.put("result", Boolean.TRUE);
            }
            catch (Exception e) {
                results.put("result", e);
            }
            return results;
        }
        this.getLog().info("Testing that startActivity() throws an IllegalStateException");
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115248);
        boolean failed = false;
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            results.put("result", Boolean.FALSE);
            failed = true;
        }
        catch (IllegalStateException ise) {
            results.put("result", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result", e);
        }
        if (failed) {
            try {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.getLog().warning("Exception caught while cleaning up failed test.", e);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115255() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115255);
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                try {
                    try {
                        this.fireEvent(handle, 1115255);
                        results.put("result", Boolean.FALSE);
                    }
                    catch (UnrecognizedActivityHandleException e) {
                        results.put("result", Boolean.TRUE);
                    }
                }
                finally {
                    this.endpoint.endActivityTransacted((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115257() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115257);
        boolean failed = false;
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                try {
                    try {
                        this.endpoint.endActivity((ActivityHandle)handle);
                        results.put("result", Boolean.FALSE);
                        failed = true;
                    }
                    catch (UnrecognizedActivityHandleException e) {
                        results.put("result", Boolean.TRUE);
                    }
                }
                finally {
                    block15: {
                        try {
                            this.endpoint.endActivityTransacted((ActivityHandle)handle);
                        }
                        catch (Exception e) {
                            if (failed) break block15;
                            throw e;
                        }
                    }
                }
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    private HashMap test1115258() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115258);
        boolean failed1 = false;
        try {
            this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
            results.put("result1", Boolean.FALSE);
            failed1 = true;
        }
        catch (TransactionRequiredLocalException trle) {
            results.put("result1", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        if (failed1) {
            try {
                this.endpoint.endActivityTransacted((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.getLog().warning("Exception caught while cleaning up failed test", e);
            }
        }
        boolean failed2 = false;
        try {
            this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle, 0);
            results.put("result2", Boolean.FALSE);
            failed2 = true;
        }
        catch (TransactionRequiredLocalException trle) {
            results.put("result2", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result2", e);
        }
        if (failed2) {
            try {
                this.endpoint.endActivityTransacted((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.getLog().warning("Exception caught while cleaning up failed test", e);
            }
        }
        return results;
    }

    private HashMap test1115263(Object argument) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        if ("startActivity".equals(argument)) {
            this.getLog().info("Creating activity in RA to prevent RA Entity from stopping");
            this.lastActivityHandle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115261);
            try {
                this.endpoint.startActivity((ActivityHandle)this.lastActivityHandle, (Object)this.lastActivityHandle);
                results.put("result", Boolean.TRUE);
            }
            catch (Exception e) {
                results.put("result", e);
            }
            return results;
        }
        if ("endActivity".equals(argument)) {
            this.getLog().info("Removing activity from RA to allow RA to transition into the Inactive state");
            try {
                this.endpoint.endActivity((ActivityHandle)this.lastActivityHandle);
                results.put("result", Boolean.TRUE);
            }
            catch (Exception e) {
                results.put("result", e);
            }
            return results;
        }
        this.getLog().info("Testing that startActivityTransacted(handle, handle) throws an IllegalStateException");
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115263);
        boolean failed1 = false;
        try {
            this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
            results.put("result1", Boolean.FALSE);
            failed1 = true;
        }
        catch (IllegalStateException ise) {
            results.put("result1", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        if (failed1) {
            try {
                this.endpoint.endActivityTransacted((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.getLog().warning("Exception caught while cleaning up failed test.", e);
            }
        }
        this.getLog().info("Testing that startActivityTransacted(handle, handle) throws an IllegalStateException");
        boolean failed2 = false;
        try {
            this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle, 0);
            results.put("result2", Boolean.FALSE);
            failed2 = true;
        }
        catch (IllegalStateException ise) {
            results.put("result2", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result2", e);
        }
        if (failed2) {
            try {
                this.endpoint.endActivityTransacted((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.getLog().warning("Exception caught while cleaning up failed test.", e);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115262() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        this.getLog().info("1) Checking for expected NullPointerException");
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted(null, null);
                    results.put("result1", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result1", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        this.getLog().info("2) Checking for expected NullPointerException");
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115262);
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, null);
                    results.put("result2", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result2", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result2", e);
        }
        this.getLog().info("3) Checking for expected NullPointerException");
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted(null, new Object());
                    results.put("result3", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result3", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result3", e);
        }
        this.getLog().info("4) Checking for expected NullPointerException");
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted(null, null, 0);
                    results.put("result4", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result4", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result4", e);
        }
        this.getLog().info("5) Checking for expected NullPointerException");
        handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115262);
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, null, 0);
                    results.put("result5", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result5", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result5", e);
        }
        this.getLog().info("6) Checking for expected NullPointerException");
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted(null, new Object(), 0);
                    results.put("result6", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result6", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result6", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115265(int sequenceID) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        this.getLog().info("1a) Checking behaviour of startActivityTransacted(handle, handle) against non-transacted activity");
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis() + 1L, 1115265, "1a");
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                    results.put("result1a", Boolean.FALSE);
                }
                catch (ActivityAlreadyExistsException aaee) {
                    results.put("result1a", Boolean.TRUE);
                }
                finally {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result1a", e);
        }
        this.getLog().info("1b) Checking behaviour of startActivityTransacted(handle, flags) against non-transacted activity");
        handle = new TCKActivityHandleImpl(System.currentTimeMillis() + 2L, 1115265, "1b");
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle, 0);
                    results.put("result1b", Boolean.FALSE);
                }
                catch (ActivityAlreadyExistsException aaee) {
                    results.put("result1b", Boolean.TRUE);
                }
                finally {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result1b", e);
        }
        this.getLog().info("2a) Checking behaviour of startActivityTransacted(handle, handle) against transacted activity");
        handle = new TCKActivityHandleImpl(System.currentTimeMillis() + 3L, 1115265, "2a");
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                try {
                    try {
                        this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                        results.put("result2a", Boolean.FALSE);
                    }
                    catch (ActivityAlreadyExistsException aaee) {
                        results.put("result2a", Boolean.TRUE);
                    }
                }
                finally {
                    this.endpoint.endActivityTransacted((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result2a", e);
        }
        this.getLog().info("2b) Checking behaviour of startActivityTransacted(handle, flags) against transacted activity");
        handle = new TCKActivityHandleImpl(System.currentTimeMillis() + 4L, 1115265, "2b");
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                try {
                    try {
                        this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle, 0);
                        results.put("result2b", Boolean.FALSE);
                    }
                    catch (ActivityAlreadyExistsException aaee) {
                        results.put("result2b", Boolean.TRUE);
                    }
                }
                finally {
                    this.endpoint.endActivityTransacted((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result2b", e);
        }
        this.getLog().info("3a) Checking behaviour of startActivityTransacted(handle, handle) against transacted activity from another transaction");
        handle = new TCKActivityHandleImpl(System.currentTimeMillis() + 5L, 1115265, "3a");
        try {
            this.getLog().info("Creating transaction A");
            this.transactionManager.beginSleeTransaction();
            try {
                this.getLog().info("Starting transacted activity in A");
                try {
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                }
                catch (Exception e) {
                    this.getLog().info("Exception caught during activity start in transaction A: ", e);
                }
                this.getLog().info("Firing transacted event on A");
                try {
                    this.fireEventTransacted(handle, sequenceID, "A");
                }
                catch (Exception e) {
                    this.getLog().info("Exception caught during event firing in transaction A: ", e);
                }
            }
            finally {
                this.getLog().info("Suspending transaction A");
                Transaction suspended = this.transactionManager.suspend();
                new Thread(new Test1115265Runnable(suspended, 10000)).start();
            }
            this.getLog().info("Creating transaction B");
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.getLog().info("Starting transacted activity in B");
                    this.endpoint.startActivityTransacted((ActivityHandle)handle, (Object)handle);
                    this.getLog().info("Firing transacted event on B");
                    this.fireEventTransacted(handle, sequenceID, "B");
                }
                catch (Exception e) {
                    this.getLog().info("Exception caught during test:", e);
                }
                this.getLog().info("Committing transaction B");
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            this.getLog().info("Exception caught during test:", e);
        }
        try {
            this.endpoint.endActivity((ActivityHandle)handle);
        }
        catch (Exception e) {
            this.getLog().info("Exception caught during test cleanup:", e);
        }
        results.put("result3", Boolean.TRUE);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115276() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115276);
        results.put("result1", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            this.getLog().severe("An error occured during test for assertion 1115276: ", e);
            results.put("result1", e);
        }
        return results;
    }

    private HashMap test1115276b() {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("result2", Boolean.TRUE);
        return results;
    }

    private HashMap test1115277(int sequenceID) {
        TCKActivityHandleImpl handle;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        this.lastActivityHandle = handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115277);
        results.put("result-ra1", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.fireEvent(handle, sequenceID);
        }
        catch (Exception e) {
            results.put("result-ra1", e);
        }
        return results;
    }

    private HashMap test1115277b() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        results.put("result-ra2", Boolean.TRUE);
        try {
            this.getLog().info("Ending activity from RA");
            this.endpoint.endActivity((ActivityHandle)this.lastActivityHandle);
            try {
                this.getLog().info("Firing event from RA on ending activity");
                this.fireEvent(this.lastActivityHandle, this.lastSequenceID, "ra");
            }
            catch (ActivityIsEndingException e) {
                this.getLog().info("Ignoring exception thrown when trying to fire an event on ending activity", e);
            }
        }
        catch (Exception e) {
            results.put("result-ra2", e);
        }
        return results;
    }

    private HashMap test1115278(int sequenceID) {
        TCKActivityHandleImpl handle;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        this.lastActivityHandle = handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115278);
        results.put("result-ra1", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.fireEvent(handle, sequenceID);
        }
        catch (Exception e) {
            results.put("result-ra1", e);
        }
        return results;
    }

    private HashMap test1115278b() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        results.put("result-ra2", Boolean.TRUE);
        try {
            this.getLog().info("Ending activity from RA");
            this.endpoint.endActivity((ActivityHandle)this.lastActivityHandle);
            this.getLog().info("Ending activity from RA (again)");
            this.endpoint.endActivity((ActivityHandle)this.lastActivityHandle);
        }
        catch (Exception e) {
            results.put("result-ra2", e);
        }
        return results;
    }

    private HashMap test1115280() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        try {
            this.endpoint.endActivity(null);
            results.put("result1", Boolean.FALSE);
        }
        catch (NullPointerException e) {
            results.put("result1", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115280);
        try {
            this.endpoint.endActivity((ActivityHandle)handle);
            results.put("result2", Boolean.FALSE);
        }
        catch (UnrecognizedActivityHandleException e) {
            results.put("result2", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result2", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115291() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        try {
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    this.endpoint.endActivityTransacted(null);
                    results.put("result1", Boolean.FALSE);
                }
                catch (NullPointerException e) {
                    results.put("result1", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        try {
            TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115291);
            try {
                this.transactionManager.beginSleeTransaction();
                try {
                    this.endpoint.endActivityTransacted((ActivityHandle)handle);
                    results.put("result2", Boolean.FALSE);
                }
                catch (UnrecognizedActivityHandleException e) {
                    results.put("result2", Boolean.TRUE);
                }
            }
            finally {
                this.transactionManager.rollback();
            }
        }
        catch (Exception e) {
            results.put("result2", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115298() {
        int ASSERTION_ID = 1115298;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        SimpleEvent event = new SimpleEvent(ASSERTION_ID);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                try {
                    this.endpoint.fireEvent(null, fireableEventType, (Object)event, null, null);
                    results.put("result1", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result1", Boolean.TRUE);
                }
                catch (Exception e) {
                    results.put("result1", e);
                }
                try {
                    this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, null, null, null);
                    results.put("result2", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result2", Boolean.TRUE);
                }
                catch (Exception e) {
                    results.put("result2", e);
                }
                try {
                    this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, null, null, null, 0);
                    results.put("result3", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result3", Boolean.TRUE);
                }
                catch (Exception e) {
                    results.put("result3", e);
                }
                try {
                    this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, null, null, null, 0);
                    results.put("result4", Boolean.FALSE);
                }
                catch (NullPointerException npe) {
                    results.put("result4", Boolean.TRUE);
                }
                catch (Exception e) {
                    results.put("result4", e);
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    private HashMap test1115299() {
        int ASSERTION_ID = 1115299;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        SimpleEvent event = new SimpleEvent(ASSERTION_ID);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            try {
                this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
                results.put("result1", Boolean.FALSE);
            }
            catch (UnrecognizedActivityHandleException e) {
                results.put("result1", Boolean.TRUE);
            }
            catch (Exception e) {
                results.put("result1", e);
            }
            try {
                this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null, 0);
                results.put("result2", Boolean.FALSE);
            }
            catch (UnrecognizedActivityHandleException e) {
                results.put("result2", Boolean.TRUE);
            }
            catch (Exception e) {
                results.put("result2", e);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115300() {
        int ASSERTION_ID = 1115300;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        SimpleEvent event = new SimpleEvent(ASSERTION_ID);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            IllegalFireableEventType illegalEventType = new IllegalFireableEventType();
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                try {
                    this.endpoint.fireEvent((ActivityHandle)handle, (FireableEventType)illegalEventType, (Object)event, null, null);
                    results.put("result1", Boolean.FALSE);
                }
                catch (IllegalEventException e) {
                    results.put("result1", Boolean.TRUE);
                }
                catch (Exception e) {
                    results.put("result1", e);
                }
                try {
                    this.endpoint.fireEvent((ActivityHandle)handle, (FireableEventType)illegalEventType, (Object)event, null, null, 0);
                    results.put("result2", Boolean.FALSE);
                }
                catch (IllegalEventException e) {
                    results.put("result2", Boolean.TRUE);
                }
                catch (Exception e) {
                    results.put("result2", e);
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115303(int sequenceID) {
        int ASSERTION_ID = 1115303;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = this.lastActivityHandle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        results.put("result1", Boolean.TRUE);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            SimpleEvent event = new SimpleEvent(sequenceID);
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    private HashMap test1115303b() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        SimpleEvent dummyEvent = new SimpleEvent(-1);
        EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        try {
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            try {
                this.endpoint.fireEvent((ActivityHandle)this.lastActivityHandle, fireableEventType, (Object)dummyEvent, null, null);
                results.put("result3", Boolean.FALSE);
            }
            catch (ActivityIsEndingException e) {
                this.getLog().info("fireEvent() correctly caused an ActivityIsEndingException to be thrown");
                results.put("result3", Boolean.TRUE);
            }
        }
        catch (Exception e) {
            results.put("result3", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115296(int sequenceID) {
        int ASSERTION_ID = 1115296;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        results.put("result1", Boolean.TRUE);
        try {
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                for (int i = 1; i <= 42; ++i) {
                    SimpleEvent event = new SimpleEvent(sequenceID, new Integer(i));
                    this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115306(int sequenceID) {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115306);
        results.put("result-ra", Boolean.TRUE);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.getLog().info("Starting transaction A");
                this.transactionManager.beginSleeTransaction();
                try {
                    this.getLog().info("Firing transacted event");
                    this.fireEventTransacted(handle, sequenceID, "A");
                }
                finally {
                    this.getLog().info("Committing transaction A");
                    this.transactionManager.commit();
                }
                this.getLog().info("Starting transaction B");
                this.transactionManager.beginSleeTransaction();
                try {
                    this.getLog().info("Firing transacted event");
                    this.fireEventTransacted(handle, sequenceID, "B");
                }
                finally {
                    this.getLog().info("Rolling back transaction B");
                    this.transactionManager.rollback();
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result-ra", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115308(int sequenceID) {
        int ASSERTION_ID = 1115308;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        results.put("result1", Boolean.TRUE);
        try {
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.transactionManager.beginSleeTransaction();
                try {
                    for (int i = 1; i <= 42; ++i) {
                        SimpleEvent event = new SimpleEvent(sequenceID, new Integer(i));
                        this.endpoint.fireEventTransacted((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
                    }
                }
                finally {
                    this.transactionManager.commit();
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115309() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115309);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.fireEventTransacted(handle, 0);
                results.put("result", Boolean.FALSE);
            }
            catch (TransactionRequiredLocalException trle) {
                results.put("result", Boolean.TRUE);
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115311() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115311);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                try {
                    try {
                        this.endpoint.fireEventTransacted((ActivityHandle)handle, fireableEventType, null, null, null);
                        results.put("result1", Boolean.FALSE);
                    }
                    catch (NullPointerException npe) {
                        results.put("result1", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    try {
                        this.endpoint.fireEventTransacted(null, fireableEventType, (Object)new SimpleEvent(0), null, null);
                        results.put("result2", Boolean.FALSE);
                    }
                    catch (NullPointerException npe) {
                        results.put("result2", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result2", e);
                    }
                }
                finally {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115312() {
        FireableEventType fireableEventType;
        EventTypeID eventTypeID;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), 1115312, "(1115312a) valid activity handle");
        TCKActivityHandleImpl badHandle = new TCKActivityHandleImpl(System.currentTimeMillis(), 987654321, "(1115312a) invalid activity handle");
        try {
            eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                try {
                    try {
                        this.endpoint.fireEventTransacted((ActivityHandle)badHandle, fireableEventType, (Object)new SimpleEvent(0), null, null);
                        results.put("result1", Boolean.FALSE);
                    }
                    catch (UnrecognizedActivityHandleException uahe) {
                        results.put("result1", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                }
                finally {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        handle = new TCKActivityHandleImpl(System.currentTimeMillis() + 1L, 1115312, "(1115312b) valid activity handle");
        badHandle = new TCKActivityHandleImpl(System.currentTimeMillis() + 1L, 987654321, "(1115312b) invalid activity handle");
        try {
            eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            this.transactionManager.beginSleeTransaction();
            try {
                this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
                try {
                    try {
                        this.endpoint.fireEventTransacted((ActivityHandle)badHandle, fireableEventType, (Object)new SimpleEvent(1), null, null, 0);
                        results.put("result2", Boolean.FALSE);
                    }
                    catch (UnrecognizedActivityHandleException uahe) {
                        results.put("result2", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result2", e);
                    }
                }
                finally {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
            }
            finally {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            results.put("result2", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115313() {
        int ASSERTION_ID = 1115313;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        SimpleEvent event = new SimpleEvent(ASSERTION_ID);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            IllegalFireableEventType illegalEventType = new IllegalFireableEventType();
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    try {
                        this.endpoint.fireEventTransacted((ActivityHandle)handle, (FireableEventType)illegalEventType, (Object)event, null, null);
                        results.put("result1", Boolean.FALSE);
                    }
                    catch (IllegalEventException e) {
                        results.put("result1", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    try {
                        this.endpoint.fireEventTransacted((ActivityHandle)handle, (FireableEventType)illegalEventType, (Object)event, null, null, 0);
                        results.put("result2", Boolean.FALSE);
                    }
                    catch (IllegalEventException e) {
                        results.put("result2", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result2", e);
                    }
                }
                finally {
                    this.transactionManager.commit();
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115314() {
        int ASSERTION_ID = 1115314;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        CustomEventObject event = new CustomEventObject(ASSERTION_ID);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            this.transactionManager.beginSleeTransaction();
            try {
                try {
                    try {
                        this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
                        results.put("result1", Boolean.FALSE);
                    }
                    catch (IllegalEventException e) {
                        results.put("result1", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result1", e);
                    }
                    try {
                        this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null, 0);
                        results.put("result2", Boolean.FALSE);
                    }
                    catch (IllegalEventException e) {
                        results.put("result2", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        results.put("result2", e);
                    }
                }
                finally {
                    this.transactionManager.commit();
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115316(int sequenceID) {
        int ASSERTION_ID = 1115316;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = this.lastActivityHandle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        results.put("result1", Boolean.TRUE);
        try {
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            SimpleEvent event = new SimpleEvent(sequenceID);
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.transactionManager.beginSleeTransaction();
                try {
                    this.endpoint.fireEventTransacted((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
                }
                finally {
                    this.transactionManager.commit();
                }
            }
            finally {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
        }
        catch (Exception e) {
            results.put("result1", e);
        }
        return results;
    }

    private HashMap test1115316b() {
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        SimpleEvent dummyEvent = new SimpleEvent(-1);
        EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        try {
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            try {
                this.endpoint.fireEventTransacted((ActivityHandle)this.lastActivityHandle, fireableEventType, (Object)dummyEvent, null, null);
                results.put("result3", Boolean.FALSE);
            }
            catch (ActivityIsEndingException e) {
                this.getLog().info("fireEvent() correctly caused an ActivityIsEndingException to be thrown");
                results.put("result3", Boolean.TRUE);
            }
        }
        catch (Exception e) {
            results.put("result3", e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115417() {
        int ASSERTION_ID = 1115417;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            try {
                this.getLog().info("(1) Checking suspendActivity() is mandatory transactional.");
                this.endpoint.suspendActivity((ActivityHandle)handle);
                results.put("result1", Boolean.FALSE);
                this.getLog().severe("(1) suspendActivity() did not throw TransactionRequiredLocalException outside a transactional context");
            }
            catch (TransactionRequiredLocalException e) {
                this.getLog().info("(1) suspendActivity() correctly threw TransactionRequiredLocalException outside a transactional context");
                results.put("result1", Boolean.TRUE);
            }
        }
        catch (Exception e) {
            results.put("result", e);
        }
        finally {
            try {
                this.endpoint.endActivity((ActivityHandle)handle);
            }
            catch (Exception e) {
                this.getLog().severe("An error occured during test cleanup - could not end activity: " + handle);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115413(int sequenceID) {
        int ASSERTION_ID = 0x110515;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            SimpleEvent event = new SimpleEvent(sequenceID, "from RA");
            this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
            results.put("result-ra1", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result-ra1", e);
        }
        finally {
            this.endpoint.endActivity((ActivityHandle)handle);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115420() {
        int ASSERTION_ID = 1115420;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID, "(1)");
        boolean started = false;
        this.getLog().info("(1) Checking startActivitySuspended() is mandatory transactional.");
        try {
            this.endpoint.startActivitySuspended((ActivityHandle)handle, (Object)handle);
            started = true;
            this.getLog().severe("(1) startActivitySuspended() did not throw TransactionRequiredLocalException outside of a transactional context");
            results.put("result1", Boolean.FALSE);
        }
        catch (TransactionRequiredLocalException e) {
            this.getLog().info("(1) startActivitySuspended() correctly threw TransactionRequiredLocalException outside of a transactional context");
            results.put("result1", Boolean.TRUE);
        }
        catch (Exception e) {
            this.getLog().info("(1) startActivitySuspended() threw an unexpected exception outside of a transactional context");
            results.put("result1", e);
        }
        finally {
            if (started) {
                try {
                    this.endpoint.endActivity((ActivityHandle)handle);
                }
                catch (Exception e) {
                    this.getLog().warning("(1) An exception was thrown trying to clean up test state.", e);
                }
            }
        }
        handle = new TCKActivityHandleImpl(System.currentTimeMillis() + 1L, ASSERTION_ID, "(2)");
        try {
            this.getContext().getSleeTransactionManager().begin();
            this.getLog().info("(2) Checking startActivitySuspended() is mandatory transactional.");
            started = false;
            try {
                this.endpoint.startActivitySuspended((ActivityHandle)handle, (Object)handle);
                started = true;
                this.getLog().info("(2) startActivitySuspended() correctly did not throw a TransactionRequiredLocalException inside of a transactional context");
                results.put("result2", Boolean.TRUE);
            }
            catch (TransactionRequiredLocalException e) {
                this.getLog().info("(2) startActivitySuspended() incorrectly threw a TransactionRequiredLocalException inside of a transactional context");
                results.put("result2", Boolean.FALSE);
            }
            catch (Exception e) {
                this.getLog().info("(2) startActivitySuspended() threw an unexpected exception inside of a transactional context");
                results.put("result2", e);
            }
            finally {
                if (started) {
                    try {
                        this.endpoint.endActivity((ActivityHandle)handle);
                    }
                    catch (Exception e) {
                        this.getLog().warning("(2) An exception was thrown trying to clean up test state.", e);
                    }
                }
            }
            this.getContext().getSleeTransactionManager().rollback();
        }
        catch (Exception e) {
            this.getLog().warning("(2) Unexpected exeption thrown during test", e);
            results.put("result2", e);
            return results;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap test1115418(int sequenceID) {
        int ASSERTION_ID = 1115418;
        HashMap<String, Serializable> results = new HashMap<String, Serializable>();
        TCKActivityHandleImpl handle = new TCKActivityHandleImpl(System.currentTimeMillis(), ASSERTION_ID);
        try {
            this.endpoint.startActivity((ActivityHandle)handle, (Object)handle);
            EventTypeID eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fireableEventType = this.getContext().getEventLookupFacility().getFireableEventType(eventTypeID);
            SimpleEvent event = new SimpleEvent(sequenceID, "from RA");
            this.endpoint.fireEvent((ActivityHandle)handle, fireableEventType, (Object)event, null, null);
            results.put("result-ra1", Boolean.TRUE);
        }
        catch (Exception e) {
            results.put("result-ra1", e);
        }
        finally {
            this.endpoint.endActivity((ActivityHandle)handle);
        }
        return results;
    }

    class CustomEventObject {
        private final int assertionID;

        public CustomEventObject(int assertionID) {
            this.assertionID = assertionID;
        }

        public String toString() {
            return "CustomEventObject[" + this.assertionID + "]";
        }
    }

    public class IllegalFireableEventType
    implements FireableEventType {
        public ClassLoader getEventClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }

        public String getEventClassName() {
            return "com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent";
        }

        public EventTypeID getEventType() {
            return new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        }
    }

    private class Test1115265Runnable
    implements Runnable {
        private final Transaction transaction;
        private final int sleepPeriod;

        public Test1115265Runnable(Transaction transaction, int sleepPeriod) {
            this.sleepPeriod = sleepPeriod;
            this.transaction = transaction;
        }

        public void run() {
            try {
                EndpointResourceAdaptor.this.getLog().info("Resuming transaction A in " + this.sleepPeriod + "ms");
                Thread.sleep(this.sleepPeriod);
                EndpointResourceAdaptor.this.getLog().info("Resuming transaction A");
                EndpointResourceAdaptor.this.transactionManager.resume(this.transaction);
                EndpointResourceAdaptor.this.getLog().info("Committing transaction A");
                this.transaction.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class EndpointMessageListener
    extends UnicastRemoteObject
    implements MessageHandler {
        private transient EndpointResourceAdaptor ra = null;

        public EndpointMessageListener(EndpointResourceAdaptor ra) throws RemoteException {
            this.ra = ra;
        }

        public boolean handleMessage(Object obj) throws RemoteException {
            if (!EndpointResourceAdaptor.this.isConfigured()) {
                return false;
            }
            this.ra.getLog().info("Received message from test: " + obj.toString());
            TCKMessage message = (TCKMessage)obj;
            int sequenceID = message.getSequenceID();
            EndpointResourceAdaptor.this.lastSequenceID = sequenceID;
            int methodID = message.getMethod();
            HashMap results = null;
            Object argument = message.getArgument();
            int assertion = -1;
            if (argument instanceof Integer) {
                assertion = (Integer)argument;
            }
            if (argument instanceof HashMap) {
                HashMap arguments = (HashMap)argument;
                assertion = (Integer)arguments.get("assertion");
                argument = arguments.get("argument");
            }
            switch (assertion) {
                case 1115211: {
                    results = EndpointResourceAdaptor.this.test1115211();
                    break;
                }
                case 1115247: {
                    results = EndpointResourceAdaptor.this.test1115247();
                    break;
                }
                case 1115248: {
                    results = EndpointResourceAdaptor.this.test1115248(argument);
                    break;
                }
                case 1115214: {
                    results = EndpointResourceAdaptor.this.test1115214();
                    break;
                }
                case 1115215: {
                    results = EndpointResourceAdaptor.this.test1115215();
                    break;
                }
                case 1115217: {
                    results = EndpointResourceAdaptor.this.test1115217();
                    break;
                }
                case 1115258: {
                    results = EndpointResourceAdaptor.this.test1115258();
                    break;
                }
                case 1115262: {
                    results = EndpointResourceAdaptor.this.test1115262();
                    break;
                }
                case 1115263: {
                    results = EndpointResourceAdaptor.this.test1115263(argument);
                    break;
                }
                case 1115265: {
                    results = EndpointResourceAdaptor.this.test1115265(sequenceID);
                    break;
                }
                case 1115257: {
                    results = EndpointResourceAdaptor.this.test1115257();
                    break;
                }
                case 1115276: {
                    results = EndpointResourceAdaptor.this.test1115276();
                    break;
                }
                case 1115280: {
                    results = EndpointResourceAdaptor.this.test1115280();
                    break;
                }
                case 1115277: {
                    results = EndpointResourceAdaptor.this.test1115277(sequenceID);
                    break;
                }
                case 1115278: {
                    results = EndpointResourceAdaptor.this.test1115278(sequenceID);
                    break;
                }
                case 1115231: {
                    results = EndpointResourceAdaptor.this.test1115231();
                    break;
                }
                case 1115240: {
                    results = EndpointResourceAdaptor.this.test1115240();
                    break;
                }
                case 1115232: {
                    results = EndpointResourceAdaptor.this.test1115232(sequenceID);
                    break;
                }
                case 1115233: {
                    results = EndpointResourceAdaptor.this.test1115233(sequenceID);
                    break;
                }
                case 1115234: {
                    results = EndpointResourceAdaptor.this.test1115234(sequenceID);
                    break;
                }
                case 1115238: {
                    results = EndpointResourceAdaptor.this.test1115238(sequenceID);
                    break;
                }
                case 1115255: {
                    results = EndpointResourceAdaptor.this.test1115255();
                    break;
                }
                case 1115298: {
                    results = EndpointResourceAdaptor.this.test1115298();
                    break;
                }
                case 1115299: {
                    results = EndpointResourceAdaptor.this.test1115299();
                    break;
                }
                case 1115300: {
                    results = EndpointResourceAdaptor.this.test1115300();
                    break;
                }
                case 1115303: {
                    results = EndpointResourceAdaptor.this.test1115303(sequenceID);
                    break;
                }
                case 1115296: {
                    results = EndpointResourceAdaptor.this.test1115296(sequenceID);
                    break;
                }
                case 1115241: {
                    results = EndpointResourceAdaptor.this.test1115241(sequenceID);
                    break;
                }
                case 1115242: {
                    results = EndpointResourceAdaptor.this.test1115242(sequenceID);
                    break;
                }
                case 1115306: {
                    results = EndpointResourceAdaptor.this.test1115306(sequenceID);
                    break;
                }
                case 1115308: {
                    results = EndpointResourceAdaptor.this.test1115308(sequenceID);
                    break;
                }
                case 1115309: {
                    results = EndpointResourceAdaptor.this.test1115309();
                    break;
                }
                case 1115311: {
                    results = EndpointResourceAdaptor.this.test1115311();
                    break;
                }
                case 1115312: {
                    results = EndpointResourceAdaptor.this.test1115312();
                    break;
                }
                case 1115313: {
                    results = EndpointResourceAdaptor.this.test1115313();
                    break;
                }
                case 1115314: {
                    results = EndpointResourceAdaptor.this.test1115314();
                    break;
                }
                case 1115316: {
                    results = EndpointResourceAdaptor.this.test1115316(sequenceID);
                    break;
                }
                case 1115291: {
                    results = EndpointResourceAdaptor.this.test1115291();
                    break;
                }
                case 1115417: {
                    results = EndpointResourceAdaptor.this.test1115417();
                    break;
                }
                case 0x110515: {
                    results = EndpointResourceAdaptor.this.test1115413(sequenceID);
                    break;
                }
                case 1115420: {
                    results = EndpointResourceAdaptor.this.test1115420();
                    break;
                }
                case 1115418: {
                    results = EndpointResourceAdaptor.this.test1115418(sequenceID);
                    break;
                }
                default: {
                    this.ra.getLog().warning("Unhandled message received from test: " + message);
                    return false;
                }
            }
            if (results != null) {
                EndpointResourceAdaptor.this.sendEndpointMessage(sequenceID, methodID, results);
            }
            return true;
        }
    }
}

