/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileverification;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.profileverification.IndexedProfileManagementProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;

public class ProfileVerificationTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME = "tck.ProfileVerificationTest.table";
    public static final String PROFILE_SPEC_NAME = "IndexedProfile";
    public static final String VALUE_1 = "value1";
    public static final String INVALID_VALUE = "invalid value";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;
    private Vector activeProxies;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.ProfileVerificationTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        String name = "A";
        this.getLog().info("Creating profile A");
        ObjectName jmxObjectName = profileProvisioning.createProfile(PROFILE_TABLE_NAME, "A");
        IndexedProfileManagementProxy proxy = this.getProfileProxy(jmxObjectName);
        proxy.editProfile();
        proxy.setValue(VALUE_1);
        proxy.setVerifyStatus(false);
        proxy.commitProfile();
        Assert.assertTrue(4343, "profileVerify() was not called in response to a request to commit profile changes", proxy.getVerifyStatus());
        Assert.assertTrue(4365, "Profile should have been restored to read only state by commitProfile()", !proxy.isProfileWriteable());
        proxy.editProfile();
        proxy.setValue(INVALID_VALUE);
        try {
            proxy.commitProfile();
            Assert.fail(1946, "Expected javax.slee.ProfileVerificationException not thrown");
        }
        catch (ProfileVerificationException e) {
            this.getLog().info("Correct javax.slee.ProfileVerificationException received");
        }
        Assert.assertTrue(4365, "Profile should remain in a writable state if commitProfile() fails to commit the profile", proxy.isProfileWriteable());
        proxy.restoreProfile();
        this.getLog().info("Set table2 to two non-unique values");
        proxy.editProfile();
        proxy.setTable2(new String[]{"one", "one"});
        proxy.commitProfile();
        this.getLog().info("Set table1 to two unique values");
        proxy.editProfile();
        proxy.setTable1(new String[]{"one", "two"});
        proxy.commitProfile();
        this.getLog().info("Set table1 to two non-unique values");
        proxy.editProfile();
        proxy.setTable1(new String[]{"one", "one"});
        try {
            proxy.commitProfile();
            Assert.fail(4368, "Expected javax.slee.ProfileVerificationException not thrown when unique indexed attribute contains duplicate entries");
        }
        catch (ProfileVerificationException e) {
            // empty catch block
        }
        proxy.restoreProfile();
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                IndexedProfileManagementProxy aProxy = (IndexedProfileManagementProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private IndexedProfileManagementProxy getProfileProxy(ObjectName mbeanName) {
        IndexedProfileManagementProxy rProxy = new IndexedProfileManagementProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

