/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profiletxcontext;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.profiletxcontext.CheckProfileTXProfileProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;

public class ProfileTXContextTest
extends AbstractSleeTCKTest {
    private static final String TABLE_NAME = "tck.CheckLProfileTXTest.table";
    private static final String PROFILE_SPEC_NAME = "CheckProfileTXProfile";
    private static final String INITIAL_VALUE = "INITIALIZED";
    private static final String CHANGED_VALUE = "CHANGED_VALUE";
    private static final int PROFILE_STORE_AFTER_PROFILE_LOAD_ASSERTION = 1940;
    private static final int PROFILE_METHODS_SHARE_TXN_CONTEXT_ASSERTION = 1941;
    private ProfileUtils profileUtils;
    private Vector activeProxies;
    private boolean isTableCreated;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.CheckLProfileTXTest.table");
        profileProvisioning.createProfileTable(profileSpecID, TABLE_NAME);
        this.isTableCreated = true;
        ObjectName profileJmxName = profileProvisioning.getDefaultProfile(TABLE_NAME);
        CheckProfileTXProfileProxy proxy = this.getProfileProxy(profileJmxName);
        String[] initialValues = new String[]{proxy.getValue2(), proxy.getValue3(), proxy.getValue2InManagementMethod(), proxy.getValue1InProfileStore(), proxy.getValue2InProfileStore(), proxy.getValue3InProfileStore()};
        for (int i = 0; i < initialValues.length; ++i) {
            if (INITIAL_VALUE.equals(initialValues[i])) continue;
            return TCKTestResult.error("One or more CMP fields were not set to the expected value INITIALIZED at the start of the test.");
        }
        this.getLog().fine("Starting to edit to profile");
        proxy.editProfile();
        this.getLog().fine("Setting value 2 via a CMP setter");
        proxy.setValue2(CHANGED_VALUE);
        this.getLog().fine("Setting value 3 via a management method");
        proxy.setValue3ViaManagementMethod(CHANGED_VALUE);
        Assert.assertEquals(1941, "The change made to value 2 was not visible to management method setValue3ViaManagementMethod()", CHANGED_VALUE, proxy.getValue2InManagementMethod());
        if (!CHANGED_VALUE.equals(proxy.getValue2())) {
            return TCKTestResult.error("A change made to value 2 was not visible to the client");
        }
        if (!CHANGED_VALUE.equals(proxy.getValue3())) {
            return TCKTestResult.error("A change made to value 3 was not visible to the client");
        }
        this.getLog().fine("Marking the profile as invalid, then will try to commit the profile, to cause profileStore() to be called");
        proxy.setValid(false);
        try {
            proxy.commitProfile();
            return TCKTestResult.error("Attempt to commit an invalid profile did not throw the expected ProfileVerificationException");
        }
        catch (ProfileVerificationException e) {
            this.getLog().finest("OK - Received expected ProfileVerificationException when trying to commit an invalid profile");
            this.getLog().fine("Checking the values seen in profileStore()");
            this.checkFieldInProfileStore("Value2", proxy.getValue2InProfileStore());
            this.checkFieldInProfileStore("Value3", proxy.getValue3InProfileStore());
            Assert.assertEquals(1940, "profileStore() was called, and it's changes were kept, but changes to instance state made in profileLoad() were not visible to profileStore(), indicating that either profileLoad() was not called, or that profileLoad() and profileStore() were called on different objects.", CHANGED_VALUE, proxy.getValue1InProfileStore());
            this.getLog().fine("Restoring the profile");
            proxy.restoreProfile();
            this.checkFieldRolledBack("Value2", proxy.getValue2());
            this.checkFieldRolledBack("Value3", proxy.getValue3());
            this.checkFieldRolledBack("Value2InManagementMethod", proxy.getValue2InManagementMethod());
            this.checkFieldRolledBack("Value1InProfileStore", proxy.getValue1InProfileStore());
            this.checkFieldRolledBack("Value2InProfileStore", proxy.getValue2InProfileStore());
            this.checkFieldRolledBack("Value3InProfileStore", proxy.getValue3InProfileStore());
            this.getLog().info("All checks passed");
            return TCKTestResult.passed();
        }
    }

    private void checkFieldInProfileStore(String cmpFieldName, String cmpFieldValue) throws TCKTestFailureException {
        Assert.assertEquals(1941, "A change made to CMP field " + cmpFieldName + " was not visible in profileStore(). (Or possibly the changes made in profileStore() were not kept" + " after the verification failure -- this would also be invalid as the profile has not been restored)", CHANGED_VALUE, cmpFieldValue);
    }

    private void checkFieldRolledBack(String cmpFieldName, String cmpFieldValue) throws TCKTestFailureException {
        Assert.assertEquals(1941, "Some changes made to the profile methods were still visible after the transaction had been rolled back by restoring the profile. This indicates that the changes were not made as within the same transaction context, or were not transactional at all. CMP field expected to be rolled back: " + cmpFieldName, INITIAL_VALUE, cmpFieldValue);
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                CheckProfileTXProfileProxy aProxy = (CheckProfileTXProfileProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.isTableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        this.profileUtils = null;
        this.isTableCreated = false;
        this.activeProxies = null;
        super.tearDown();
    }

    private CheckProfileTXProfileProxy getProfileProxy(ObjectName mbeanName) {
        CheckProfileTXProfileProxy rProxy = new CheckProfileTXProfileProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

