/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profiletable;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110132Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String EVENT_DU_PATH_PARAM = "eventDUPath";
    private static final String SPEC_NAME = "Test1110132Profile";
    private static final String SPEC_VERSION = "1.0";
    public static final int TEST_ID = 1110132;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private QueuingResourceListener resourceListener;

    public TCKTestResult run() throws Exception {
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, "Test1110132ProfileTable");
        this.getLog().fine("Added profile table Test1110132ProfileTable");
        this.profileProvisioning.createProfileTable(specID, "Test1110132ProfileTable2");
        this.getLog().fine("Added profile table Test1110132ProfileTable2");
        this.getLog().fine("Start sending events to SLEE to get Sbb to do the ProfileTable interface tests...");
        this.sendResourceEvent(0);
        this.sendResourceEvent(3);
        this.sendResourceEvent(1);
        this.sendResourceEvent(2);
        this.sendResourceEvent(4);
        this.sendResourceEvent(5);
        this.sendResourceEvent(6);
        this.sendResourceEvent(12);
        this.sendResourceEvent(8);
        this.sendResourceEvent(9);
        this.sendResourceEvent(7);
        this.sendResourceEvent(10);
        this.getLog().fine("Completed test sequence successfully.");
        return TCKTestResult.passed();
    }

    public void sendResourceEvent(int operationID) throws TCKTestErrorException, RemoteException, TCKTestFailureException {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        Integer message = new Integer(operationID);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", message, activityID, null);
        try {
            TCKSbbMessage reply = this.resourceListener.nextMessage();
            HashMap map = (HashMap)reply.getMessage();
            int type = (Integer)map.get("Type");
            switch (type) {
                case 0: {
                    String msg = (String)map.get("Msg");
                    int id = (Integer)map.get("ID");
                    boolean result = (Boolean)map.get("Result");
                    if (result) {
                        this.getLog().fine(id + ": " + msg);
                        break;
                    }
                    this.getLog().fine("FAILURE: " + msg);
                    throw new TCKTestFailureException(id, msg);
                }
            }
        }
        catch (OperationTimedOutException ex) {
            throw new TCKTestErrorException("Timed out waiting for processing of initial resource event.", ex);
        }
    }

    public void setUp() throws Exception {
        this.setupService(EVENT_DU_PATH_PARAM);
        this.setupService(SERVICE_DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        this.resourceListener = new QueuingResourceListener(this.utils()){

            public Object onSbbCall(Object argument) throws Exception {
                HashMap map = (HashMap)argument;
                int type = (Integer)map.get("Type");
                switch (type) {
                    case 1: {
                        Test1110132Test.this.getLog().fine((String)map.get("Msg"));
                    }
                }
                return null;
            }
        };
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("Test1110132ProfileTable");
            this.profileUtils.removeProfileTable("Test1110132ProfileTable2");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

