/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profiletable;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEventImpl;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbBaseMessageComposer;
import com.opencloud.sleetck.lib.testsuite.profiles.profiletable.MyCMPType;
import com.opencloud.sleetck.lib.testsuite.profiles.profiletable.Test1110132ProfileLocal;
import com.opencloud.sleetck.lib.testsuite.profiles.profiletable.Test1110132ProfileTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.profile.ProfileAlreadyExistsException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileTable;

public abstract class Test1110132Sbb
extends BaseTCKSbb {
    public static final String PROFILE_TABLE_NAME = "Test1110132ProfileTable";
    public static final String PROFILE_TABLE_NAME2 = "Test1110132ProfileTable2";
    public static final String PROFILE_NAME = "Test1110132Profile";
    public static final String PROFILE_NAME2 = "Test1110132Profile2";
    public static final String PROFILE_NAME3 = "Test1110132Profile3";
    public static final int CREATE_COMMIT_PROFILE = 0;
    public static final int CREATE_ROLLBACK_PROFILE = 1;
    public static final int CHECK_ROLLBACK_PROFILE = 2;
    public static final int CHECK_COMMIT_PROFILE = 3;
    public static final int FIND_PROFILE = 4;
    public static final int FIND_PROFILE_INDEXED = 5;
    public static final int FIND_PROFILES_INDEXED = 6;
    public static final int REMOVE_COMMIT_PROFILE = 7;
    public static final int REMOVE_ROLLBACK_PROFILE = 8;
    public static final int CHECK_REMOVE_ROLLBACK = 9;
    public static final int CHECK_REMOVE_COMMIT = 10;
    public static final int SEND_TEST_MSG = 11;
    public static final int STATIC_QUERY = 12;

    private void sendLogMsgCall(String msg) {
        HashMap map = SbbBaseMessageComposer.getLogMsg(msg);
        try {
            TCKSbbUtils.getResourceInterface().callTest(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResult(boolean result, int id, String msg, ActivityContextInterface aci) {
        HashMap map = SbbBaseMessageComposer.getSetResultMsg(result, id, msg);
        this.fireTCKSbbEvent(new TCKSbbEventImpl(map), aci, null);
    }

    private void do_CREATE_COMMIT_PROFILE(Test1110132ProfileTable profileTable, ActivityContextInterface aci) throws Exception {
        try {
            profileTable.create(null);
            this.sendResult(false, 1110137, "create(null) should have thrown a NullPointerException.", aci);
            return;
        }
        catch (NullPointerException e) {
            this.sendLogMsgCall("create(null) threw NullPointerException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110137, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: NullPointerException", aci);
            return;
        }
        try {
            Character ch = new Character('\u0019');
            profileTable.create(ch.toString());
            this.sendResult(false, 1110138, "create('" + ch.toString() + "') should have thrown an IllegalArgumentException.", aci);
            return;
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("create('\u0019') threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110138, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        try {
            Character ch = new Character('\u007f');
            profileTable.create(ch.toString());
            this.sendResult(false, 1110138, "create('" + ch.toString() + "') should have thrown an IllegalArgumentException.", aci);
            return;
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("create('\u007f') threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110138, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        try {
            profileTable.create("Test1110132CreateExceptionProfile");
            this.sendResult(false, 1110141, "create(\"Test1110132CreateExceptionProfile\") should have thrown a CreateException.", aci);
            return;
        }
        catch (CreateException e) {
            this.sendLogMsgCall("create(\"Test1110132CreateExceptionProfile\") threw CreateException propagated from profile abstract class's profilePostCreate() method as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110141, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: CreateException.", aci);
            return;
        }
        Test1110132ProfileLocal profileLocal = (Test1110132ProfileLocal)profileTable.create(PROFILE_NAME);
        this.sendResult(true, 1110132, "Testsequence CREATE_COMMIT_PROFILE successful.", aci);
    }

    private void do_CHECK_COMMIT_PROFILE(Test1110132ProfileTable profileTable, ActivityContextInterface aci) {
        Test1110132ProfileLocal profileLocal = (Test1110132ProfileLocal)profileTable.find(PROFILE_NAME);
        if (profileLocal != null) {
            this.sendResult(true, 1110132, "Creating and committing profile Test1110132Profile worked fine.", aci);
        } else {
            this.sendResult(false, 1110132, "Creating and committing profile Test1110132Profile failed.", aci);
        }
    }

    private void do_CREATE_ROLLBACK_PROFILE(Test1110132ProfileTable profileTable, ActivityContextInterface aci) throws Exception {
        try {
            profileTable.create(PROFILE_NAME);
            this.sendResult(false, 1110140, "create(\"Test1110132Profile\") should have thrown a ProfileAlreadyExistsException.", aci);
            return;
        }
        catch (ProfileAlreadyExistsException e) {
            this.sendLogMsgCall("create(\"Test1110132Profile\") threw ProfileAlreadyExistsException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110140, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: ProfileAlreadyExistsException", aci);
            return;
        }
        profileTable.create(PROFILE_NAME2);
        this.getSbbContext().setRollbackOnly();
        this.sendLogMsgCall("Creating profile Test1110132Profile2 then marking transaction for rollback.");
    }

    private void do_CHECK_ROLLBACK_PROFILE(Test1110132ProfileTable profileTable, ActivityContextInterface aci) {
        if (profileTable.find(PROFILE_NAME2) == null) {
            this.sendResult(true, 1110135, "Creating profile Test1110132Profile2 followed by rollback worked fine.", aci);
        } else {
            this.sendResult(false, 1110135, "Profile Test1110132Profile2 was created though transaction was rolled back.", aci);
        }
    }

    private void do_FIND_PROFILE(Test1110132ProfileTable profileTable, ActivityContextInterface aci) throws Exception {
        try {
            profileTable.find(null);
            this.sendResult(false, 1110147, "find(null) should have thrown a NullPointerException.", aci);
            return;
        }
        catch (NullPointerException e) {
            this.sendLogMsgCall("find(null) threw NullPointerException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110147, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: NullPointerException", aci);
            return;
        }
        Test1110132ProfileLocal profileLocal3 = (Test1110132ProfileLocal)profileTable.create(PROFILE_NAME3);
        Collection col = profileTable.findAll();
        Iterator iter = col.iterator();
        Hashtable<String, Test1110132ProfileLocal> tab = new Hashtable<String, Test1110132ProfileLocal>();
        while (iter.hasNext()) {
            Test1110132ProfileLocal prof = (Test1110132ProfileLocal)iter.next();
            tab.put(prof.getProfileName(), prof);
        }
        if (col.size() != 2 || !tab.containsKey(PROFILE_NAME) || !tab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110148, "Wrong number of profiles or some profiles were missing from the collection returned by findAll()", aci);
            return;
        }
        this.sendLogMsgCall("findAll() returned the correct list of profiles.");
        try {
            col.add("1");
            this.sendResult(false, 1110151, "Modification attempt on collection object should have caused a UnsupportedOperationException.", aci);
            return;
        }
        catch (UnsupportedOperationException e) {
            this.sendLogMsgCall("Modification attempt on collection object caused UnsupportedOperationException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110151, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: UnsupportedOperationException", aci);
            return;
        }
        try {
            col.clear();
            this.sendResult(false, 1110151, "Modification attempt on collection object should have caused a UnsupportedOperationException.", aci);
            return;
        }
        catch (UnsupportedOperationException e) {
            this.sendLogMsgCall("Modification attempt on collection object caused UnsupportedOperationException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110151, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: UnsupportedOperationException", aci);
            return;
        }
        try {
            col.remove("1");
            this.sendResult(false, 1110151, "Modification attempt on collection object should have caused a UnsupportedOperationException.", aci);
            return;
        }
        catch (UnsupportedOperationException e) {
            this.sendLogMsgCall("Modification attempt on collection object caused UnsupportedOperationException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110151, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: UnsupportedOperationException", aci);
            return;
        }
        Context env = TCKSbbUtils.getSbbEnvironment();
        ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
        ProfileTable profileTable2 = profileFacility.getProfileTable(PROFILE_TABLE_NAME2);
        Collection col2 = profileTable2.findAll();
        if (col2.size() != 0) {
            this.sendResult(false, 1110152, "Collection returned by findAll() should be empty as profile table Test1110132ProfileTable2 does not contain any profiles.", aci);
            return;
        }
        this.sendResult(true, 1110132, "Testsequence FIND_PROFILE successful.", aci);
    }

    private void do_FIND_PROFILE_INDEXED(Test1110132ProfileTable profileTable, ActivityContextInterface aci) throws Exception {
        Test1110132ProfileLocal profileLocal = (Test1110132ProfileLocal)profileTable.find(PROFILE_NAME);
        Test1110132ProfileLocal profileLocal3 = (Test1110132ProfileLocal)profileTable.find(PROFILE_NAME3);
        profileLocal3.setStringValue("42");
        profileLocal3.setIntValue(42);
        profileLocal3.setIntObjValue(new Integer(42));
        profileLocal3.setCharValue('X');
        profileLocal3.setCharObjValue(new Character('X'));
        profileLocal3.setBoolValue(true);
        profileLocal3.setBoolObjValue(new Boolean(true));
        profileLocal3.setAddress(new Address(AddressPlan.SLEE_PROFILE, "XY/A"));
        profileLocal.setStringValue("41");
        profileLocal.setIntValue(41);
        profileLocal.setIntObjValue(new Integer(41));
        profileLocal.setCharValue('Y');
        profileLocal.setCharObjValue(new Character('Y'));
        profileLocal.setBoolValue(false);
        profileLocal.setBoolObjValue(new Boolean(false));
        profileLocal.setAddress(new Address(AddressPlan.SLEE_PROFILE, "XY/B"));
        Test1110132ProfileLocal result = null;
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("stringValue", "42");
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'stringValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'stringValue=\"42\"' found.");
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("intValue", new Integer(42));
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'intValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'intValue=42' found.");
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("intObjValue", new Integer(42));
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'intObjValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'intObjValue=42' found.");
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("charValue", new Character('X'));
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'charValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'charValue='X'' found.");
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("charObjValue", new Character('X'));
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'charObjValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'charObjValue='X'' found.");
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("boolValue", new Boolean(true));
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'boolValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'boolValue=true' found.");
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("boolObjValue", new Boolean(true));
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'boolObjValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'boolObjValue=true' found.");
        result = (Test1110132ProfileLocal)profileTable.findProfileByAttribute("address", new Address(AddressPlan.SLEE_PROFILE, "XY/A"));
        if (result == null || !result.getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110154, "Wrong profile or null returned by findProfileByAttribute() on attribute 'address'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile with 'address=(AddressPlan.SLEE_PROFILE, \"XY/A\")' found.");
        if (profileTable.findProfileByAttribute("intValue", new Integer(0)) != null || profileTable.findProfileByAttribute("stringValue", "0") != null || profileTable.findProfileByAttribute("address", new Address(AddressPlan.SLEE_PROFILE, "XY/0")) != null) {
            this.sendResult(false, 1110156, "findProfileByAttribute(...) should not consider the default profile when determining matching profiles.", aci);
            return;
        }
        this.sendLogMsgCall("findProfileByAttribute(...) correctly ignored the default profile and returned null for each query.");
        try {
            profileTable.findProfileByAttribute(null, "42");
            this.sendResult(false, 1110160, "findProfileByAttribute(null, \"42\") should have thrown a NullPointerException.", aci);
            return;
        }
        catch (NullPointerException e) {
            this.sendLogMsgCall("findProfileByAttribute(null, \"42\") threw NullPointerException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110160, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: NullPointerException", aci);
            return;
        }
        try {
            profileTable.findProfileByAttribute("stringValue", null);
            this.sendResult(false, 1110160, "findProfileByAttribute(\"stringValue\", null) should have thrown a NullPointerException.", aci);
            return;
        }
        catch (NullPointerException e) {
            this.sendLogMsgCall("findProfileByAttribute(\"stringValue\", null) threw NullPointerException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110160, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: NullPointerException", aci);
            return;
        }
        try {
            profileTable.findProfileByAttribute("xyz", "42");
            this.sendResult(false, 1110678, "findProfileByAttribute(\"xyz\", \"42\") should have thrown a IllegalArgumentException.", aci);
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("findProfileByAttribute(\"xyz\", \"42\") threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110678, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        try {
            profileTable.findProfileByAttribute("intValue", "42");
            this.sendResult(false, 1110678, "findProfileByAttribute(\"intValue\", \"42\") should have thrown a IllegalArgumentException.", aci);
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("findProfileByAttribute(\"intValue\", \"42\") threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110678, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        try {
            profileTable.findProfileByAttribute("myCMPValue", new MyCMPType());
            this.sendResult(false, 1110678, "findProfileByAttribute(\"myCMPValue\",...) should have thrown a IllegalArgumentException.", aci);
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("findProfileByAttribute(\"myCMPValue\", ...) threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110678, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        this.sendResult(true, 1110132, "Testsequence FIND_PROFILE_INDEXED successful.", aci);
    }

    private void do_FIND_PROFILES_INDEXED(Test1110132ProfileTable profileTable, ActivityContextInterface aci) throws Exception {
        Test1110132ProfileLocal pL;
        Test1110132ProfileLocal profileLocal = (Test1110132ProfileLocal)profileTable.find(PROFILE_NAME);
        Test1110132ProfileLocal profileLocal3 = (Test1110132ProfileLocal)profileTable.find(PROFILE_NAME3);
        profileLocal3.setStringValue("42");
        profileLocal3.setIntValue(42);
        profileLocal3.setIntObjValue(new Integer(42));
        profileLocal3.setCharValue('X');
        profileLocal3.setCharObjValue(new Character('X'));
        profileLocal3.setBoolValue(true);
        profileLocal3.setBoolObjValue(new Boolean(true));
        profileLocal3.setAddress(new Address(AddressPlan.SLEE_PROFILE, "XY/A"));
        profileLocal.setStringValue("42");
        profileLocal.setIntValue(41);
        profileLocal.setIntObjValue(new Integer(41));
        profileLocal.setCharValue('Y');
        profileLocal.setCharObjValue(new Character('Y'));
        profileLocal.setBoolValue(false);
        profileLocal.setBoolObjValue(new Boolean(false));
        profileLocal.setAddress(new Address(AddressPlan.SLEE_PROFILE, "XY/A"));
        Collection profiles = null;
        Iterator profileIter = null;
        Hashtable<String, Test1110132ProfileLocal> profileNamesTab = null;
        profileNamesTab = new Hashtable<String, Test1110132ProfileLocal>();
        profiles = profileTable.findProfilesByAttribute("stringValue", "42");
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 2 || !profileNamesTab.containsKey(PROFILE_NAME) || !profileNamesTab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByAttribute() on attribute 'stringValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'stringValue=\"42\"' found.");
        profileNamesTab = new Hashtable();
        profiles = profileTable.findProfilesByAttribute("intValue", new Integer(42));
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 1 || !profileNamesTab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByAttribute() on attribute 'intValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'intValue=42' found.");
        profileNamesTab = new Hashtable();
        profiles = profileTable.findProfilesByAttribute("intObjValue", new Integer(42));
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 1 || !profileNamesTab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByAttribute() on attribute 'intObjValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'intObjValue=Integer(42)' found.");
        profileNamesTab = new Hashtable();
        profiles = profileTable.findProfilesByAttribute("charValue", new Character('X'));
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 1 || !profileNamesTab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByAttribute() on attribute 'charValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'charValue='X'' found.");
        profileNamesTab = new Hashtable();
        profiles = profileTable.findProfilesByAttribute("charObjValue", new Character('X'));
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 1 || !profileNamesTab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByAttribute() on attribute 'charObjValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'charObjValue=Character('X')' found.");
        profileNamesTab = new Hashtable();
        profiles = profileTable.findProfilesByAttribute("boolValue", new Boolean(true));
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 1 || !profileNamesTab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByAttribute() on attribute 'boolValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'boolValue=true' found.");
        profileNamesTab = new Hashtable();
        profiles = profileTable.findProfilesByAttribute("boolObjValue", new Boolean(true));
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 1 || !profileNamesTab.containsKey(PROFILE_NAME3)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByAttribute() on attribute 'boolObjValue'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'boolObjValue=Boolean(true)' found.");
        profileNamesTab = new Hashtable();
        profiles = profileTable.findProfilesByAttribute("address", new Address(AddressPlan.SLEE_PROFILE, "XY/A"));
        profileIter = profiles.iterator();
        while (profileIter.hasNext()) {
            pL = (Test1110132ProfileLocal)profileIter.next();
            profileNamesTab.put(pL.getProfileName(), pL);
        }
        if (profiles.size() != 2 || !profileNamesTab.containsKey(PROFILE_NAME3) || !profileNamesTab.containsKey(PROFILE_NAME)) {
            this.sendResult(false, 1110167, "Wrong profiles returned by findProfilesByIndexedAttribute() on attribute 'address'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profiles with 'address=(AddressPlan.SLEE_PROFILE, \"XY/A\")' found.");
        if (profileTable.findProfilesByAttribute("intValue", new Integer(0)).size() != 0 || profileTable.findProfilesByAttribute("stringValue", "0").size() != 0 || profileTable.findProfilesByAttribute("address", new Address(AddressPlan.SLEE_PROFILE, "XY/0")).size() != 0) {
            this.sendResult(false, 1110166, "findProfilesByAttribute() should not consider the default profile when determining matching profiles.", aci);
            return;
        }
        this.sendLogMsgCall("findProfilesByAttribute() correctly ignored the default profile and returned empty collections for each query.");
        try {
            profiles.add("1");
            this.sendResult(false, 1110169, "Modification attempt on collection object should have caused a UnsupportedOperationException.", aci);
            return;
        }
        catch (UnsupportedOperationException e) {
            this.sendLogMsgCall("Modification attempt on collection object caused UnsupportedOperationException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110169, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: UnsupportedOperationException", aci);
            return;
        }
        try {
            profiles.clear();
            this.sendResult(false, 1110169, "Modification attempt on collection object should have caused a UnsupportedOperationException.", aci);
            return;
        }
        catch (UnsupportedOperationException e) {
            this.sendLogMsgCall("Modification attempt on collection object caused UnsupportedOperationException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110169, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: UnsupportedOperationException", aci);
            return;
        }
        try {
            profiles.remove("1");
            this.sendResult(false, 1110169, "Modification attempt on collection object should have caused a UnsupportedOperationException.", aci);
            return;
        }
        catch (UnsupportedOperationException e) {
            this.sendLogMsgCall("Modification attempt on collection object caused UnsupportedOperationException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110169, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: UnsupportedOperationException", aci);
            return;
        }
        try {
            profileTable.findProfilesByAttribute(null, "42");
            this.sendResult(false, 1110172, "findProfilesByAttribute(null, \"42\") should have thrown a NullPointerException.", aci);
            return;
        }
        catch (NullPointerException e) {
            this.sendLogMsgCall("findProfilesByAttribute(null, \"42\") threw NullPointerException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110172, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: NullPointerException", aci);
            return;
        }
        try {
            profileTable.findProfilesByAttribute("stringValue", null);
            this.sendResult(false, 1110172, "findProfilesByAttribute(\"stringValue\", null) should have thrown a NullPointerException.", aci);
            return;
        }
        catch (NullPointerException e) {
            this.sendLogMsgCall("findProfilesByAttribute(\"stringValue\", null) threw NullPointerException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110172, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: NullPointerException", aci);
            return;
        }
        try {
            profileTable.findProfileByAttribute("xyz", "42");
            this.sendResult(false, 1110683, "findProfilesByAttribute(\"xyz\", \"42\") should have thrown a IllegalArgumentException.", aci);
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("findProfilesByAttribute(\"xyz\", \"42\") threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110683, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        try {
            profileTable.findProfileByAttribute("intValue", "42");
            this.sendResult(false, 1110683, "findProfilesByAttribute(\"intValue\", \"42\") should have thrown a IllegalArgumentException.", aci);
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("findProfilesByAttribute(\"intValue\", \"42\") threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110683, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        try {
            profileTable.findProfileByAttribute("myCMPValue", new MyCMPType());
            this.sendResult(false, 1110683, "findProfilesByAttribute(\"myCMPValue\",...) should have thrown a IllegalArgumentException.", aci);
        }
        catch (IllegalArgumentException e) {
            this.sendLogMsgCall("findProfilesByAttribute(\"myCMPValue\", ...) threw IllegalArgumentException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110683, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: IllegalArgumentException", aci);
            return;
        }
        this.sendResult(true, 1110132, "Testsequence FIND_PROFILES_INDEXED successful.", aci);
    }

    private void do_REMOVE_ROLLBACK_PROFILE(Test1110132ProfileTable profileTable, ActivityContextInterface aci) {
        profileTable.remove(PROFILE_NAME);
        this.getSbbContext().setRollbackOnly();
        this.sendLogMsgCall("Removing profile Test1110132Profile then marking transaction for rollback.");
    }

    private void do_CHECK_REMOVE_ROLLBACK(Test1110132ProfileTable profileTable, ActivityContextInterface aci) {
        if (profileTable.find(PROFILE_NAME) != null) {
            this.sendResult(true, 1110178, "Removing profile Test1110132Profile then rolling back worked fine, profile still exists.", aci);
        } else {
            this.sendResult(false, 1110178, "Profile Test1110132Profile was removed though transaction was rolled back.", aci);
        }
    }

    private void do_REMOVE_COMMIT_PROFILE(Test1110132ProfileTable profileTable, ActivityContextInterface aci) {
        if (profileTable.remove("XYZ")) {
            this.sendResult(false, 1110177, "remove(\"XYZ\") should have returned 'false' as profile  'XYZ' does not exist in the profile table", aci);
            return;
        }
        this.sendLogMsgCall("remove(\"XYZ\") correctly returned false as profile 'XYZ' does not exist.");
        if (!profileTable.remove(PROFILE_NAME)) {
            this.sendResult(false, 1110177, "remove() should have returned 'true' as profile Test1110132Profile exists in the profile table.", aci);
            return;
        }
        this.sendLogMsgCall("remove() correctly returned true and deleted profile Test1110132Profile");
        try {
            profileTable.remove(null);
            this.sendResult(false, 1110180, "remove(null) should have thrown a NullPointerException.", aci);
            return;
        }
        catch (NullPointerException e) {
            this.sendLogMsgCall("remove(null) threw NullPointerException as expected.");
        }
        catch (Exception e) {
            this.sendResult(false, 1110180, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: NullPointerException", aci);
            return;
        }
        this.sendResult(true, 1110132, "Testsequence REMOVE_COMMIT_PROFILE successful.", aci);
    }

    private void do_CHECK_REMOVE_COMMIT(Test1110132ProfileTable profileTable, ActivityContextInterface aci) {
        if (profileTable.find(PROFILE_NAME) == null) {
            this.sendResult(true, 1110178, "Removing and committing profile Test1110132Profile worked fine.", aci);
        } else {
            this.sendResult(false, 1110178, "Removing and committing profile Test1110132Profile failed.", aci);
        }
    }

    private void do_STATIC_QUERY(Test1110132ProfileTable profileTable, ActivityContextInterface aci) {
        Test1110132ProfileLocal profileLocal = (Test1110132ProfileLocal)profileTable.find(PROFILE_NAME);
        Test1110132ProfileLocal profileLocal3 = (Test1110132ProfileLocal)profileTable.find(PROFILE_NAME3);
        profileLocal3.setStringValue("42");
        profileLocal3.setIntValue(42);
        profileLocal3.setAddress(new Address(AddressPlan.SLEE_PROFILE, "XY/A"));
        profileLocal.setStringValue("41");
        profileLocal.setIntValue(42);
        profileLocal.setAddress(new Address(AddressPlan.SLEE_PROFILE, "XY/B"));
        Collection col = null;
        col = profileTable.queryIsAnswerToLife();
        if (col.size() != 1 || !((Test1110132ProfileLocal)col.iterator().next()).getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110188, "Wrong profile found for profile query 'queryIsAnswerToLife'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile was returned for profile query 'queryIsAnswerToLife'");
        col = profileTable.queryEqualsValue("42");
        if (col.size() != 1 || !((Test1110132ProfileLocal)col.iterator().next()).getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110188, "Wrong profile found for profile query 'queryEqualsValue(\"42\")'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile was returned for profile query 'queryEqualsValue(\"42\")'");
        col = profileTable.queryNotEqualsValue("41");
        if (col.size() != 1 || !((Test1110132ProfileLocal)col.iterator().next()).getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110188, "Wrong profile found for profile query 'queryNotEqualsValue(\"41\")'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile was returned for profile query 'queryNotEqualsValue(\"41\")'");
        col = profileTable.queryNotEqualsValues("41", 41);
        if (col.size() != 1 || !((Test1110132ProfileLocal)col.iterator().next()).getProfileName().equals(PROFILE_NAME3)) {
            this.sendResult(false, 1110188, "Wrong profile found for profile query 'queryNotEqualsValues(\"41\", 41)'", aci);
            return;
        }
        this.sendLogMsgCall("Correct profile was returned for profile query 'queryNotEqualsValues(\"41\", 41)'");
        this.sendResult(true, 1110188, "Testsequence STATIC_QUERY successful.", aci);
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            int operationID = (Integer)event.getMessage();
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            Test1110132ProfileTable profileTable = (Test1110132ProfileTable)profileFacility.getProfileTable(PROFILE_TABLE_NAME);
            switch (operationID) {
                case 0: {
                    this.do_CREATE_COMMIT_PROFILE(profileTable, aci);
                    break;
                }
                case 3: {
                    this.do_CHECK_COMMIT_PROFILE(profileTable, aci);
                    break;
                }
                case 1: {
                    this.do_CREATE_ROLLBACK_PROFILE(profileTable, aci);
                    break;
                }
                case 2: {
                    this.do_CHECK_ROLLBACK_PROFILE(profileTable, aci);
                    break;
                }
                case 4: {
                    this.do_FIND_PROFILE(profileTable, aci);
                    break;
                }
                case 5: {
                    this.do_FIND_PROFILE_INDEXED(profileTable, aci);
                    break;
                }
                case 6: {
                    this.do_FIND_PROFILES_INDEXED(profileTable, aci);
                    break;
                }
                case 8: {
                    this.do_REMOVE_ROLLBACK_PROFILE(profileTable, aci);
                    break;
                }
                case 9: {
                    this.do_CHECK_REMOVE_ROLLBACK(profileTable, aci);
                    break;
                }
                case 7: {
                    this.do_REMOVE_COMMIT_PROFILE(profileTable, aci);
                    break;
                }
                case 10: {
                    this.do_CHECK_REMOVE_COMMIT(profileTable, aci);
                    break;
                }
                case 12: {
                    this.do_STATIC_QUERY(profileTable, aci);
                }
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKSbbEvent(TCKSbbEvent event, ActivityContextInterface aci) {
        try {
            HashMap payload = (HashMap)event.getMessage();
            int type = (Integer)payload.get("Type");
            switch (type) {
                case 0: {
                    TCKSbbUtils.getResourceInterface().sendSbbMessage(payload);
                    break;
                }
                case 1: {
                    TCKSbbUtils.getResourceInterface().callTest(payload);
                }
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        this.sendResult(true, 1110132, "Transaction rolled back.", context.getActivityContextInterface());
    }

    public abstract void fireTCKSbbEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);
}

