/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilespec;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbMessageAdapter;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110051Test
extends AbstractSleeTCKTest {
    private static final String NO_PROF_TAB_IMPL_DU_PATH_PARAM = "noProfTabImplDUPath";
    private static final String ALL_OK_DU_PATH_PARAM = "allOKDUPath";
    private static final String DEFAULT_PROF_TABLE = "defaultProfTableDUPath";
    private static final String SPEC_NAME = "Test1110051_3Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final String SEND_RESULT_EVENT_DU_PATH_PARAM = "resultEventDUPath";
    private static final int TEST_ID = 1110051;
    private ProfileUtils profileUtils;
    private FutureResult result;

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils().getLog());
        this.getLog().fine("Deploying profile spec.");
        try {
            this.setupService(NO_PROF_TAB_IMPL_DU_PATH_PARAM);
            throw new TCKTestFailureException(1110051, "Deployment of Profile spec with ProfileTable interface not extending SLEE ProfileTable interface should fail but was successful.");
        }
        catch (TCKTestErrorException e) {
            this.getLog().fine("Caught expected exception when trying to deploy profile spec. Exception: " + e.getMessage());
            this.getLog().fine("Deploying profile spec.");
            try {
                this.setupService(ALL_OK_DU_PATH_PARAM);
                this.getLog().fine("Profile spec with correct ProfileTable interface deploys fine.");
            }
            catch (TCKTestErrorException e2) {
                throw new TCKTestFailureException(1110051, "Deployment of valid profile spec failed.", e2);
            }
            this.utils().uninstallAll();
            this.setupService(SEND_RESULT_EVENT_DU_PATH_PARAM);
            this.getLog().fine("Deploying profile spec.");
            try {
                this.setupService(DEFAULT_PROF_TABLE);
                this.getLog().fine("Profile spec with SLEE's default ProfileTable implementation deploys fine.");
            }
            catch (TCKTestErrorException e3) {
                throw new TCKTestFailureException(1110052, "Deployment of valid profile spec failed.", e3);
            }
            ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
            ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
            profileProvisioning.createProfileTable(specID, "Test1110051ProfileTable");
            this.getLog().fine("Added profile table Test1110051ProfileTable");
            ObjectName profile = profileProvisioning.createProfile("Test1110051ProfileTable", "Test1110051Profile");
            ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            this.getLog().fine("Created profile Test1110051Profile for profile table Test1110051ProfileTable");
            profileProxy.commitProfile();
            profileProxy.closeProfile();
            this.getLog().fine("Commit and close profile Test1110051Profile");
            TCKResourceTestInterface resource = this.utils().getResourceInterface();
            TCKActivityID activityID = resource.createActivity(this.getClass().getName());
            String message = new String("None");
            this.getLog().fine("About to fire TCKResourceEventX.X1 event to the Sbb");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", message, activityID, null);
            return this.result.waitForResultOrFail(this.utils().getTestTimeout(), "Timeout waiting for test result", 1110051);
        }
    }

    public void setPassed() {
        this.result.setPassed();
    }

    public void setFailed(int id, String msg) {
        this.result.setFailed(id, msg);
    }

    public void setError(Exception e) {
        this.result.setError(e);
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.setResourceListener(new SbbMessageAdapter(){

            public Logable getLog() {
                return Test1110051Test.this.utils().getLog();
            }

            public void onSetPassed(int id, String msg) {
                Test1110051Test.this.setPassed();
            }

            public void onSetFailed(int id, String msg) {
                Test1110051Test.this.setFailed(id, msg);
            }

            public void onSetException(Exception e) {
                Test1110051Test.this.setError(e);
            }
        });
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("Test1110051ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

