/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilemanagement;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class Test1110080Test
extends AbstractSleeTCKTest {
    private static final String MNGMT_DEFINED_DU_PATH_PARAM = "MngmtDefinedDUPath";
    private static final String MNGMT_EQUALS_CMP_DU_PATH_PARAM = "MngmtEqualsCMPDUPath";
    private static final String NO_MNGMT_DEFINED_DU_PATH_PARAM = "NoMngmtDefinedDUPath";
    private static final String SPEC_NAME_1 = "Test1110080_1Profile";
    private static final String SPEC_NAME_2 = "Test1110080_2Profile";
    private static final String SPEC_NAME_3 = "Test1110080_3Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final String PROFILE_TABLE_NAME = "Test1110080ProfileTable";
    private static final String PROFILE_NAME = "Test1110080Profile";
    private static final int TEST_ID = 1110080;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private ObjectName profile;
    private ProfileMBeanProxy profileProxy;

    private void setupServiceAndProfile(String specName, String DUPathParam) throws Exception {
        this.setupService(DUPathParam);
        ProfileSpecificationID specID = new ProfileSpecificationID(specName, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, PROFILE_TABLE_NAME);
        this.getLog().fine("Added profile table Test1110080ProfileTable");
        this.profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        this.profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(this.profile);
        this.getLog().fine("Created profile Test1110080Profile for profile table Test1110080ProfileTable");
    }

    private void removeServiceAndProfile() throws TCKTestErrorException, InvalidStateException, ProfileVerificationException, ManagementException, NullPointerException, UnrecognizedProfileTableNameException {
        this.profileProxy.commitProfile();
        this.profileProxy.closeProfile();
        this.getLog().fine("Commit and close profile Test1110080Profile");
        this.profileProvisioning.removeProfileTable(PROFILE_TABLE_NAME);
        this.utils().uninstallAll();
    }

    public TCKTestResult run() throws Exception {
        this.setupServiceAndProfile(SPEC_NAME_1, MNGMT_DEFINED_DU_PATH_PARAM);
        this.getLog().fine("Run tests for profile spec Test1110080_1Profile");
        try {
            this.utils().getMBeanFacade().invoke(this.profile, "setValue", new Object[]{"42"}, new String[]{"java.lang.String"});
            this.utils().getMBeanFacade().invoke(this.profile, "getValue", new Object[0], new String[0]);
            this.getLog().fine("Called get/set accessors on ProfileManagement interface.");
        }
        catch (ReflectionException e) {
            Assert.fail(1110080, "Method not found when invoking accessor method declared in ProfileManagement interface.");
        }
        try {
            this.utils().getMBeanFacade().invoke(this.profile, "manage", new Object[0], new String[0]);
            this.getLog().fine("Called management method on ProfileManagement interface.");
        }
        catch (ReflectionException e) {
            Assert.fail(1110080, "Method not found when invoking management method declared in ProfileManagement interface.");
        }
        try {
            this.utils().getMBeanFacade().invoke(this.profile, "setValue2", new Object[]{"42"}, new String[]{"java.lang.String"});
            Assert.fail(1110080, "Method should NOT have been found when invoking profile accessor method which is NOT declared in ProfileManagement interface but defined in ProfileCMP interface.");
        }
        catch (ReflectionException e) {
            this.getLog().fine("Call to CMP accessor method which is not declared in ProfileManagement interface failed as expected: " + e.getClass().getName());
        }
        this.removeServiceAndProfile();
        this.setupServiceAndProfile(SPEC_NAME_2, MNGMT_EQUALS_CMP_DU_PATH_PARAM);
        this.getLog().fine("Run tests for profile spec Test1110080_2Profile");
        try {
            this.utils().getMBeanFacade().invoke(this.profile, "setValue", new Object[]{"42"}, new String[]{"java.lang.String"});
            this.utils().getMBeanFacade().invoke(this.profile, "getValue", new Object[0], new String[0]);
            this.getLog().fine("Called get/set accessors on ProfileManagement interface that is identical to ProfileCMP interface.");
        }
        catch (ReflectionException e) {
            Assert.fail(1110081, "Method not found when invoking accessor method declared in ProfileManagement interface that is identical to ProfileCMP interface.");
        }
        try {
            this.utils().getMBeanFacade().invoke(this.profile, "setValue2", new Object[]{"42"}, new String[]{"java.lang.String"});
            this.utils().getMBeanFacade().invoke(this.profile, "getValue2", new Object[0], new String[0]);
            this.getLog().fine("Called get/set accessors on ProfileManagement interface that is identical to ProfileCMP interface.");
        }
        catch (ReflectionException e) {
            Assert.fail(1110081, "Method not found when invoking accessor method declared in ProfileManagement interface that is identical to ProfileCMP interface.");
        }
        this.removeServiceAndProfile();
        this.setupServiceAndProfile(SPEC_NAME_3, NO_MNGMT_DEFINED_DU_PATH_PARAM);
        this.getLog().fine("Run tests for profile spec Test1110080_3Profile");
        try {
            this.utils().getMBeanFacade().invoke(this.profile, "setValue", new Object[]{"42"}, new String[]{"java.lang.String"});
            this.utils().getMBeanFacade().invoke(this.profile, "getValue", new Object[0], new String[0]);
            this.getLog().fine("Called get/set accessors for profile spec which does not define a custom ProfileManagement interface.");
        }
        catch (ReflectionException e) {
            Assert.fail(1110081, "Method not found when invoking accessor methods for profile spec which does not define a custom ProfileManagement interface.");
        }
        try {
            this.utils().getMBeanFacade().invoke(this.profile, "setValue2", new Object[]{"42"}, new String[]{"java.lang.String"});
            this.utils().getMBeanFacade().invoke(this.profile, "getValue2", new Object[0], new String[0]);
            this.getLog().fine("Called get/set accessors for profile spec which does not define a custom ProfileManagement interface.");
        }
        catch (ReflectionException e) {
            Assert.fail(1110081, "Method not found when invoking accessor methods for profile spec which does not define a custom ProfileManagement interface.");
        }
        this.removeServiceAndProfile();
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }
}

