/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilemanagement;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.EmptyArrays;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.slee.InvalidStateException;
import javax.slee.profile.ProfileImplementationException;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileMBeanExceptionsTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME = "tck.ProfileMBeanExceptionsTest.table";
    public static final String PROFILE_SPEC_NAME = "PMProfile";
    private ObjectName jmxObjectName;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private ProfileUtils profileUtils;
    private boolean isTableCreated = false;

    public TCKTestResult run() throws Exception {
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.ProfileMBeanExceptionsTest.table");
        this.profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.isTableCreated = true;
        String name = "A";
        this.getLog().info("Creating profile A");
        this.jmxObjectName = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, "A");
        ProfileMBeanProxy proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(this.jmxObjectName);
        proxy.commitProfile();
        try {
            this.utils().getMBeanFacade().invoke(this.jmxObjectName, "testExceptionWrapper", EmptyArrays.EMPTY_OBJECT_ARRAY, EmptyArrays.EMPTY_STRING_ARRAY);
            throw new TCKTestFailureException(1087, "Exception thrown by profile management method was not wrapped in a javax.slee.profileImplementationException and re-thrown.");
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            Assert.assertTrue(1087, "Exception thrown by Profile Management method should have been wrapped and re-thrown as a javax.slee.profile.ProfileImplementationException: " + enclosed, enclosed instanceof ProfileImplementationException);
            try {
                this.utils().getMBeanFacade().invoke(this.jmxObjectName, "setValueIndirectly", new Object[]{"cannot set"}, new String[]{"java.lang.String"});
                Assert.fail(1080, "javax.slee.InvalidStateException should have been thrown by Profile MBean when thrown by a management method");
            }
            catch (MBeanException e2) {
                enclosed = e2.getTargetException();
                Assert.assertTrue(1080, "Expected javax.slee.InvalidStateException thrown by Profile MBean method, got: + " + enclosed, enclosed instanceof InvalidStateException);
            }
            return TCKTestResult.passed();
        }
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileProvisioning != null && this.isTableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileProvisioning.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

