/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileenv;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.profiles.profileenv.ProfileEnvTestsProfileCMP;
import com.opencloud.sleetck.lib.testsuite.profiles.profileenv.Test1110374ProfileManagement;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.CreateException;
import javax.slee.facilities.AlarmFacility;
import javax.slee.profile.Profile;
import javax.slee.profile.ProfileContext;
import javax.slee.profile.ProfileTable;
import javax.slee.profile.ProfileVerificationException;

public abstract class Test1110374Profile
implements ProfileEnvTestsProfileCMP,
Profile,
Test1110374ProfileManagement {
    private ProfileContext context;
    private RMIObjectChannel out;
    private BaseMessageSender msgSender;

    public Test1110374Profile() {
        StdErrLog log = new StdErrLog();
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, log);
        }
        catch (Exception e) {
            log.error("An error occured creating an RMIObjectChannel:");
            log.error(e);
        }
    }

    public void setProfileContext(ProfileContext context) {
        context.getTracer("setProfileContext").info("setProfileContext called");
        this.context = context;
    }

    public void unsetProfileContext() {
        this.context.getTracer("unsetProfileContext").info("unsetProfileContext called");
        this.context = null;
    }

    public void profileInitialize() {
        this.context.getTracer("profileInitialize").info("profileInitialize called");
    }

    public void profilePostCreate() throws CreateException {
        this.context.getTracer("profilePostCreate").info("profilePostCreate called");
    }

    public void profileActivate() {
        this.context.getTracer("profileActivate").info("profileActivate called");
    }

    public void profilePassivate() {
        this.context.getTracer("profilePassivate").info("profilePassivate called");
    }

    public void profileLoad() {
        this.context.getTracer("profileLoad").info("profileLoad called");
    }

    public void profileStore() {
        this.context.getTracer("profileStore").info("profileStore called");
    }

    public void profileRemove() {
        this.context.getTracer("profileRemove").info("profileRemove called");
    }

    public void profileVerify() throws ProfileVerificationException {
        this.context.getTracer("profileVerify").info("profileVerify called");
    }

    public void manage() {
        this.context.getTracer("manage").fine("Management method called.");
        this.doJNDIEnvTest();
    }

    public void doJNDIEnvTest() {
        String profileTableName;
        Context myEnv;
        InitialContext initCtx;
        try {
            initCtx = new InitialContext();
            this.msgSender.sendSuccess(1110384, "Retrieved Naming context.");
        }
        catch (NamingException e) {
            this.msgSender.sendFailure(1110384, "Error when retrieving a new InitialContext via no-args constructor: " + e);
            return;
        }
        try {
            myEnv = (Context)initCtx.lookup("java:comp/env");
            this.msgSender.sendSuccess(1110384, "Retrieved Profile Component environment.");
        }
        catch (NamingException e) {
            this.msgSender.sendFailure(1110384, "Error when trying to retrieve Profile Component environment: " + e);
            return;
        }
        try {
            AlarmFacility alarmFacility = (AlarmFacility)myEnv.lookup("slee/facilities/alarm");
            if (alarmFacility == null) {
                this.msgSender.sendFailure(1110377, "Received null when trying to retrieve AlarmFacility.");
                return;
            }
            this.msgSender.sendSuccess(1110377, "AlarmFacility retrieved as expected.");
        }
        catch (NamingException e) {
            this.msgSender.sendFailure(1110377, "Exception occured when trying to retrieve AlarmFacility: " + e);
            return;
        }
        try {
            profileTableName = (String)myEnv.lookup("tableName");
            ProfileTable profileTable = this.context.getProfileTable(profileTableName);
            this.msgSender.sendSuccess(1110388, "Retrieved ProfileTable interface through environment lookup.");
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1110388, "Exception occurred when trying to retrieve ProfileTable interface: " + e);
            return;
        }
        try {
            Character Ch = (Character)myEnv.lookup("charValue");
            Integer Int = (Integer)myEnv.lookup("intValue");
            Boolean Bool = (Boolean)myEnv.lookup("boolValue");
            Double D = (Double)myEnv.lookup("doubleValue");
            Byte B = (Byte)myEnv.lookup("byteValue");
            Short Sh = (Short)myEnv.lookup("shortValue");
            Long Lo = (Long)myEnv.lookup("longValue");
            Float Fl = (Float)myEnv.lookup("floatValue");
            this.msgSender.sendSuccess(1110393, "Retrieved values for all permissible types.");
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1110393, "Exception occurred when trying to retrieve entry value: " + e);
            return;
        }
        try {
            profileTableName = (String)myEnv.lookup("tableName2");
            this.msgSender.sendFailure(1110395, "Lookup for entry of a different profile spec should have failed but was successful.");
            return;
        }
        catch (Exception e) {
            this.msgSender.sendSuccess(1110395, "Looking up value of entry in a different scope failed as expected: " + e);
            try {
                myEnv.addToEnvironment("XYZ", new Integer(42));
                this.msgSender.sendFailure(1110381, "Adding property to component environment succeeded though modifications a prohibited.");
            }
            catch (NamingException e2) {
                this.msgSender.sendSuccess(1110381, "Adding property to component environment caused exception as expected: " + e2);
            }
            try {
                myEnv.addToEnvironment("tableName", "XYZ");
                this.msgSender.sendFailure(1110381, "Modifying property value succeeded though modifications a prohibited.");
            }
            catch (NamingException e3) {
                this.msgSender.sendSuccess(1110381, "Modifying property value caused exception as expected: " + e3);
            }
            return;
        }
    }
}

