/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileadded;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public class Test2073Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2073;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileProvisioningMBeanProxy profileProxy;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        this.profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            this.profileProxy.createProfileTable((ProfileSpecificationID)components[i], "Test2073ProfileTable");
        }
        ObjectName profile = this.profileProxy.createProfile("Test2073ProfileTable", "Test2073Profile");
        ProfileMBeanProxy proxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.utils.getMBeanFacade().setAttribute(profile, new Attribute("Value", new Integer(42)));
        proxy.commitProfile();
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result", 2073);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        try {
            this.profileProxy.removeProfileTable("Test2073ProfileTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test2073Test.this.utils.getLog().info("Received message from SBB: " + message.getMessage());
            HashMap map = (HashMap)message.getMessage();
            String type = (String)map.get("Type");
            if (type != null) {
                try {
                    Test2073Test.this.profileProxy.removeProfile("Test2073ProfileTable", "Test2073Profile");
                }
                catch (Exception e) {
                    this.onException(e);
                }
            } else {
                Boolean passed = (Boolean)map.get("Result");
                String msgString = (String)map.get("Message");
                Integer id = (Integer)map.get("ID");
                if (passed.booleanValue()) {
                    Test2073Test.this.result.setPassed();
                } else {
                    Test2073Test.this.result.setFailed(id, msgString);
                }
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2073Test.this.utils.getLog().warning("Received exception from SBB.");
            Test2073Test.this.utils.getLog().warning(e);
            Test2073Test.this.result.setError(e);
        }
    }
}

