/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.events;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.profiles.events.ProfileEventsTestEventData;
import com.opencloud.sleetck.lib.testsuite.profiles.simpleprofile.SimpleProfileProxy;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileUpdatedEvent;

public class ProfileEventsTest
extends AbstractSleeTCKTest {
    public static final String TCK_SBB_EVENT_DU_PATH_PARAM = "eventDUPath";
    public static final String PROFILE_TABLE_X_NAME = "tck.ProfileEventsTest.table.X";
    public static final String PROFILE_TABLE_Y_NAME = "tck.ProfileEventsTest.table.Y";
    public static final String PROFILE_A_NAME = "tck.ProfileEventsTest.profile.A";
    public static final String PROFILE_B_NAME = "tck.ProfileEventsTest.profile.B";
    public static final String CHANGED_PROFILE_VALUE = "changedValue";
    private QueuingResourceListener resourceListener;
    private ProfileUtils profileUtils;
    private Vector tablesCreated;
    static /* synthetic */ Class class$javax$slee$profile$ProfileAddedEvent;
    static /* synthetic */ Class class$javax$slee$profile$ProfileRemovedEvent;

    public TCKTestResult run() throws Exception {
        this.getLog().fine("Creating profile tables");
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_X_NAME);
        this.tablesCreated.addElement(PROFILE_TABLE_X_NAME);
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_Y_NAME);
        this.tablesCreated.addElement(PROFILE_TABLE_Y_NAME);
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        Object message = new ProfileEventsTestEventData(PROFILE_TABLE_X_NAME, PROFILE_A_NAME, PROFILE_B_NAME).toExported();
        this.getLog().fine("About to fire TCKResourceEventX.X1 event to the Sbb");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", message, activityID, null);
        TCKSbbMessage reply = this.resourceListener.nextMessage();
        if (!TCKResourceEventX.class.getName().equals(reply.getMessage())) {
            throw new TCKTestErrorException("Received unexpected reply from SBB after sending TCKResourceEventX. Message=" + reply.getMessage());
        }
        String[] profileNames = new String[]{PROFILE_A_NAME, PROFILE_B_NAME};
        for (int i = 0; i < profileNames.length; ++i) {
            this.getLog().fine("Adding profile " + profileNames[i] + " to the profile table");
            ObjectName profile = profileProvisioning.createProfile(PROFILE_TABLE_X_NAME, profileNames[i]);
            ProfileMBeanProxy profProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            try {
                reply = this.resourceListener.nextMessage();
                if ((class$javax$slee$profile$ProfileAddedEvent == null ? ProfileEventsTest.class$("javax.slee.profile.ProfileAddedEvent") : class$javax$slee$profile$ProfileAddedEvent).getName().equals(reply.getMessage())) continue;
                throw new TCKTestErrorException("Received unexpected reply from SBB after adding a profile. Message=" + reply.getMessage());
            }
            catch (OperationTimedOutException ex) {
                throw new TCKTestFailureException(935, "Timed out waiting for acknowledgement of a ProfileAddedEvent following the addition of a profile.", ex);
            }
        }
        ObjectName profileBMBeanName = profileProvisioning.getProfile(PROFILE_TABLE_X_NAME, PROFILE_B_NAME);
        SimpleProfileProxy profileProxy = new SimpleProfileProxy(profileBMBeanName, this.utils().getMBeanFacade());
        profileProxy.editProfile();
        profileProxy.setValue(CHANGED_PROFILE_VALUE);
        profileProxy.commitProfile();
        try {
            reply = this.resourceListener.nextMessage();
            if (!ProfileUpdatedEvent.class.getName().equals(reply.getMessage())) {
                throw new TCKTestErrorException("Received unexpected reply from SBB after updating a profile. Message=" + reply.getMessage());
            }
        }
        catch (OperationTimedOutException ex) {
            throw new TCKTestFailureException(2409, "Timed out waiting for acknowledgement of a ProfileUpdatedEvent following the commit of changes to a profile.", ex);
        }
        for (int i = 0; i < profileNames.length; ++i) {
            this.getLog().fine("Removing profile " + profileNames[i] + " from the profile table");
            profileProvisioning.removeProfile(PROFILE_TABLE_X_NAME, profileNames[i]);
            try {
                reply = this.resourceListener.nextMessage();
                if ((class$javax$slee$profile$ProfileRemovedEvent == null ? ProfileEventsTest.class$("javax.slee.profile.ProfileRemovedEvent") : class$javax$slee$profile$ProfileRemovedEvent).getName().equals(reply.getMessage())) continue;
                throw new TCKTestErrorException("Received unexpected reply from SBB after removing a profile. Message=" + reply.getMessage());
            }
            catch (OperationTimedOutException ex) {
                throw new TCKTestFailureException(936, "Timed out waiting for acknowledgement of a ProfileRemovedEvent following the removal of a profile.", ex);
            }
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.getLog().fine("Installing profile specification");
        String profDUPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.utils().install(profDUPath);
        this.getLog().fine("Installing TCKSbbEvent deployable unit");
        String eventDUPath = this.utils().getTestParams().getProperty(TCK_SBB_EVENT_DU_PATH_PARAM);
        this.utils().install(eventDUPath);
        this.setupService("serviceDUPath");
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.profileUtils = new ProfileUtils(this.utils());
        this.tablesCreated = new Vector();
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileUtils != null && !this.tablesCreated.isEmpty()) {
                this.getLog().fine("Removing profile tables");
                Iterator tablesCreatedIter = this.tablesCreated.iterator();
                while (tablesCreatedIter.hasNext()) {
                    this.profileUtils.removeProfileTable((String)tablesCreatedIter.next());
                }
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile tables:");
            this.getLog().warning(e);
        }
        if (this.tablesCreated != null) {
            this.tablesCreated.clear();
        }
        super.tearDown();
    }
}

