/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.defaultprofile;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class DefaultProfileDeletionTest
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_NAME = "tck.DefaultProfileDeletionTest.table";
    private ProfileUtils profileUtils;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.DefaultProfileDeletionTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.getLog().info("Removing profile table: tck.DefaultProfileDeletionTest.table");
        profileProvisioning.removeProfileTable(PROFILE_TABLE_NAME);
        try {
            profileProvisioning.getDefaultProfile(PROFILE_TABLE_NAME);
            Assert.fail(1979, "getDefaultProfile for a profile table should throw an exception after the profile has been deleted");
        }
        catch (UnrecognizedProfileTableNameException e) {
            this.getLog().info("Got expected UnrecognizedProfileTableNameException");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        this.profileUtils = null;
        super.tearDown();
    }
}

