/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.defaultprofile;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.simpleprofile.SimpleProfileProxy;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class DefaultIsTableSpecificTest
extends AbstractSleeTCKTest {
    private static final String PROFILE_TABLE_A_NAME = "tck.DefaultIsTableSpecificTest.tableA";
    private static final String PROFILE_TABLE_B_NAME = "tck.DefaultIsTableSpecificTest.tableB";
    private static final String CHANGED_PROFILE_VALUE = "Changed";
    private Vector createdTables;
    private Vector activeProxies;
    private ProfileUtils profileUtils;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID("SimpleProfile", "jain.slee.tck", "1.0");
        String[] TABLE_NAMES = new String[]{PROFILE_TABLE_A_NAME, PROFILE_TABLE_B_NAME};
        for (int i = 0; i < TABLE_NAMES.length; ++i) {
            this.getLog().info("Creating profile table: " + TABLE_NAMES[i]);
            profileProvisioning.createProfileTable(profileSpecID, TABLE_NAMES[i]);
            this.createdTables.addElement(TABLE_NAMES[i]);
        }
        ObjectName defaultAName = profileProvisioning.getDefaultProfile(PROFILE_TABLE_A_NAME);
        SimpleProfileProxy defaultAProxy = new SimpleProfileProxy(defaultAName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(defaultAProxy);
        String initialAValue = defaultAProxy.getValue();
        if (initialAValue != null) {
            throw new TCKTestErrorException("Expected simple profile value to be null, but found: " + initialAValue);
        }
        this.getLog().info("Editing default profile for table tck.DefaultIsTableSpecificTest.tableA");
        defaultAProxy.editProfile();
        defaultAProxy.setValue(CHANGED_PROFILE_VALUE);
        defaultAProxy.commitProfile();
        ObjectName defaultBName = profileProvisioning.getDefaultProfile(PROFILE_TABLE_B_NAME);
        SimpleProfileProxy defaultBProxy = new SimpleProfileProxy(defaultBName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(defaultBProxy);
        this.getLog().info("Querying default profile for table tck.DefaultIsTableSpecificTest.tableB");
        String initialBValue = defaultBProxy.getValue();
        if (initialBValue != null) {
            if (initialBValue.equals(CHANGED_PROFILE_VALUE)) {
                throw new TCKTestFailureException(923, "Changes to the default profile of one table affected the default profile of another table");
            }
            throw new TCKTestErrorException("Expected simple profile value to be null, but found: " + initialBValue);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.createdTables = new Vector();
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                SimpleProfileProxy aProxy = (SimpleProfileProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profile:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && !this.createdTables.isEmpty()) {
                this.getLog().fine("Removing profile tables");
                Iterator createdTablesIter = this.createdTables.iterator();
                while (createdTablesIter.hasNext()) {
                    this.profileUtils.removeProfileTable((String)createdTablesIter.next());
                }
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile tables:");
            this.getLog().warning(e);
        }
        this.profileUtils = null;
        this.createdTables = null;
        this.activeProxies = null;
        super.tearDown();
    }
}

