/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.checkprofilestore;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.checkprofilestore.CheckStoreProfileProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class CheckProfileStoreTest
extends AbstractSleeTCKTest {
    private static final String TABLE_NAME = "tck.CheckStoreProfileTest.table";
    private static final String PROFILE_SPEC_NAME = "CheckStoreProfile";
    private ProfileUtils profileUtils;
    private Vector activeProxies;
    private boolean isTableCreated;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.CheckStoreProfileTest.table");
        profileProvisioning.createProfileTable(profileSpecID, TABLE_NAME);
        this.isTableCreated = true;
        ObjectName defaultProfileName = profileProvisioning.getDefaultProfile(TABLE_NAME);
        CheckStoreProfileProxy defaultProfileProxy = this.getProfileProxy(defaultProfileName);
        this.getLog().info("Checking default profile");
        String initialValue = defaultProfileProxy.getValue();
        if (initialValue == null) {
            Assert.fail(1018, "The default profile CMP fields were not initialized by profileStore()");
        }
        Assert.assertEquals(1018, "The default profile was initialized to an unexpected value (" + initialValue + ") it should have been set to " + "INITIALIZED" + " profileStore()", "INITIALIZED", initialValue);
        defaultProfileProxy.editProfile();
        defaultProfileProxy.setTransientValue("VALUE1");
        defaultProfileProxy.commitProfile();
        Assert.assertEquals(1024, "Transient values were not saved to CMP fields by profileStore()", "VALUE1", defaultProfileProxy.getValue());
        defaultProfileProxy.editProfile();
        defaultProfileProxy.setValue("INVALID");
        defaultProfileProxy.setTransientValue("VALUE2");
        try {
            defaultProfileProxy.commitProfile();
        }
        catch (ProfileVerificationException e) {
            Assert.fail(1029, "profileStore() was not called before profileVerify()");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                CheckStoreProfileProxy aProxy = (CheckStoreProfileProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.isTableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        this.profileUtils = null;
        this.isTableCreated = false;
        this.activeProxies = null;
        super.tearDown();
    }

    private CheckStoreProfileProxy getProfileProxy(ObjectName mbeanName) throws TCKTestErrorException, UnrecognizedProfileNameException, UnrecognizedProfileTableNameException, ManagementException {
        CheckStoreProfileProxy rProxy = new CheckStoreProfileProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

