/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.preparatory.sleestate;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ExceptionsUtil;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.statetracking.StateMachineTrackerUtil;
import com.opencloud.sleetck.lib.testutils.statetracking.TrackingStateNotificationsListener;
import java.util.Iterator;
import javax.management.MBeanException;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.management.SleeState;

public class SleeStateTest
implements SleeTCKTest {
    private StateMachineTrackerUtil stateTracker;
    private TrackingStateNotificationsListener stateListener;
    private SleeManagementMBeanProxy managementMBean;
    private Logable log;
    private SleeTCKTestUtils utils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public void setUp() throws Exception {
        this.log = this.utils.getLog();
        int[] allStates = new int[]{0, 1, 2, 3};
        this.stateTracker = new StateMachineTrackerUtil(allStates, this.log);
        this.buildStateMachineModel();
        this.stateListener = new TrackingStateNotificationsListener(this.stateTracker, this.log);
        this.managementMBean = this.utils.getMBeanProxyFactory().createSleeManagementMBeanProxy(this.utils.getSleeManagementMBeanName());
        this.managementMBean.addNotificationListener(this.stateListener, null, null);
        this.stateTracker.shiftState(this.managementMBean.getState().toInt());
    }

    public void tearDown() throws Exception {
        if (this.managementMBean != null) {
            this.managementMBean.removeNotificationListener(this.stateListener);
        }
    }

    public TCKTestResult run() {
        try {
            this.testStopFromRunning();
            this.testStopFromStopped();
            this.testStartFromStopped();
            this.testStartFromRunning();
            return TCKTestResult.passed();
        }
        catch (TCKTestErrorException te) {
            return TCKTestResult.error(te);
        }
        catch (TCKTestFailureException tf) {
            return TCKTestResult.failed(tf);
        }
    }

    private void testStopFromRunning() throws TCKTestFailureException, TCKTestErrorException {
        this.log.finer("testing stop() from RUNNING state");
        try {
            this.assertInitialState(SleeState.RUNNING);
            this.stateTracker.setDestination(0);
            this.preTransition();
            this.managementMBean.stop();
            this.postTransition();
            this.assertFinalState(SleeState.STOPPED);
        }
        catch (Exception e) {
            this.handleException(e, "stop() from RUNNING state");
        }
    }

    private void testStopFromStopped() throws TCKTestFailureException, TCKTestErrorException {
        this.log.finer("testing stop() from STOPPED state");
        try {
            this.assertInitialState(SleeState.STOPPED);
            this.preTransition();
            InvalidStateException caught = null;
            try {
                this.managementMBean.stop();
            }
            catch (InvalidStateException ise) {
                caught = ise;
            }
            if (caught == null) {
                throw new TCKTestFailureException(-1, "Expected InvalidStateException while testing stop() from STOPPED state, but none thrown");
            }
            this.postTransition();
            this.assertFinalState(SleeState.STOPPED);
        }
        catch (Exception e) {
            this.handleException(e, "stop() from STOPPED state");
        }
    }

    private void testStartFromStopped() throws TCKTestFailureException, TCKTestErrorException {
        this.log.finer("testing start() from STOPPED state");
        try {
            this.assertInitialState(SleeState.STOPPED);
            this.stateTracker.setDestination(2);
            this.preTransition();
            this.managementMBean.start();
            this.postTransition();
            this.assertFinalState(SleeState.RUNNING);
        }
        catch (Exception e) {
            this.handleException(e, "start() from STOPPED state");
        }
    }

    protected void testStartFromRunning() throws TCKTestFailureException, TCKTestErrorException {
        this.log.finer("testing start() from RUNNING state");
        try {
            this.assertInitialState(SleeState.RUNNING);
            this.preTransition();
            InvalidStateException caught = null;
            try {
                this.managementMBean.start();
            }
            catch (InvalidStateException ise) {
                caught = ise;
            }
            if (caught == null) {
                throw new TCKTestFailureException(-1, "Expected InvalidStateException while testing start() from RUNNING state, but none thrown");
            }
            this.postTransition();
            this.assertFinalState(SleeState.RUNNING);
        }
        catch (Exception e) {
            this.handleException(e, "start() from RUNNING state");
        }
    }

    private void assertInitialState(SleeState expected) throws ManagementException, TCKTestErrorException {
        SleeState currentState = this.managementMBean.getState();
        if (!currentState.equals((Object)expected)) {
            throw new TCKTestErrorException("Pre-condition not met: expected state was " + expected + ", found state was " + currentState);
        }
    }

    private void assertFinalState(SleeState expected) throws ManagementException, TCKTestFailureException, TCKTestErrorException {
        SleeState currentState = this.managementMBean.getState();
        if (!currentState.equals((Object)expected)) {
            throw new TCKTestFailureException(-1, "Post-condition not met: expected state was " + expected + ", found state was " + currentState);
        }
    }

    private void preTransition() {
        this.stateTracker.clearTransitions();
        this.stateTracker.startRecording();
        this.stateTracker.stateUnknown();
    }

    private void postTransition() throws TCKTestErrorException, TCKTestFailureException {
        this.stateTracker.waitForDestination(this.utils.getTestTimeout());
        this.stateTracker.stopRecording();
        Iterator badMoves = this.stateTracker.getIllegalTransitions();
        if (badMoves.hasNext()) {
            StateMachineTrackerUtil.Transition transition = (StateMachineTrackerUtil.Transition)badMoves.next();
            String fromFormatted = SleeState.fromInt((int)transition.getFromState()).toString();
            String toFormatted = SleeState.fromInt((int)transition.getToState()).toString();
            throw new TCKTestFailureException(-1, "Illegal state transition detected in SleeProvider, from " + fromFormatted + " to " + toFormatted);
        }
    }

    private void handleException(Exception e, String currentTest) throws TCKTestErrorException, TCKTestFailureException {
        if (e instanceof TCKTestErrorException) {
            throw (TCKTestErrorException)e;
        }
        if (e instanceof TCKTestFailureException) {
            throw (TCKTestFailureException)e;
        }
        if (e instanceof InvalidStateException) {
            throw new TCKTestFailureException(-1, "Caught InvalidStateException while testing " + currentTest + ":" + ExceptionsUtil.formatThrowable(e));
        }
        if (e instanceof MBeanException) {
            MBeanException mbe = (MBeanException)e;
            throw new TCKTestErrorException("Caught MBeanException while testing " + currentTest + ". Nested exception:" + ExceptionsUtil.formatThrowable(mbe.getTargetException()));
        }
        throw new TCKTestErrorException("Caught exception while testing " + currentTest + ":" + ExceptionsUtil.formatThrowable(e));
    }

    private void buildStateMachineModel() {
        this.stateTracker.addTransition(0, 1);
        this.stateTracker.addTransition(1, 2);
        this.stateTracker.addTransition(1, 3);
        this.stateTracker.addTransition(2, 3);
        this.stateTracker.addTransition(3, 0);
    }
}

