/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.sleestate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.management.sleestate.QueuingSleeStateListener;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.rmi.RemoteException;
import javax.management.ObjectName;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;

public class Test1479Test
extends AbstractSleeTCKTest {
    private QueuingSleeStateListener stateListener;
    private SleeManagementMBeanProxy management;

    public TCKTestResult run() throws Exception {
        ObjectName[] mbeanNames = new ObjectName[]{this.management.getAlarmMBean(), this.management.getDeploymentMBean(), this.management.getProfileProvisioningMBean(), this.management.getServiceManagementMBean(), this.management.getTraceMBean()};
        MBeanFacade facade = this.utils().getMBeanFacade();
        TCKActivityID activity = this.utils().getResourceInterface().createActivity("Test1479Activity");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activity, null);
        this.management.stop();
        this.waitForStateChange(SleeState.STOPPING);
        this.checkMBeansAvailable(facade, mbeanNames);
        this.utils().getResourceInterface().endActivity(activity);
        this.waitForStateChange(SleeState.STOPPED);
        this.checkMBeansAvailable(facade, mbeanNames);
        this.management.start();
        this.waitForStateChange(SleeState.STARTING);
        this.checkMBeansAvailable(facade, mbeanNames);
        this.waitForStateChange(SleeState.RUNNING);
        this.checkMBeansAvailable(facade, mbeanNames);
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.management = this.utils().getSleeManagementMBeanProxy();
        this.stateListener = new QueuingSleeStateListener(this.utils());
        this.management.addNotificationListener(this.stateListener, null, null);
        this.setResourceListener(new ResourceListenerImpl());
    }

    public void tearDown() throws Exception {
        if (null != this.management) {
            this.management.removeNotificationListener(this.stateListener);
        }
        super.tearDown();
    }

    private void checkMBeansAvailable(MBeanFacade facade, ObjectName[] jmxNames) throws Exception {
        for (int i = 0; i < jmxNames.length; ++i) {
            ObjectName jmxName = jmxNames[i];
            if (facade.isRegistered(jmxName)) continue;
            Assert.fail(1479, "MBean " + jmxName + " is not registered in the " + this.management.getState() + " state");
        }
    }

    private void waitForStateChange(SleeState expectedState) throws Exception {
        this.getLog().info("state: " + this.management.getState());
        SleeStateChangeNotification stateChange = null;
        try {
            this.getLog().info("Waiting to move to the " + expectedState + " state");
            stateChange = this.stateListener.nextNotification();
            this.getLog().info("Found state change: " + stateChange);
        }
        catch (OperationTimedOutException toe) {
            throw new TCKTestErrorException("Timed out waiting for SLEE to change to the " + expectedState + " state");
        }
    }

    public class ResourceListenerImpl
    extends BaseTCKResourceListener {
        public void onException(Exception exception) throws RemoteException {
            Test1479Test.this.utils().getLog().warning("An Exception was received from the SBB or the TCK resource:");
            Test1479Test.this.utils().getLog().warning(exception);
        }
    }
}

