/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.sleestate;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import java.util.LinkedList;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;

public class QueuingSleeStateListener
implements NotificationListener {
    private final SleeTCKTestUtils utils;
    private final LinkedList queue;

    public QueuingSleeStateListener(SleeTCKTestUtils utils) {
        this.utils = utils;
        this.queue = new LinkedList();
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        if (notification instanceof SleeStateChangeNotification) {
            SleeStateChangeNotification stateChange = (SleeStateChangeNotification)notification;
            SleeState newState = stateChange.getNewState();
            SleeState previousState = stateChange.getOldState();
            this.utils.getLog().fine("StateNotificationsListener:received state change to " + newState + " from " + previousState);
            this.queue.addLast(notification);
            this.notify();
        }
    }

    public synchronized SleeStateChangeNotification nextNotification() throws OperationTimedOutException {
        long now = System.currentTimeMillis();
        long timeoutAt = now + (long)this.utils.getTestTimeout();
        while (now < timeoutAt) {
            while (this.queue.isEmpty() && now < timeoutAt) {
                try {
                    this.wait(timeoutAt - now);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            if (this.queue.isEmpty()) continue;
            return (SleeStateChangeNotification)this.queue.removeFirst();
        }
        throw new OperationTimedOutException("Timed out waiting for a Notification");
    }

    public synchronized boolean hasNotifications() {
        return !this.queue.isEmpty();
    }
}

