/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import java.rmi.RemoteException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.management.ManagementException;
import javax.slee.management.SleeState;

public class Test2096Test
implements SleeTCKTest {
    private static final int TEST_ID = 2096;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ObjectName sleeManagementMBeanName = this.utils.getSleeManagementMBeanName();
        SleeState sleeState = (SleeState)this.getViaGetAttribute(sleeManagementMBeanName, "State");
        if (sleeState == null) {
            return TCKTestResult.failed(2096, "The SleeState object returned from the SleeManagementMBean via getAttribute(\"State\") was null");
        }
        this.utils.getLog().info("SleeManagementMBean returned a non-null SleeState object via getAttribute(\"State\"):" + sleeState);
        try {
            sleeState = (SleeState)this.getViaGetAttribute(sleeManagementMBeanName, "state");
            return TCKTestResult.failed(2096, "get/set accessor methods are case-sensitive.  This SLEE allowed a call to getAttribute(\"state\"), when only the 'State' attribute should have been available. The returned object: " + sleeState);
        }
        catch (TCKTestFailureException e) {
            if (e.getEnclosedException().getClass().equals(AttributeNotFoundException.class)) {
                return TCKTestResult.passed();
            }
            throw e;
        }
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
    }

    private Object getViaGetAttribute(ObjectName objName, String attribute) throws ManagementException, TCKTestErrorException, TCKTestFailureException {
        try {
            return this.utils.getMBeanFacade().getAttribute(objName, attribute);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.getAttribute()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(2096, "Caught ReflectionException while calling MBeanServer.getAttribute(\"AttributeA\")", re);
        }
        catch (AttributeNotFoundException e) {
            throw new TCKTestFailureException(2096, "Caught AttributeNotFoundException while calling MBeanServer.getAttribute(\"AttributeA\")", e);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public void onException(Exception e) throws RemoteException {
            Test2096Test.this.utils.getLog().warning("Received exception from the TCK resource");
            Test2096Test.this.utils.getLog().warning(e);
        }
    }
}

