/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.SleeManagementMBean;

import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ManagementException;
import javax.slee.management.UnrecognizedSubsystemException;

public class Test1114391Test
extends GenericUsageTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final int TEST_ID = 0x110117;
    private DeployableUnitID duID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        SleeManagementMBeanProxy sleeProxy;
        boolean subsystemWithUsageExists = false;
        boolean subsystemWithoutUsageExists = false;
        String usageSubsystem = null;
        String noUsageSubsystem = null;
        TCKTestResult testResult = null;
        try {
            sleeProxy = this.utils().getSleeManagementMBeanProxy();
            String strObjectName = this.utils().getSleeManagementMBeanName().toString();
            this.getLog().fine("1114301: SleeManagementMBean = " + strObjectName);
            if (!strObjectName.equals("javax.slee.management:name=SleeManagement")) {
                this.getLog().warning("1114301, SleeManagementMBean returned: " + strObjectName);
                return TCKTestResult.failed(1114301, "Failed to create SleeManagementMBean");
            }
            this.logSuccessfulCheck(1114301);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.error("Failed to create SleeManagementMBean");
        }
        try {
            String[] installedSubsystems = sleeProxy.getSubsystems();
            this.logSuccessfulCheck(0x110117);
            for (int i = 0; i < installedSubsystems.length; ++i) {
                this.utils().getLog().fine("Installed Subsystem is: " + installedSubsystems[i]);
                try {
                    boolean usage = sleeProxy.hasUsage(installedSubsystems[i]);
                    this.utils().getLog().fine("Installed Subsystem hasUsage = " + usage);
                    if (usage) {
                        usageSubsystem = installedSubsystems[i];
                        subsystemWithUsageExists = true;
                    } else {
                        noUsageSubsystem = installedSubsystems[i];
                        subsystemWithoutUsageExists = true;
                    }
                }
                catch (Exception e) {
                    TCKTestResult tCKTestResult = TCKTestResult.failed(0x110118, "SleeManagementMBeanProxy.hasUsage() has thrown Exception: " + e.getClass().toString());
                    this.utils().getLog().fine("Test Complete");
                    return tCKTestResult;
                }
                try {
                    continue;
                }
                catch (ManagementException e) {
                    TCKTestResult tCKTestResult = TCKTestResult.failed(0x110117, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
                    return tCKTestResult;
                }
                catch (Exception e) {
                    TCKTestResult tCKTestResult = TCKTestResult.failed(0x110117, "SleeManagementMBeanProxy.getSubsystems() has thrown Exception: " + e.getClass().toString());
                    return tCKTestResult;
                }
            }
            if (subsystemWithoutUsageExists) {
                this.utils().getLog().fine("Checking SleeManagementMBean for subsystem without Usage...");
                testResult = this.checkSleeSubsystems(sleeProxy, noUsageSubsystem, false);
            }
            if (subsystemWithUsageExists && (testResult == null || testResult == TCKTestResult.passed())) {
                this.utils().getLog().fine("Now checking SleeManagementMBean for subsystem with Usage...");
                testResult = this.checkSleeSubsystems(sleeProxy, usageSubsystem, true);
            }
        }
        finally {
            this.utils().getLog().fine("Test Complete");
        }
        return testResult;
    }

    public TCKTestResult checkSleeSubsystems(SleeManagementMBeanProxy sleeProxy, String installedSubsystem, boolean hasUsage) throws Exception {
        ObjectName objectName;
        String usageParam = "NoUsageParams";
        Object noUsageSubsystem = null;
        Object notrecognizedusageParams = null;
        String notrecognizedSubsystem = "Test1114391Test";
        Object nullSubsystem = null;
        try {
            boolean usage = sleeProxy.hasUsage(installedSubsystem);
            this.utils().getLog().fine("1114392 - hasUsage = " + usage);
            this.logSuccessfulCheck(0x110118);
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(0x110118, "The Installed Subsystems name(s) was not recognised");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(0x110118, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(0x110118, "SleeManagementMBeanProxy.hasUsage() has thrown Exception: " + e.getClass().toString());
        }
        try {
            String[] usageParams = sleeProxy.getUsageParameterSets(installedSubsystem);
            this.logSuccessfulCheck(0x110119);
            usageParam = usageParams[0];
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(0x110119, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(0x110119, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!hasUsage) {
                this.logSuccessfulCheck(0x110119);
            }
            return TCKTestResult.failed(0x110119, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(0x110119, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(0x110119, "SleeManagementMBeanProxy.getUsageParameterSets() has thrown Exception: " + e.getClass().toString());
        }
        try {
            objectName = sleeProxy.getUsageMBean(installedSubsystem);
            this.logSuccessfulCheck(0x11011A);
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(0x11011A, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(0x11011A, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!hasUsage) {
                this.logSuccessfulCheck(0x11011A);
            }
            return TCKTestResult.failed(0x11011A, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(0x11011A, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(0x11011A, "SleeManagementMBeanProxy.getSubsystems() has thrown Exception: " + e.getClass().toString());
        }
        try {
            objectName = sleeProxy.getUsageMBean(installedSubsystem, usageParam);
            this.logSuccessfulCheck(0x11011B);
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(0x11011B, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(0x11011B, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!hasUsage) {
                this.logSuccessfulCheck(0x11011B);
            }
            return TCKTestResult.failed(0x11011B, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(0x11011B, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(0x11011B, "SleeManagementMBeanProxy.getSubsystems() has thrown Exception: " + e.getClass().toString());
        }
        try {
            objectName = sleeProxy.getUsageNotificationManagerMBean(installedSubsystem);
            this.logSuccessfulCheck(0x11011C);
        }
        catch (NullPointerException e) {
            return TCKTestResult.failed(0x11011C, "The Installed Subsystems name(s) was null");
        }
        catch (UnrecognizedSubsystemException e) {
            return TCKTestResult.failed(0x11011C, "The Installed Subsystems name(s) was not recognised");
        }
        catch (InvalidArgumentException e) {
            if (!hasUsage) {
                this.logSuccessfulCheck(0x11011C);
            }
            return TCKTestResult.failed(0x11011C, "The Installed Subsystems name(s) was not valid");
        }
        catch (ManagementException e) {
            return TCKTestResult.failed(0x11011C, "The Installed Subsystems name(s) could not obtained due to a system-level failure");
        }
        catch (Exception e) {
            return TCKTestResult.failed(0x11011C, "SleeManagementMBeanProxy.getUsageNotificationManagerMBean() has thrown Exception: " + e.getClass().toString());
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        try {
            String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
            this.utils().getLog().fine("Installing " + duPath);
            this.duID = this.utils().install(duPath);
            this.utils().activateServices(this.duID, true);
            this.getLog().fine("1114391: Deployed Service: " + duPath);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.getLog().warning("Failed to install deployable unit.");
        }
    }

    public void tearDown() throws Exception {
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getLog().fine("Deactivating and uninstalling service");
        this.utils().deactivateAllServices();
        this.utils().uninstallAll();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }
}

