/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ServiceManagementMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import javax.management.ObjectName;
import javax.slee.ServiceID;
import javax.slee.management.ServiceUsageMBean;

public class Test3971Test
extends AbstractSleeTCKTest {
    public static final String SERVICE_NAME = "GenericUsageService";
    public static final int TEST_ID = 3971;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        ObjectName serviceUsageMBeanName = null;
        ServiceUsageMBeanProxy serviceUsageMBeanProxy = null;
        try {
            ComponentIDLookup idLookup = new ComponentIDLookup(this.utils());
            ServiceID serviceID = idLookup.lookupServiceID(SERVICE_NAME, "jain.slee.tck", null);
            if (serviceID == null) {
                throw new TCKTestErrorException("ServiceID not found for GenericUsageService");
            }
            serviceUsageMBeanName = this.utils().getServiceManagementMBeanProxy().getServiceUsageMBean(serviceID);
            serviceUsageMBeanProxy = this.utils().getMBeanProxyFactory().createServiceUsageMBeanProxy(serviceUsageMBeanName);
            String expectedMBeanClassName = ServiceUsageMBean.class.getName();
            this.utils().getLog().info("Checking that MBean " + serviceUsageMBeanName + " returned by getServiceUsageMBean() is a " + expectedMBeanClassName);
            if (!this.utils().getMBeanFacade().isInstanceOf(serviceUsageMBeanName, expectedMBeanClassName)) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(3971, "MBean " + serviceUsageMBeanName + " returned by getServiceUsageMBean() is not an instance of " + expectedMBeanClassName);
                return tCKTestResult;
            }
            if (!serviceUsageMBeanProxy.getService().equals((Object)serviceID)) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(3971, "MBean " + serviceUsageMBeanName + " returned by getServiceUsageMBean() does not represent the service passed to getServiceUsageMBean()");
                return tCKTestResult;
            }
        }
        finally {
            if (serviceUsageMBeanProxy != null) {
                serviceUsageMBeanProxy.close();
            }
        }
        return TCKTestResult.passed();
    }
}

