/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ServiceManagementMBean;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;

public class Test2471Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2471;
    private ServiceManagementMBeanProxy serviceProxy;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        int i;
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        this.serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ServiceID[] services = new ServiceID[2];
        int index = 0;
        for (i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            services[index++] = (ServiceID)components[i];
        }
        for (i = 0; i < services.length; ++i) {
            if (this.serviceProxy.getState(services[i]).isInactive()) continue;
            return TCKTestResult.failed(2471, "Services are not in the inactive state; cannot continue with test.");
        }
        this.serviceProxy.activate(services);
        this.waitForStateChange(services[0], ServiceState.ACTIVE);
        this.waitForStateChange(services[1], ServiceState.ACTIVE);
        try {
            this.serviceProxy.deactivate(services);
        }
        catch (InvalidStateException e) {
            return TCKTestResult.failed(1620, "Failed to deactivate active services.");
        }
        catch (Exception e) {
            this.utils.getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        for (i = 0; i < services.length; ++i) {
            if (!this.serviceProxy.getState(services[i]).isActive()) continue;
            return TCKTestResult.failed(1621, "Deactivated service is in the Active state.");
        }
        boolean passed = false;
        try {
            this.serviceProxy.deactivate(services);
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        if (!passed) {
            return TCKTestResult.failed(1622, "InvalidStateException should have been thrown when deactivating an already inactive service.");
        }
        this.waitForStateChange(services[0], ServiceState.INACTIVE);
        this.waitForStateChange(services[1], ServiceState.INACTIVE);
        this.serviceProxy.activate(services);
        this.waitForStateChange(services[0], ServiceState.ACTIVE);
        this.waitForStateChange(services[1], ServiceState.ACTIVE);
        passed = false;
        try {
            this.serviceProxy.deactivate(new ServiceID[0]);
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils.getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2471, "InvalidArgumentException should have been thrown when calling deactivate with an empty ServiceID array.");
        }
        passed = false;
        try {
            this.serviceProxy.deactivate(new ServiceID[]{services[0], null});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        if (!passed) {
            return TCKTestResult.failed(2471, "InvalidArgumentException should have been thrown when calling deactivate with a ServiceID array containing a null element.");
        }
        passed = false;
        try {
            this.serviceProxy.deactivate(new ServiceID[]{services[0], services[1], services[1]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        if (!passed) {
            return TCKTestResult.failed(2471, "InvalidArgumentException should have been thrown when calling deactivate with a ServiceID array containing duplicate items.");
        }
        return TCKTestResult.passed();
    }

    private void waitForStateChange(ServiceID serviceID, ServiceState expectedState) throws Exception {
        int count = 0;
        while (!this.serviceProxy.getState(serviceID).equals((Object)expectedState)) {
            if (count > 10) {
                throw new OperationTimedOutException("Timeout waiting for service " + serviceID + " to enter state " + expectedState);
            }
            Thread.sleep(500L);
            ++count;
        }
        return;
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test2471Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test2471Test.this.result.setPassed();
            } else {
                Test2471Test.this.result.setFailed(2471, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2471Test.this.utils.getLog().warning("Received exception from SBB");
            Test2471Test.this.utils.getLog().warning(e);
            Test2471Test.this.result.setError(e);
        }
    }
}

