/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ServiceManagementMBean;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;

public class Test2470Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2470;
    private ServiceManagementMBeanProxy serviceProxy;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ServiceID[] services = new ServiceID[2];

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        int i;
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        this.serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        int index = 0;
        for (i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            this.services[index++] = (ServiceID)components[i];
        }
        this.utils.getLog().fine("Checking service states.");
        for (i = 0; i < this.services.length; ++i) {
            if (this.serviceProxy.getState(this.services[i]).isInactive()) continue;
            return TCKTestResult.failed(2470, "Services are already active - cannot continue test.");
        }
        this.utils.getLog().fine("Activating via array method.");
        try {
            this.serviceProxy.activate(this.services);
        }
        catch (Exception e) {
            return TCKTestResult.error(e);
        }
        this.utils.getLog().fine("Checking service states.");
        for (i = 0; i < this.services.length; ++i) {
            if (!this.serviceProxy.getState(this.services[i]).isInactive()) continue;
            return TCKTestResult.failed(1617, "Failed to correctly activate services.");
        }
        this.utils.getLog().fine("Activating via array method (should fail)");
        boolean passed = false;
        try {
            this.serviceProxy.activate(this.services);
        }
        catch (InvalidStateException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils.getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(1618, "ServiceManagementMBean.activate() was permitted for active services");
        }
        this.utils.getLog().fine("Deactivating services for next batch of tests.");
        this.serviceProxy.deactivate(this.services[0]);
        this.serviceProxy.deactivate(this.services[1]);
        this.waitForStateChange(this.services[0], ServiceState.INACTIVE);
        this.waitForStateChange(this.services[1], ServiceState.INACTIVE);
        this.utils.getLog().fine("Trying to activate invalid services.");
        passed = false;
        try {
            this.serviceProxy.activate(new ServiceID[0]);
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils.getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2470, "ServiceManagementMBean.activate(new ServiceID[] {}) should have thrown InvalidArgumentException, it didn't.");
        }
        this.utils.getLog().fine("Trying to activate services with null in.");
        passed = false;
        try {
            this.serviceProxy.activate(new ServiceID[]{this.services[0], null});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils.getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2470, "ServiceManagementMBean.activate(new ServiceID[] {ServiceID, null}) should have thrown InvalidArgumentException, it didn't.");
        }
        this.utils.getLog().fine("Trying to activate duplicate services.");
        passed = false;
        try {
            this.serviceProxy.activate(new ServiceID[]{this.services[0], this.services[1], this.services[0]});
        }
        catch (InvalidArgumentException e) {
            passed = true;
        }
        catch (Exception e) {
            this.utils.getLog().fine("Exception thrown: " + e);
            return TCKTestResult.error(e);
        }
        if (!passed) {
            return TCKTestResult.failed(2470, "ServiceManagementMBean.activate(new ServiceID[] {ServiceID_1, ServiceID_2, ServiceID_1}) should have thrown InvalidArgumentException, it didn't.");
        }
        this.utils.getLog().fine("Returning test pass.");
        return TCKTestResult.passed();
    }

    private void waitForStateChange(ServiceID serviceID, ServiceState expectedState) throws Exception {
        int count = 0;
        while (!this.serviceProxy.getState(serviceID).equals((Object)expectedState)) {
            if (count > 10) {
                throw new OperationTimedOutException("Timeout waiting for service " + serviceID + " to enter state " + expectedState);
            }
            Thread.sleep(500L);
            ++count;
        }
        return;
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        try {
            if (this.serviceProxy.getState(this.services[0]).isActive()) {
                this.serviceProxy.deactivate(this.services[0]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.serviceProxy.getState(this.services[1]).isActive()) {
                this.serviceProxy.deactivate(this.services[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test2470Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test2470Test.this.result.setPassed();
            } else {
                Test2470Test.this.result.setFailed(2470, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2470Test.this.utils.getLog().warning("Received exception from SBB");
            Test2470Test.this.utils.getLog().warning(e);
            Test2470Test.this.result.setError(e);
        }
    }
}

