/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ResourceManagementMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceUsageMBeanProxy;
import java.util.HashSet;
import javax.management.ObjectName;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.UsageParameterSetNameAlreadyExistsException;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public class Test1114125Test
extends AbstractSleeTCKTest {
    private static final String RA_NAME = "TCK_Context_Test_RA";
    private static final String RA_ENTITY_NAME1 = "TCK_Context_Test_RA_Entity1";
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    private static final String RESOURCE_DU_PATH_PARAM = "resourceDUPath";
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private ResourceAdaptorID raID;
    private ResourceManagementMBeanProxy resourceMBean;

    public TCKTestResult run() throws Exception {
        this.resourceMBean = this.utils().getResourceManagementMBeanProxy();
        this.getLog().info("Created ResourceManagementMBeanProxy: " + this.resourceMBean);
        FutureResult future = new FutureResult(this.getLog());
        RMIObjectChannel in = this.utils().getRMIObjectChannel();
        in.setMessageHandler(new CallbackListener(future, 1));
        this.raID = new ResourceAdaptorID(RA_NAME, RA_VENDOR, RA_VERSION);
        this.resourceMBean.createResourceAdaptorEntity(this.raID, RA_ENTITY_NAME1, new ConfigProperties());
        this.resourceMBean.activateResourceAdaptorEntity(RA_ENTITY_NAME1);
        ResourceUsageMBeanProxy resourceUsageMBean = this.utils().getResourceUsageMBeanProxy(RA_ENTITY_NAME1);
        this.getLog().fine("Created UsageMBeanProxy");
        TCKTestResult result1 = this.doResourceUsageMBeanCheck(resourceUsageMBean, RA_ENTITY_NAME1);
        this.resourceMBean.deactivateResourceAdaptorEntity(RA_ENTITY_NAME1);
        this.getLog().info("Waiting for RA Entity to enter INACTIVE state");
        ResourceAdaptorEntityState raState = null;
        long timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
        while (System.currentTimeMillis() < timeout && !(raState = this.resourceMBean.getState(RA_ENTITY_NAME1)).isInactive()) {
            Thread.sleep(500L);
        }
        this.getLog().fine("Current RA state = " + raState);
        if (!ResourceAdaptorEntityState.INACTIVE.equals((Object)raState)) {
            return TCKTestResult.failed(0x11000D, "RA did not transition into the INACTIVE state within test timeout");
        }
        return result1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.utils().removeRAEntities();
        }
        finally {
            super.tearDown();
        }
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty(RESOURCE_DU_PATH_PARAM);
        this.getLog().fine("Installing DU: " + duPath);
        this.utils().install(duPath);
    }

    private TCKTestResult doResourceUsageMBeanCheck(ResourceUsageMBeanProxy theResourceUsageMBean, String theEntity) throws InterruptedException {
        block37: {
            ObjectName objectName;
            int i;
            String[] paramSets;
            String ENTITY1_PARAM_SET_NAME = "testUsageParameter1";
            String BAD_PARAM_SET_NAME = "badParamSet";
            String EXPECTED_RA_OBJ_NAME = "javax.slee.management.usage:type=ResourceUsage,raEntityName=\"TCK_Context_Test_RA_Entity1\"";
            String EXPECTED_USAGE_OBJ_NAME = "javax.slee.usage:type=Usage,notificationSource=javax.slee.management.usage.raentity,raEntityName=\"TCK_Context_Test_RA_Entity1\"";
            String EXPECTED_USAGE_PARAM_OBJ_NAME = "javax.slee.usage:type=Usage,notificationSource=javax.slee.management.usage.raentity,raEntityName=\"TCK_Context_Test_RA_Entity1\",parameterSetName=\"testUsageParameter1\"";
            String EXPECTED_USAGE_NOTIFY_OBJ_NAME = "javax.slee.usage:type=UsageNotificationManager,notificationSource=javax.slee.management.usage.raentity,raEntityName=\"TCK_Context_Test_RA_Entity1\"";
            String usageParamSet = null;
            try {
                ResourceManagementMBeanProxy resourceManagementMBean = this.utils().getResourceManagementMBeanProxy();
                ObjectName objectName2 = resourceManagementMBean.getResourceUsageMBean(theEntity);
                this.getLog().fine("1114432: ResourceUsageMBean = " + objectName2);
                if (!objectName2.equals(new ObjectName(EXPECTED_RA_OBJ_NAME))) {
                    return TCKTestResult.failed(0x110140, "getResourceUsageMBean() returned: " + objectName2);
                }
                this.logSuccessfulCheck(0x110140);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(0x110140, "getResourceManagementMBean() failed");
            }
            try {
                String entityName = theResourceUsageMBean.getEntityName();
                this.getLog().fine("1114102: getEntityName = " + entityName);
                if (!entityName.equals(theEntity)) {
                    return TCKTestResult.failed(1114102, "entityName() returned wrong Entity " + entityName);
                }
                this.logSuccessfulCheck(1114102);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114102, "getEntityName() failed");
            }
            try {
                theResourceUsageMBean.createUsageParameterSet(ENTITY1_PARAM_SET_NAME);
                this.logSuccessfulCheck(0x110013);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(0x110013, "createUsageParameterSet() failed");
            }
            try {
                theResourceUsageMBean.createUsageParameterSet(ENTITY1_PARAM_SET_NAME);
                return TCKTestResult.failed(1114067, "createUsageParameterSet() did not recognise already exists");
            }
            catch (UsageParameterSetNameAlreadyExistsException e) {
                this.logSuccessfulCheck(1114067);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114067, "createUsageParameterSet() failed");
            }
            try {
                boolean found = false;
                paramSets = theResourceUsageMBean.getUsageParameterSets();
                if (paramSets.length > 0) {
                    for (i = 0; i < paramSets.length; ++i) {
                        this.getLog().fine("1114097: getUsageParameterSets = " + paramSets[i].toString());
                        if (!paramSets[i].toString().equals(ENTITY1_PARAM_SET_NAME)) continue;
                        usageParamSet = paramSets[i];
                        this.logSuccessfulCheck(0x10FFF1);
                        found = true;
                    }
                    if (!found) {
                        return TCKTestResult.failed(0x10FFF1, "getUsageParameterSets did not contain RA Entity Parameter Set: " + ENTITY1_PARAM_SET_NAME);
                    }
                }
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(0x10FFF1, "getUsageParameterSets() failed");
            }
            try {
                theResourceUsageMBean.resetAllUsageParameters();
                this.logSuccessfulCheck(1114087);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114087, "resetAllUsageParameters() failed");
            }
            try {
                objectName = theResourceUsageMBean.getUsageMBean();
                this.getLog().fine("1114066: getUsageMBean = " + objectName);
                if (!objectName.equals(new ObjectName(EXPECTED_USAGE_OBJ_NAME))) {
                    return TCKTestResult.failed(1114066, "getUsageMBean() returned: " + objectName);
                }
                this.logSuccessfulCheck(1114066);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114066, "getUsageMBean() failed");
            }
            try {
                objectName = theResourceUsageMBean.getUsageMBean(ENTITY1_PARAM_SET_NAME);
                this.getLog().fine("1114431: getUsageMBean = " + objectName);
                if (!objectName.equals(new ObjectName(EXPECTED_USAGE_PARAM_OBJ_NAME))) {
                    return TCKTestResult.failed(1114431, "getUsageMBean() returned: " + objectName);
                }
                this.logSuccessfulCheck(1114431);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114431, "getUsageMBean() failed");
            }
            try {
                objectName = theResourceUsageMBean.getUsageMBean(BAD_PARAM_SET_NAME);
                return TCKTestResult.failed(1114062, "getUsageMBean() did not recognise parameter set does not exist");
            }
            catch (UnrecognizedUsageParameterSetNameException e) {
                this.logSuccessfulCheck(1114062);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114062, "getUsageMBean() failed");
            }
            try {
                ObjectName objectName3 = theResourceUsageMBean.getUsageNotificationManagerMBean();
                this.getLog().fine("1114063: getUsageNotificationManagerMBean = " + objectName3);
                if (!objectName3.equals(new ObjectName(EXPECTED_USAGE_NOTIFY_OBJ_NAME))) {
                    return TCKTestResult.failed(1114063, "getUsageNotificationManagerMBean() returned: " + objectName3);
                }
                this.logSuccessfulCheck(1114063);
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114063, "getUsageNotificationManagerMBean() failed");
            }
            try {
                boolean found = false;
                theResourceUsageMBean.removeUsageParameterSet(ENTITY1_PARAM_SET_NAME);
                paramSets = theResourceUsageMBean.getUsageParameterSets();
                if (paramSets.length == 0) {
                    this.getLog().fine("1114080: No Parameter sets present ");
                    this.logSuccessfulCheck(1114080);
                    break block37;
                }
                this.getLog().fine("1114080: Number of Parameter sets = " + paramSets.length);
                for (i = 0; i < paramSets.length; ++i) {
                    this.getLog().fine("1114097: getUsageParameterSets = " + paramSets[i].toString());
                    if (!paramSets[i].toString().equals(ENTITY1_PARAM_SET_NAME)) continue;
                    found = true;
                }
                if (!found) {
                    this.logSuccessfulCheck(1114080);
                    break block37;
                }
                return TCKTestResult.failed(1114080, "removeUsageParameterSet() did not remove Parameter Set");
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.failed(1114080, "removeUsageParameterSet() failed");
            }
        }
        try {
            theResourceUsageMBean.close();
            this.logSuccessfulCheck(1114064);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114064, "close() raised exception ");
        }
        return TCKTestResult.passed();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    private class CallbackListener
    implements MessageHandler {
        private FutureResult result;
        private int expectedCount;
        private HashSet raEntities = new HashSet();

        public CallbackListener(FutureResult result, int expectedCount) {
            this.result = result;
            this.expectedCount = expectedCount;
            Test1114125Test.this.getLog().fine("CallbackListener received message ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Object objectMessage) {
            if (objectMessage instanceof TCKMessage) {
                TCKMessage message = (TCKMessage)objectMessage;
                UOID uoid = message.getUID();
                int method = message.getMethod();
                if (method == 5) {
                    HashSet hashSet = this.raEntities;
                    synchronized (hashSet) {
                        this.raEntities.add(uoid);
                        if (this.raEntities.size() == this.expectedCount) {
                            this.result.setPassed();
                        }
                    }
                }
                if (method == 6) {
                    HashSet hashSet = this.raEntities;
                    synchronized (hashSet) {
                        this.raEntities.remove(uoid);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

