/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileAlreadyExistsException;
import javax.slee.profile.ProfileSpecificationID;

public class Test3900Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 3900;
    private SleeTCKTestUtils utils;
    private ProfileProvisioningMBeanProxy profileProxy;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            this.profileProxy.createProfileTable(profileSpecID, "Test3900ProfileTable");
            ObjectName jmxObjectName = null;
            jmxObjectName = this.profileProxy.createProfile("Test3900ProfileTable", "Test3900Profile");
            ProfileMBeanProxy profProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(jmxObjectName);
            profProxy.commitProfile();
            profProxy.closeProfile();
            try {
                this.profileProxy.createProfile("Test3900ProfileTable", "Test3900Profile");
            }
            catch (ProfileAlreadyExistsException e) {
                return TCKTestResult.passed();
            }
            return TCKTestResult.failed(3900, "Was permitted to create a second profile with the same name in the same profile table.");
        }
        return TCKTestResult.error("No ProfileSpecification found.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        this.profileUtils = new ProfileUtils(this.utils);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        if (this.profileProxy != null) {
            try {
                this.profileProxy.removeProfile("Test3900ProfileTable", "Test3900Profile");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.profileProxy.removeProfileTable("Test3900ProfileTable");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test3900Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test3900Test.this.result.setPassed();
            } else {
                Test3900Test.this.result.setFailed(3900, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test3900Test.this.utils.getLog().warning("Received exception from SBB");
            Test3900Test.this.utils.getLog().warning(e);
            Test3900Test.this.result.setError(e);
        }
    }
}

