/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class Test3870Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final String PROFILE_TABLE_NAME = "Test3870ProfileTable";
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;

    public TCKTestResult run() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils());
        ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ProfileSpecificationID profileSpecID = null;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            profileSpecID = (ProfileSpecificationID)components[i];
            profileProxy.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
            if (!profileProxy.getProfileTables().contains(PROFILE_TABLE_NAME)) {
                return TCKTestResult.error("The profile table Test3870ProfileTable did not appear to be created following a call to createProfileTable()");
            }
            try {
                this.getLog().info("Calling removeProfileTable with a null table name");
                profileProxy.removeProfileTable(null);
                return TCKTestResult.failed(3871, "Failed to throw NullPointerException when given a null ProfileTableName");
            }
            catch (NullPointerException e) {
                this.getLog().info("Caught the expected NullPointerException after passing a null ProfileTableName to removeProfileTable()");
                try {
                    this.getLog().info("Calling removeProfileTable with the name of an existing profile table: Test3870ProfileTable");
                    profileProxy.removeProfileTable(PROFILE_TABLE_NAME);
                }
                catch (Exception e2) {
                    return TCKTestResult.failed(3870, "removeProfileTable() threw an unexpected Exception when invoked with the name of an existing profile table Test3870ProfileTable. Exception:" + e2);
                }
                if (profileProxy.getProfileTables().contains(PROFILE_TABLE_NAME)) {
                    return TCKTestResult.failed(3870, "The profile table Test3870ProfileTable did not appear to be removed following a call to removeProfileTable(). It was in the set returned by getProfileTables()");
                }
                try {
                    String invalidName = "Test3870ThisProfileDoesNotExist";
                    this.getLog().info("Calling removeProfileTable with the name that does not reference an existing profile table: " + invalidName);
                    profileProxy.removeProfileTable(invalidName);
                    return TCKTestResult.failed(3872, "Failed to throw UnrecognizedProfileTableNameException when given a non-existent ProfileTableName");
                }
                catch (UnrecognizedProfileTableNameException e3) {
                    this.getLog().info("Caught the expected UnrecognizedProfileTableNameException after passing a non-existent ProfileTableName to removeProfileTable()");
                    return TCKTestResult.passed();
                }
            }
        }
        return TCKTestResult.error("Unable to find any ProfileSpecifications to work with.");
    }

    public void setUp() throws Exception {
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils().install(duPath);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null) {
            ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
            try {
                profileProxy.removeProfileTable(PROFILE_TABLE_NAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.tearDown();
    }
}

