/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileTableAlreadyExistsException;
import javax.slee.profile.UnrecognizedProfileSpecificationException;

public class Test3864Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 3864;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils);
        ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ProfileSpecificationID profileSpecID = null;
        boolean pass = false;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            profileSpecID = (ProfileSpecificationID)components[i];
            try {
                profileProxy.createProfileTable(profileSpecID, null);
            }
            catch (NullPointerException e) {
                pass = true;
            }
            if (!pass) {
                return TCKTestResult.failed(3864, "Failed to throw NullPointerException when given null ProfileTableName argument.");
            }
            pass = false;
            try {
                profileProxy.createProfileTable(profileSpecID, "");
            }
            catch (InvalidArgumentException e) {
                pass = true;
            }
            if (!pass) {
                return TCKTestResult.failed(3866, "Failed to throw InvalidArgumentException when given a zero-length profile table name.");
            }
            pass = false;
            try {
                profileProxy.createProfileTable(profileSpecID, "Test3864/Profile");
            }
            catch (InvalidArgumentException e) {
                pass = true;
            }
            if (!pass) {
                return TCKTestResult.failed(3866, "Failed to throw InvalidArgumentException when given a profile table name containing a /.");
            }
            pass = false;
            profileProxy.createProfileTable(profileSpecID, "Test3864ProfileTable");
            try {
                profileProxy.createProfileTable(profileSpecID, "Test3864ProfileTable");
            }
            catch (ProfileTableAlreadyExistsException e) {
                pass = true;
            }
            if (!pass) {
                return TCKTestResult.failed(3867, "Failed to throw ProfileTableAlreadyExistsException when creating an already existant profile table.");
            }
            profileProxy.removeProfileTable("Test3864ProfileTable");
            break;
        }
        if (profileSpecID == null) {
            return TCKTestResult.error("No ProfileSpecification found.");
        }
        duProxy.uninstall(this.duID);
        pass = false;
        try {
            profileProxy.createProfileTable(profileSpecID, "Test3864Test");
        }
        catch (UnrecognizedProfileSpecificationException e) {
            pass = true;
        }
        if (!pass) {
            return TCKTestResult.failed(3865, "Failed to throw UnrecognizedProfileSpecificationException when given invalid ProfileSpecificationID argument.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test3864Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test3864Test.this.result.setPassed();
            } else {
                Test3864Test.this.result.setFailed(3864, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test3864Test.this.utils.getLog().warning("Received exception from SBB");
            Test3864Test.this.utils.getLog().warning(e);
            Test3864Test.this.result.setError(e);
        }
    }
}

