/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileNameException;

public class Test1644Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1644;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            try {
                profileProxy.createProfileTable(profileSpecID, "Test1644ProfileTable");
            }
            catch (Exception e) {
                return TCKTestResult.error("Failed to create profile table.");
            }
            ObjectName jmxObjectName = null;
            try {
                jmxObjectName = profileProxy.createProfile("Test1644ProfileTable", "Test1644Profile");
            }
            catch (Exception e) {
                return TCKTestResult.failed(1644, "ProfileProvisioningMBean.createProfile(String, String) threw an Exception.");
            }
            if (jmxObjectName == null) {
                return TCKTestResult.failed(1644, "ProfileProvisioningMBean.createProfile(String, String) didn't return a valid ObjectName object.");
            }
            ProfileMBeanProxy proxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(jmxObjectName);
            proxy.commitProfile();
            try {
                ObjectName profileObject = profileProxy.getProfile("Test1644ProfileTable", "Test1644Profile");
                if (!profileObject.equals(jmxObjectName)) {
                    return TCKTestResult.failed(1646, "ProfileProvisioningMBean.getProfile(String, String) returned the wrong (or no) profile.");
                }
            }
            catch (Exception e) {
                return TCKTestResult.failed(1646, "ProfileProvisioningMBean.getProfile(String, String) returned the wrong (or no) profile.");
            }
            try {
                profileProxy.removeProfile("Test1644ProfileTable", "Test1644Profile");
            }
            catch (Exception e) {
                return TCKTestResult.failed(1645, "ProfileProvisioningMBean.removeProfile(String, String) threw an Exception.");
            }
            try {
                profileProxy.getProfile("Test1644ProfileTable", "Test1644Profile");
            }
            catch (UnrecognizedProfileNameException e) {
                return TCKTestResult.passed();
            }
            return TCKTestResult.failed(1661, "getProfile() should have thrown UnrecognizedProfileNameException, but didn't.");
        }
        return TCKTestResult.error("No ProfileSpecification found.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        this.profileUtils = new ProfileUtils(this.utils);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
        try {
            profileProxy.removeProfile("Test1644ProfileTable", "Test1644Profile");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            profileProxy.removeProfileTable("Test1644ProfileTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test1644Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test1644Test.this.result.setPassed();
            } else {
                Test1644Test.this.result.setFailed(1644, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1644Test.this.utils.getLog().warning("Received exception from SBB");
            Test1644Test.this.utils.getLog().warning(e);
            Test1644Test.this.result.setError(e);
        }
    }
}

