/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileSpecificationException;

public class Test1638Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1638;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.profileUtils = new ProfileUtils(this.utils);
        ProfileProvisioningMBeanProxy profileProxy = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            try {
                profileProxy.createProfileTable(profileSpecID, "Test1638ProfileTable");
            }
            catch (Exception e) {
                return TCKTestResult.failed(1638, "Failed to create profile table.");
            }
            if (!profileProxy.getProfileSpecification("Test1638ProfileTable").equals((Object)profileSpecID)) {
                return TCKTestResult.failed(1641, "getProfileSpecification() returned incorrect ProfileSpecificationID.");
            }
            try {
                profileProxy.renameProfileTable("Test1638ProfileTable", "Test1638NewProfileTable");
            }
            catch (Exception e) {
                return TCKTestResult.failed(1640, "Failed to rename profile table.");
            }
            try {
                profileProxy.removeProfileTable("Test1638NewProfileTable");
            }
            catch (Exception e) {
                return TCKTestResult.failed(1639, "Failed to remove profile table.");
            }
            duProxy.uninstall(this.duID);
            try {
                profileProxy.createProfileTable(profileSpecID, "Test1638ProfileTable");
            }
            catch (UnrecognizedProfileSpecificationException e) {
                return TCKTestResult.passed();
            }
            return TCKTestResult.failed(1659, "Should have thrown UnrecognizedProfileSpecificationException when trying to create ProfileTable from invalid ProfileSpecificationID.");
        }
        return TCKTestResult.error("No ProfileSpecification found.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("Test1638ProfileTable");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.profileUtils.removeProfileTable("Test1638NewProfileTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test1638Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test1638Test.this.result.setPassed();
            } else {
                Test1638Test.this.result.setFailed(1638, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1638Test.this.utils.getLog().warning("Received exception from SBB");
            Test1638Test.this.utils.getLog().warning(e);
            Test1638Test.this.result.setError(e);
        }
    }
}

