/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class Test1114003Test
implements SleeTCKTest {
    private static final String PROFILE_DU_PATH_PARAM = "profileDUPath";
    private static final int ASSERTION_ID = 1114003;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private ProfileUtils profileUtils;
    private Vector tablesAdded;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("Test1114003Profile", "jain.slee.tck", "1.1");
        if (profileSpecID == null) {
            throw new TCKTestErrorException("No ProfileSpecification found.");
        }
        String validName = "Test1114003Profile";
        try {
            this.utils.getLog().info("Attempting to create a profile table with the following valid name: " + validName);
            profileProvisioningProxy.createProfileTable(profileSpecID, validName);
            this.tablesAdded.addElement(validName);
            this.utils.getLog().info("The createProfileTable() method threw no Exception. Calling getProfileTables() to check whether the profile table was created");
            Collection profileTableNames = profileProvisioningProxy.getProfileTables(profileSpecID);
            if (profileTableNames.size() < 1) {
                return TCKTestResult.failed(1114003, "No profile tables exist as returned by getProfileTables()");
            }
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(1114003, "ProfileProvisioningMBean has error creating ProfileTables: " + e.getClass().toString());
        }
        try {
            ObjectName object = profileProvisioningProxy.getProfileTableUsageMBean(validName);
            this.utils.getLog().fine("ProfileTableUsageMBean is: " + object.toString());
            if (!object.toString().equals("javax.slee.management.usage:type=ProfileTableUsage,profileTableName=\"Test1114003Profile\"")) {
                return TCKTestResult.failed(1114003, "ProfileProvisioningMBean.getProfileTableUsageMBean has returned incorrect object name: " + object.toString());
            }
            this.logSuccessfulCheck(1114003);
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(1114003, "ProfileProvisioningMBean.getProfileTableUsageMBean has thrown Exception: " + e.getClass().toString());
        }
        String nullName = null;
        try {
            ObjectName object = profileProvisioningProxy.getProfileTableUsageMBean(nullName);
            return TCKTestResult.failed(1114575, "ProfileProvisioningMBean.getProfileTableUsageMBean has not thrown Exception: NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114575);
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(1114575, "ProfileProvisioningMBean.getProfileTableUsageMBean has thrown Exception: " + e.getClass().toString());
        }
        String badName = "BadProfile";
        try {
            ObjectName object = profileProvisioningProxy.getProfileTableUsageMBean(badName);
            return TCKTestResult.failed(0x1101D0, "ProfileProvisioningMBean.getProfileTableUsageMBean has thrown Exception: UnrecognizedProfileTableNameException");
        }
        catch (UnrecognizedProfileTableNameException e) {
            this.logSuccessfulCheck(0x1101D0);
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(0x1101D0, "ProfileProvisioningMBean.getProfileTableUsageMBean has thrown Exception: " + e.getClass().toString());
        }
        try {
            ProfileSpecificationID noUsageProfileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID("SimpleProfile11", "jain.slee.tck", "1.1");
            if (noUsageProfileSpecID == null) {
                throw new TCKTestErrorException("No ProfileSpecification found.");
            }
            profileProvisioningProxy.createProfileTable(noUsageProfileSpecID, "Test1114003NoUsageProfile");
            this.tablesAdded.addElement("Test1114003NoUsageProfile");
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(1114003, "ProfileProvisioningMBean has error creating ProfileTables: " + e.getClass().toString());
        }
        try {
            ObjectName object = profileProvisioningProxy.getProfileTableUsageMBean("Test1114003NoUsageProfile");
            return TCKTestResult.failed(0x1101D1, "ProfileProvisioningMBean.getProfileTableUsageMBean has not thrown Exception: InvalidArgumentException");
        }
        catch (InvalidArgumentException e) {
            this.logSuccessfulCheck(0x1101D1);
        }
        catch (Exception e) {
            this.utils.getLog().warning(e);
            return TCKTestResult.failed(0x1101D1, "ProfileProvisioningMBean.getProfileTableUsageMBean has thrown Exception: " + e.getClass().toString());
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.tablesAdded = new Vector();
        String duPath = this.utils.getTestParams().getProperty(PROFILE_DU_PATH_PARAM);
        this.utils.getLog().fine("Installing the profile spec: " + duPath);
        this.utils.install(duPath);
        this.profileUtils = new ProfileUtils(this.utils);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null && this.tablesAdded != null && !this.tablesAdded.isEmpty()) {
            Iterator tablesAddedIter = this.tablesAdded.iterator();
            while (tablesAddedIter.hasNext()) {
                try {
                    this.profileUtils.removeProfileTable((String)tablesAddedIter.next());
                }
                catch (Exception e) {
                    this.utils.getLog().warning(e);
                }
            }
        }
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().removeResourceListener();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils.getLog().info("Check for assertion " + assertionID + " OK");
    }
}

