/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.NotificationSource;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceTest;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.util.Future;
import java.util.HashMap;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.management.AlarmNotification;
import javax.slee.management.NotificationSource;
import javax.slee.management.ResourceAdaptorEntityNotification;

public class Test1114242Test
extends BaseResourceTest {
    private static final int ASSERTION_ID1 = 1114242;
    private boolean passed = false;
    private FutureResult result;
    private boolean alarmProcessed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        Future future = new Future();
        this.utils().getAlarmMBeanProxy().addNotificationListener(new AlarmNotificationListenerImpl(future), null, null);
        HashMap resultmap = this.sendMessage(26);
        if (resultmap == null) {
            throw new TCKTestFailureException(1114242, "Test timed out while waiting for response to getAlarmFacility()");
        }
        Object mapResult = resultmap.get("result");
        if (mapResult instanceof Exception) {
            throw new TCKTestFailureException(1114242, "Exception thrown while invoking getAlarmFacility()", (Exception)mapResult);
        }
        if (Boolean.FALSE.equals(mapResult)) {
            throw new TCKTestFailureException(1114242, "ResourceAdaptorContext.getAlarmFacility() returned null");
        }
        if (!Boolean.TRUE.equals(mapResult)) {
            throw new TCKTestErrorException("Unexpected result received while invoking getAlarmFacility(): " + result);
        }
        Test1114242Test test1114242Test = this;
        synchronized (test1114242Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (!this.passed) {
            if (this.alarmProcessed) {
                throw new TCKTestFailureException(1114242, "Unexpected alarm notification type received in notification. ");
            }
            throw new TCKTestFailureException(1114242, "Did not receive alarm notification within the timeout period ");
        }
        result.setPassed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            AlarmMBeanProxy alarmMBean = this.utils().getAlarmMBeanProxy();
            String[] alarms = alarmMBean.getAlarms();
            for (int i = 0; i < alarms.length; ++i) {
                alarmMBean.clearAlarm(alarms[i]);
            }
        }
        finally {
            super.tearDown();
        }
    }

    private boolean doNotficationSourcesCheck(ResourceAdaptorEntityNotification theNotification) {
        String usageMBeanProperties;
        String alarmNotify;
        ResourceAdaptorEntityNotification expectedRANotification = null;
        boolean passed = true;
        String entityName = null;
        String expectedRAentity = "TCK_Context_Test_RA_Entity";
        try {
            entityName = theNotification.getEntityName();
            this.getLog().fine("1114240: getEntityName : " + entityName);
            if (entityName.equals("TCK_Context_Test_RA_Entity")) {
                this.logSuccessfulCheck(0x110080);
            } else {
                this.result.setFailed(0x110080, "Incorrect RA Entity Name");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(0x110080, "Incorrect RA Entity Name");
            return false;
        }
        try {
            String notification = theNotification.toString();
            this.getLog().fine("1114243: toString() : " + notification);
            this.logSuccessfulCheck(1114243);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114243, "Incorrect Notification Name");
            return false;
        }
        try {
            theNotification.hashCode();
            this.logSuccessfulCheck(1114246);
        }
        catch (Exception e) {
            this.result.setFailed(1114246, ".hashCode() failed");
            return false;
        }
        expectedRANotification = new ResourceAdaptorEntityNotification("TCK_Context_Test_RA_Entity");
        ResourceAdaptorEntityNotification notExpectedRANotification = new ResourceAdaptorEntityNotification("TCK_Context_Test_RA_Entity2");
        try {
            this.getLog().fine("1114223: theNotification.equals : " + theNotification + ", " + expectedRANotification);
            if (theNotification.equals((Object)expectedRANotification)) {
                this.logSuccessfulCheck(1114223);
            } else {
                this.result.setFailed(1114223, ".equals() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114223, ".equals() failed");
            return false;
        }
        try {
            int areCompared = theNotification.compareTo((Object)expectedRANotification);
            if (areCompared == 0) {
                areCompared = theNotification.compareTo((Object)notExpectedRANotification);
                this.getLog().fine("1114224: notExpectedProfileNotification = : " + notExpectedRANotification);
                if (areCompared != 0) {
                    this.logSuccessfulCheck(0x110070);
                } else {
                    this.result.setFailed(0x110070, ".compareTo() failed non-equal test");
                }
            } else {
                this.result.setFailed(0x110070, ".compareTo() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(0x110070, ".compareTo() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getAlarmNotificationType();
            this.getLog().fine("1114247: getAlarmNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.alarm.raentity")) {
                this.logSuccessfulCheck(1114247);
            } else {
                this.result.setFailed(1114247, "getAlarmNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114247, "getAlarmNotificationType() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getTraceNotificationType();
            this.getLog().fine("1114239: getTraceNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.trace.raentity")) {
                this.logSuccessfulCheck(1114239);
            } else {
                this.result.setFailed(1114239, "getTraceNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114239, "getTraceNotificationType() failed");
            return false;
        }
        try {
            String raNotify = theNotification.getUsageNotificationType();
            this.getLog().fine("1114245: getUsageNotificationType = " + raNotify);
            if (raNotify.equals("javax.slee.management.usage.raentity")) {
                this.logSuccessfulCheck(1114245);
            } else {
                this.result.setFailed(1114245, "getUsageNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114245, "getUsageNotificationType() failed");
            return false;
        }
        try {
            usageMBeanProperties = theNotification.getUsageMBeanProperties();
            this.getLog().fine("1114244: getUsageMBeanProperties = " + usageMBeanProperties);
            if (usageMBeanProperties.contains("TCK_Context_Test_RA_Entity")) {
                this.logSuccessfulCheck(1114244);
            } else {
                this.result.setFailed(1114244, "getUsageNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114244, "getUsageNotificationType() failed");
            return false;
        }
        try {
            usageMBeanProperties = ResourceAdaptorEntityNotification.getUsageMBeanProperties((String)entityName);
            this.getLog().fine("1114413: getUsageMBeanProperties = " + usageMBeanProperties);
            if (usageMBeanProperties.contains("TCK_Context_Test_RA_Entity")) {
                this.logSuccessfulCheck(1114413);
            } else {
                this.result.setFailed(1114413, "getUsageNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114413, "getUsageNotificationType() failed");
            return false;
        }
        return passed;
    }

    protected void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        private Future future;

        public AlarmNotificationListenerImpl(Future future) {
            this.future = future;
        }

        public final void handleNotification(Notification notification, Object handback) {
            Test1114242Test.this.getLog().info("Notification received: " + notification);
            if (notification instanceof AlarmNotification) {
                Test1114242Test.this.getLog().fine("Received Alarm Notification: " + notification);
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                if (!Test1114242Test.this.alarmProcessed && alarmNotification.getType().equals("javax.slee.management.alarm.raentity")) {
                    NotificationSource notificationSource = alarmNotification.getNotificationSource();
                    ResourceAdaptorEntityNotification resourceNotification = (ResourceAdaptorEntityNotification)notificationSource;
                    Test1114242Test.this.passed = Test1114242Test.this.doNotficationSourcesCheck(resourceNotification);
                    Test1114242Test.this.alarmProcessed = true;
                    if (Test1114242Test.this.passed) {
                        Test1114242Test.this.logSuccessfulCheck(1114242);
                    }
                }
            }
        }
    }
}

