/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ManagementMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ServiceID;
import javax.slee.management.ServiceState;

public class Test1891Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1891;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ServiceManagementMBeanProxy serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
        ServiceID[] services = serviceProxy.getServices(ServiceState.INACTIVE);
        int nStartServices = services.length;
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.utils.install(duPath);
        services = serviceProxy.getServices(ServiceState.INACTIVE);
        if (services.length != nStartServices + 1) {
            return TCKTestResult.failed(1891, "The SLEE didn't automatically install the Service after all components installed correctly.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test1891Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test1891Test.this.result.setPassed();
            } else {
                Test1891Test.this.result.setFailed(1891, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1891Test.this.utils.getLog().warning("Received exception from SBB");
            Test1891Test.this.utils.getLog().warning(e);
            Test1891Test.this.result.setError(e);
        }
    }
}

