/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.DeploymentMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import javax.slee.ComponentID;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;
import javax.slee.management.UnrecognizedDeployableUnitException;

public class Test1893Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private DeployableUnitID duID = null;

    public TCKTestResult run() throws Exception {
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        duPath = this.utils().getDeploymentUnitURL(duPath);
        try {
            this.duID = this.utils().getDeploymentMBeanProxy().install(duPath);
            Assert.fail(1892, "Expected javax.slee.management.DeploymentException not thrown when installing a deployable unit that contains invalid components");
        }
        catch (DeploymentException e) {
            this.getLog().info("Got expected javax.slee.management.DeploymentException");
        }
        try {
            this.utils().getDeploymentMBeanProxy().getDeployableUnit(duPath);
            Assert.fail(1892, "Expected javax.slee.management.UnrecognizedDeployableUnitException not thrown when getting DeployableUnitID for a deployable unnit that was not installed");
        }
        catch (UnrecognizedDeployableUnitException e) {
            this.getLog().info("Got expected javax.slee.management.UnrecognizedDeployableUnitException");
        }
        Assert.assertTrue(1893, "Some components from a deployable unit that failed to install correctly remain installed in the SLEE", !this.isInstalled("Test1893Profile", "jain.slee.tck", "1.0", this.utils().getDeploymentMBeanProxy().getDescriptors((ComponentID[])this.utils().getDeploymentMBeanProxy().getProfileSpecifications())) && !this.isInstalled("com.opencloud.sleetck.lib.management.DeploymentMBean.Test1893Event", "jain.slee.tck", "1.0", this.utils().getDeploymentMBeanProxy().getDescriptors((ComponentID[])this.utils().getDeploymentMBeanProxy().getEventTypes())) && !this.isInstalled("Test1893Service", "jain.slee.tck", "1.0", this.utils().getDeploymentMBeanProxy().getDescriptors((ComponentID[])this.utils().getDeploymentMBeanProxy().getServices())));
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        if (null != this.duID) {
            this.utils().getDeploymentMBeanProxy().uninstall(this.duID);
        }
    }

    private boolean isInstalled(String name, String vendor, String version, ComponentDescriptor[] components) {
        for (int i = 0; i < components.length; ++i) {
            ComponentDescriptor component = components[i];
            if (!component.getName().equals(name) || !component.getVendor().equals(vendor) || !component.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }
}

