/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.DeploymentMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedServiceException;
import javax.slee.management.DeployableUnitID;

public class Test1114335Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1114335;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        DeployableUnitID duID;
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        try {
            String fullURL = this.utils().getDeploymentUnitURL(duPath);
            duID = this.utils().getDeploymentMBeanProxy().install(fullURL);
        }
        catch (Exception e) {
            return TCKTestResult.failed(1114335, "Failed to install deployable unit.");
        }
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        try {
            ServiceID[] serviceIDs = duProxy.getServices();
            if (serviceIDs.length == 0) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(1114335, "DeploymentMBean.getServices() returned incorrect number of services.");
                return tCKTestResult;
            }
            SbbID[] sbbIDs = duProxy.getSbbs(serviceIDs[0]);
            if (sbbIDs.length == 0) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(1114335, "DeploymentMBean.getServices() returned incorrect number of SBBs.");
                return tCKTestResult;
            }
            try {
                this.logSuccessfulCheck(1114335);
            }
            catch (NullPointerException e) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(1114335, "DeploymentMBean.getSbbs(serviceID) didn't contain serviceID");
                return tCKTestResult;
            }
            catch (UnrecognizedServiceException e) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(1114335, "DeploymentMBean.getSbbs(serviceID) didn't recognise serviceID");
                return tCKTestResult;
            }
            catch (Exception e) {
                TCKTestResult tCKTestResult = TCKTestResult.failed(1114335, "DeploymentMBean.getSbbs(serviceID) has thrown Exception: " + e.getClass().toString());
                return tCKTestResult;
            }
            serviceIDs[0] = new ServiceID("Non", "Existent", "Service");
            duProxy.getSbbs(serviceIDs[0]);
            TCKTestResult e = TCKTestResult.failed(1114539, "DeploymentMBean.getSbbs(serviceID) didn't throw UnrecognizedServiceException");
            return e;
        }
        finally {
            this.utils().getLog().fine("Deactivating and uninstalling service");
            duProxy.uninstall(duID);
        }
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getResourceInterface().removeResourceListener();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }
}

