/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.query;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.javax.slee.profile.query.MyInteger;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Locale;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.query.And;
import javax.slee.profile.query.CompositeQueryExpression;
import javax.slee.profile.query.Equals;
import javax.slee.profile.query.GreaterThan;
import javax.slee.profile.query.GreaterThanOrEquals;
import javax.slee.profile.query.HasPrefix;
import javax.slee.profile.query.LessThan;
import javax.slee.profile.query.LessThanOrEquals;
import javax.slee.profile.query.LongestPrefixMatch;
import javax.slee.profile.query.Not;
import javax.slee.profile.query.NotEquals;
import javax.slee.profile.query.Or;
import javax.slee.profile.query.OrderedQueryExpression;
import javax.slee.profile.query.QueryCollator;
import javax.slee.profile.query.QueryExpression;
import javax.slee.profile.query.RangeMatch;
import javax.slee.profile.query.SimpleQueryExpression;

public class Test1110915Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private static final String SPEC_NAME = "Test1110915Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final String PROFILE_TABLE_NAME = "Test1110915ProfileTable";
    private static final int TEST_ID = 1110915;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, PROFILE_TABLE_NAME);
        this.getLog().fine("Added profile table Test1110915ProfileTable");
        try {
            this.testSimpleQueryExpression();
            this.testEquals();
            this.testNotEquals();
            this.testOrderedQueryExpression();
            this.testGreaterThan();
            this.testGreaterThanOrEquals();
            this.testLessThan();
            this.testLessThanOrEquals();
            this.testHasPrefix();
            this.testLongestPrefixMatch();
            this.testRangeMatch();
            this.testCompositeQuery();
            this.testAnd();
            this.testOr();
            this.testNot();
            this.testRangeMatch();
        }
        catch (TCKTestFailureException e) {
            return TCKTestResult.failed(e);
        }
        return TCKTestResult.passed();
    }

    private void testSimpleQueryExpression() throws Exception {
        MySimpleQueryExpression simpleNullCollator;
        MySimpleQueryExpression simple;
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            simple = new MySimpleQueryExpression("stringValue", "42", collator);
            this.getLog().fine("MySimpleQueryExpression(String, Object, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101103, "MySimpleQueryExpression(String, Object, QueryCollator) threw exception.", e);
        }
        try {
            simpleNullCollator = new MySimpleQueryExpression("stringValue", "42", null);
            this.getLog().fine("MySimpleQueryExpression(String, Object, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101104, "MySimpleQueryExpression(String, Object, null) threw exception.", e);
        }
        try {
            new MySimpleQueryExpression(null, "42", collator);
            throw new TCKTestFailureException(11101105, "NullPointerException should have been thrown for 'SimpleQueryExpression(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("SimpleQueryExpression(null, String, QueryCollator) threw exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101105, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new MySimpleQueryExpression("stringValue", null, collator);
            throw new TCKTestFailureException(11101105, "NullPointerException should have been thrown for 'SimpleQueryExpression(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("SimpleQueryExpression(String, null, QueryCollator) threw exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101105, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        if (!simple.getAttributeName().equals("stringValue")) {
            throw new TCKTestFailureException(11101107, "getAttributeName() returned wrong value: '" + simple.getAttributeName() + "'. Expected 'stringValue'.");
        }
        this.getLog().fine("getAttributeName() worked fine.");
        if (!simple.getAttributeValue().equals("42")) {
            throw new TCKTestFailureException(11101109, "getAttributeValue() returned wrong value: '" + simple.getAttributeValue() + "'. Expected '42'.");
        }
        this.getLog().fine("getAttributeValue() worked fine.");
        if (simple.getCollator() == null || !simple.getCollator().equals((Object)collator) || simpleNullCollator.getCollator() != null) {
            throw new TCKTestFailureException(11101111, "getCollator() returned unexpected values. simple.getCollator():" + simple.getCollator() + ". simpleNullCollator.getCollator():" + simpleNullCollator.getCollator());
        }
        this.getLog().fine("getCollator() worked fine.");
    }

    private void testOrderedQueryExpression() throws Exception {
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            MyOrderedQueryExpression ordered = new MyOrderedQueryExpression("stringValue", "42", collator);
            this.getLog().fine("OrderedQueryExpression(String, Object, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101041, "OrderedQueryExpression(String, Object, QueryCollator) threw exception.", e);
        }
        try {
            new MyOrderedQueryExpression("stringValue", "42", null);
            this.getLog().fine("OrderedQueryExpression(String, Object, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101041, "OrderedQueryExpression(String, Object, null) threw exception.", e);
        }
        try {
            new MyOrderedQueryExpression(null, "42", collator);
            throw new TCKTestFailureException(11101042, "NullPointerException should have been thrown for 'OrderedQueryExpression(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("OrderedQueryExpression(null, String, QueryCollator) threw exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101042, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new MyOrderedQueryExpression("stringValue", null, collator);
            throw new TCKTestFailureException(11101042, "NullPointerException should have been thrown for 'OrderedQueryExpression(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("OrderedQueryExpression(String, null, QueryCollator) threw exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101042, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new MyOrderedQueryExpression("myIntValue", new MyInteger(42), collator);
            throw new TCKTestFailureException(11101043, "IllegalArgumentException should have been thrown for 'OrderedQueryExpression(String, MyInteger, QueryCollator)'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("OrderedQueryExpression(String, MyInteger, QueryCollator) threw exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101043, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalArgumentException", e);
        }
    }

    private void testCompositeQuery() throws Exception {
        MyCompositeQueryExpression composite;
        Equals ex1 = new Equals("stringValue", (Object)"42");
        Equals ex2 = new Equals("intValue", (Object)new Integer(42));
        Equals ex3 = new Equals("boolValue", (Object)new Boolean(true));
        try {
            composite = new MyCompositeQueryExpression();
            this.getLog().fine("CompositeQueryExpression() worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110928, "CompositeQueryExpression() threw exception.", e);
        }
        try {
            composite.add2((QueryExpression)ex1);
            composite.add2((QueryExpression)ex2);
            composite.add2((QueryExpression)ex3);
            this.getLog().fine("add(QueryExpression) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110930, "add(QueryExpression) threw exception.", e);
        }
        try {
            composite.add2(null);
            throw new TCKTestFailureException(1110931, "NullPointerException should have been thrown for 'CompositeQueryExpression.add(null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("add(null) threw exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110931, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            composite.add2((QueryExpression)new Not((QueryExpression)composite));
            throw new TCKTestFailureException(1110932, "IllegalArgumentException should have been thrown when creating cyclic expression via CompositeQuery.add()");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110932, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalArgumentException");
        }
        try {
            QueryExpression[] expr = composite.getExpressions();
            if (expr.length != 3 || expr[0] != ex1 && expr[0] != ex2 && expr[0] != ex3 || expr[1] != ex1 && expr[1] != ex2 && expr[1] != ex3 || expr[2] != ex1 && expr[2] != ex2 && expr[2] != ex3) {
                throw new TCKTestFailureException(1110934, "'CompositeQuery.getExpressions()' did not return the full range of nested queries.");
            }
            this.getLog().fine("CompositeQuery.getExpressions worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110934, "'CompositeQuery.getExpressions()' threw exception: ", e);
        }
    }

    private void testRangeMatch() throws Exception {
        RangeMatch rM;
        try {
            rM = new RangeMatch("intValue", (Object)new Integer(23), (Object)new Integer(42));
            this.getLog().fine("RangeMatch(String, Object, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101086, "RangeMatch(String, Object, Object) threw exception.", e);
        }
        try {
            new RangeMatch("stringValue", null, (Object)"42");
            throw new TCKTestFailureException(11101087, "NullPointerException should have been thrown for 'RangeMatch(String, null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101087, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new RangeMatch("stringValue", (Object)"23", null);
            throw new TCKTestFailureException(11101087, "NullPointerException should have been thrown for 'RangeMatch(String, Object, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101087, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new RangeMatch(null, (Object)"23", (Object)"42");
            throw new TCKTestFailureException(11101087, "NullPointerException should have been thrown for 'RangeMatch(null, Object, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101087, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new RangeMatch("myIntValue", (Object)new Integer(23), (Object)new MyInteger(42));
            throw new TCKTestFailureException(11101088, "IllegalArgumentException should have been thrown for 'RangeMatch(\"myIntValue\", Integer, new MyInteger(42))'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101088, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new RangeMatch("myIntValue", (Object)new MyInteger(23), (Object)new Integer(42));
            throw new TCKTestFailureException(11101088, "IllegalArgumentException should have been thrown for 'RangeMatch(\"myIntValue\", new MyInteger(42), Integer)'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101088, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            rM = new RangeMatch("stringValue", "23", "42", collator);
            this.getLog().fine("RangeMatch(String, String, String, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101090, "RangeMatch(String, String, sTring, QueryCollator) threw exception.", e);
        }
        try {
            rM = new RangeMatch("stringValue", "23", "42", null);
            this.getLog().fine("RangeMatch(String, String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101090, "RangeMatch(String, String, String, null) threw exception.", e);
        }
        try {
            new RangeMatch("stringValue", null, "42", collator);
            throw new TCKTestFailureException(11101091, "NullPointerException should have been thrown for 'RangeMatch(String, null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101091, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new RangeMatch("stringValue", "23", null, collator);
            throw new TCKTestFailureException(11101091, "NullPointerException should have been thrown for 'RangeMatch(String, String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101091, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new RangeMatch(null, "23", "42", collator);
            throw new TCKTestFailureException(11101091, "NullPointerException should have been thrown for 'RangeMatch(null, String, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101091, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        if (!rM.getAttributeName().equals("stringValue")) {
            throw new TCKTestFailureException(11101094, "RangeMatch.getAttributeName() did not return the expected attribute name 'stringValue' but returned: " + rM.getAttributeName());
        }
        this.getLog().fine("RangeMatch.getAttributeName() worked fine.");
        Object value = rM.getFromValue();
        if (!(value instanceof String) || !"23".equals(value)) {
            throw new TCKTestFailureException(11101096, "RangeMatch.getFromValue() did not return the expected value '23' but returned: " + value);
        }
        this.getLog().fine("RangeMatch.getFromValue() returned the expected value.");
        value = rM.getToValue();
        if (!(value instanceof String) || !"42".equals(value)) {
            throw new TCKTestFailureException(11101098, "RangeMatch.getToValue() did not return the expected value '42' but returned: " + value);
        }
        this.getLog().fine("RangeMatch.getToValue() returned the expected value.");
    }

    private void testLongestPrefixMatch() throws Exception {
        LongestPrefixMatch lPM;
        try {
            lPM = new LongestPrefixMatch("stringValue", "42");
            this.getLog().fine("LongestPrefixMatch(String, String) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101001, "LongestPrefixMatch(String, String) threw exception.", e);
        }
        try {
            new LongestPrefixMatch("stringValue", null);
            throw new TCKTestFailureException(11101002, "NullPointerException should have been thrown for 'LongestPrefixMatch(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101002, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LongestPrefixMatch(null, "42");
            throw new TCKTestFailureException(11101002, "NullPointerException should have been thrown for 'LongestPrefixMatch(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101002, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            lPM = new LongestPrefixMatch("stringValue", "42", collator);
            this.getLog().fine("LongestPrefixMatch(String, String, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101004, "LongestPrefixMatch(String, String, Collator) threw exception.", e);
        }
        try {
            lPM = new LongestPrefixMatch("stringValue", "42", null);
            this.getLog().fine("LongestPrefixMatch(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101004, "LongestPrefixMatch(String, String, null) threw exception.", e);
        }
        try {
            new LongestPrefixMatch("stringValue", null, collator);
            throw new TCKTestFailureException(11101005, "NullPointerException should have been thrown for 'LongestPrefixMatch(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101005, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LongestPrefixMatch(null, "42", collator);
            throw new TCKTestFailureException(11101005, "NullPointerException should have been thrown for 'LongestPrefixMatch(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101005, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testHasPrefix() throws Exception {
        HasPrefix hP;
        try {
            hP = new HasPrefix("stringValue", "42");
            this.getLog().fine("HasPrefix(String, String) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110969, "HasPrefix(String, String) threw exception.", e);
        }
        try {
            new HasPrefix("stringValue", null);
            throw new TCKTestFailureException(1110970, "NullPointerException should have been thrown for 'HasPrefix(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110970, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new HasPrefix(null, "42");
            throw new TCKTestFailureException(1110970, "NullPointerException should have been thrown for 'HasPrefix(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110970, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            hP = new HasPrefix("stringValue", "42", collator);
            this.getLog().fine("HasPrefix(String, String, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110972, "HasPrefix(String, String, Collator) threw exception.", e);
        }
        try {
            hP = new HasPrefix("stringValue", "42", null);
            this.getLog().fine("HasPrefix(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110972, "HasPrefix(String, String, null) threw exception.", e);
        }
        try {
            new HasPrefix("stringValue", null, collator);
            throw new TCKTestFailureException(1110973, "NullPointerException should have been thrown for 'HasPrefix(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110973, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new HasPrefix(null, "42", collator);
            throw new TCKTestFailureException(1110973, "NullPointerException should have been thrown for 'HasPrefix(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110973, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testLessThanOrEquals() throws Exception {
        LessThanOrEquals lT;
        try {
            lT = new LessThanOrEquals("intValue", (Object)new Integer(42));
            this.getLog().fine("LessThanOrEquals(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110990, "LessThanOrEquals(String, Object) threw exception.", e);
        }
        try {
            new LessThanOrEquals("stringValue", null);
            throw new TCKTestFailureException(1110991, "NullPointerException should have been thrown for 'LessThanOrEquals(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110991, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LessThanOrEquals(null, (Object)"42");
            throw new TCKTestFailureException(1110991, "NullPointerException should have been thrown for 'LessThanOrEquals(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110991, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LessThanOrEquals("myIntValue", (Object)new MyInteger(42));
            throw new TCKTestFailureException(1110992, "IllegalArgumentException should have been thrown for 'LessThanOrEquals(\"myIntValue\", new MyInteger(42))'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110992, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            lT = new LessThanOrEquals("stringValue", "42", collator);
            this.getLog().fine("LessThanOrEquals(String, String, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110994, "LessThanOrEquals(String, String, QueryCollator) threw exception.", e);
        }
        try {
            lT = new LessThanOrEquals("stringValue", "42", null);
            this.getLog().fine("LessThanOrEquals(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110994, "LessThanOrEquals(String, String, null) threw exception.", e);
        }
        try {
            new LessThanOrEquals("stringValue", null, collator);
            throw new TCKTestFailureException(1110995, "NullPointerException should have been thrown for 'LessThanOrEquals(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110995, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LessThanOrEquals(null, "42", collator);
            throw new TCKTestFailureException(1110995, "NullPointerException should have been thrown for 'LessThanOrEquals(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110995, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testLessThan() throws Exception {
        LessThan lT;
        try {
            lT = new LessThan("intValue", (Object)new Integer(42));
            this.getLog().fine("LessThan(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110979, "LessThan(String, Object) threw exception.", e);
        }
        try {
            new LessThan("stringValue", null);
            throw new TCKTestFailureException(1110980, "NullPointerException should have been thrown for 'LessThan(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110980, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LessThan(null, (Object)"42");
            throw new TCKTestFailureException(1110980, "NullPointerException should have been thrown for 'LessThan(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110980, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LessThan("myIntValue", (Object)new MyInteger(42));
            throw new TCKTestFailureException(1110981, "IllegalArgumentException should have been thrown for 'LessThan(\"myIntValue\", new MyInteger(42))'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110981, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            lT = new LessThan("stringValue", "42", collator);
            this.getLog().fine("LessThan(String, String, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110983, "LessThan(String, String, QueryCollator) threw exception.", e);
        }
        try {
            lT = new LessThan("stringValue", "42", null);
            this.getLog().fine("LessThan(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110983, "LessThan(String, String, null) threw exception.", e);
        }
        try {
            new LessThan("stringValue", null, collator);
            throw new TCKTestFailureException(1110984, "NullPointerException should have been thrown for 'LessThan(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110984, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new LessThan(null, "42", collator);
            throw new TCKTestFailureException(1110984, "NullPointerException should have been thrown for 'LessThan(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110984, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testGreaterThanOrEquals() throws Exception {
        GreaterThanOrEquals gT;
        try {
            gT = new GreaterThanOrEquals("intValue", (Object)new Integer(42));
            this.getLog().fine("GreaterThanOrEquals(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110958, "GreaterThanOrEquals(String, Object) threw exception.", e);
        }
        try {
            new GreaterThanOrEquals("stringValue", null);
            throw new TCKTestFailureException(1110959, "NullPointerException should have been thrown for 'GreaterThanOrEquals(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110959, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new GreaterThanOrEquals(null, (Object)"42");
            throw new TCKTestFailureException(1110959, "NullPointerException should have been thrown for 'GreaterThanOrEquals(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110959, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new GreaterThanOrEquals("myIntValue", (Object)new MyInteger(42));
            throw new TCKTestFailureException(1110960, "IllegalArgumentException should have been thrown for 'GreaterThanOrEquals(\"myIntValue\", new MyInteger(42))'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110960, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            gT = new GreaterThanOrEquals("stringValue", "42", collator);
            this.getLog().fine("GreaterThanOrEquals(String, String, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110962, "GreaterThanOrEquals(String, String, QueryCollator) threw exception.", e);
        }
        try {
            gT = new GreaterThanOrEquals("stringValue", "42", null);
            this.getLog().fine("GreaterThanOrEquals(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110962, "GreaterThanOrEquals(String, String, null) threw exception.", e);
        }
        try {
            new GreaterThanOrEquals("stringValue", null, collator);
            throw new TCKTestFailureException(1110963, "NullPointerException should have been thrown for 'GreaterThanOrEquals(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110963, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new GreaterThanOrEquals(null, "42", collator);
            throw new TCKTestFailureException(1110963, "NullPointerException should have been thrown for 'GreaterThanOrEquals(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110963, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testGreaterThan() throws Exception {
        GreaterThan gT;
        try {
            gT = new GreaterThan("intValue", (Object)new Integer(42));
            this.getLog().fine("GreaterThan(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110947, "GreaterThan(String, Object) threw exception.", e);
        }
        try {
            new GreaterThan("stringValue", null);
            throw new TCKTestFailureException(1110948, "NullPointerException should have been thrown for 'GreaterThan(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110948, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new GreaterThan(null, (Object)"42");
            throw new TCKTestFailureException(1110948, "NullPointerException should have been thrown for 'GreaterThan(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110948, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new GreaterThan("myIntValue", (Object)new MyInteger(42));
            throw new TCKTestFailureException(1110949, "IllegalArgumentException should have been thrown for 'GreaterThan(\"myIntValue\", new MyInteger(42))'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110949, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            gT = new GreaterThan("stringValue", "42", collator);
            this.getLog().fine("GreaterThan(String, String, QueryCollator) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110951, "GreaterThan(String, String, QueryCollator) threw exception.", e);
        }
        try {
            gT = new GreaterThan("stringValue", "42", null);
            this.getLog().fine("GreaterThan(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110951, "GreaterThan(String, String, null) threw exception.", e);
        }
        try {
            new GreaterThan("stringValue", null, collator);
            throw new TCKTestFailureException(1110952, "NullPointerException should have been thrown for 'GreaterThan(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110952, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new GreaterThan(null, "42", collator);
            throw new TCKTestFailureException(1110952, "NullPointerException should have been thrown for 'GreaterThan(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110952, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testEquals() throws Exception {
        Equals equals;
        try {
            equals = new Equals("intValue", (Object)new Integer(42));
            this.getLog().fine("Equals(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110937, "Equals(String, Object) threw exception.", e);
        }
        try {
            new Equals("stringValue", null);
            throw new TCKTestFailureException(1110938, "NullPointerException should have been thrown for 'Equals(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110938, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new Equals(null, (Object)"42");
            throw new TCKTestFailureException(1110938, "NullPointerException should have been thrown for 'Equals(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110938, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            equals = new Equals("stringValue", "42", collator);
            this.getLog().fine("Equals(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110940, "Equals(String, String, Collator) threw exception.", e);
        }
        try {
            equals = new Equals("stringValue", "42", null);
            this.getLog().fine("Equals(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110940, "Equals(String, Object, null) threw exception.", e);
        }
        try {
            new Equals("stringValue", null, collator);
            throw new TCKTestFailureException(1110941, "NullPointerException should have been thrown for 'Equals(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110941, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new Equals(null, "42", collator);
            throw new TCKTestFailureException(1110941, "NullPointerException should have been thrown for 'Equals(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110941, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testNotEquals() throws Exception {
        NotEquals notEquals;
        try {
            notEquals = new NotEquals("intValue", (Object)new Integer(42));
            this.getLog().fine("NotEquals(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101018, "NotEquals(String, Object) threw exception.", e);
        }
        try {
            new NotEquals("stringValue", null);
            throw new TCKTestFailureException(11101019, "NullPointerException should have been thrown for 'NotEquals(String, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101019, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new NotEquals(null, (Object)"42");
            throw new TCKTestFailureException(11101019, "NullPointerException should have been thrown for 'NotEquals(null, Object)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101019, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        QueryCollator collator = new QueryCollator(new Locale("en", "NZ"));
        try {
            notEquals = new NotEquals("stringValue", "42", collator);
            this.getLog().fine("NotEquals(String, Object) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101021, "NotEquals(String, String, Collator) threw exception.", e);
        }
        try {
            notEquals = new NotEquals("stringValue", "42", null);
            this.getLog().fine("NotEquals(String, String, null) worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101021, "NotEquals(String, Object, null) threw exception.", e);
        }
        try {
            new NotEquals("stringValue", null, collator);
            throw new TCKTestFailureException(11101022, "NullPointerException should have been thrown for 'NotEquals(String, null, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101022, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new NotEquals(null, "42", collator);
            throw new TCKTestFailureException(11101022, "NullPointerException should have been thrown for 'NotEquals(null, String, QueryCollator)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101022, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
    }

    private void testAnd() throws TCKTestFailureException {
        And and;
        Equals ex1 = new Equals("stringValue", (Object)"42");
        Equals ex2 = new Equals("intValue", (Object)new Integer(42));
        Equals ex3 = new Equals("byteValue", (Object)new Byte("42"));
        try {
            and = new And((QueryExpression)ex1, (QueryExpression)ex2);
            this.getLog().fine("'And(QueryExpression, QueryExpression)' works as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110915, "Exception when using 'And(QueryExpression, QueryExpression)': ", e);
        }
        try {
            new And((QueryExpression)ex1, null);
            throw new TCKTestFailureException(1110916, "NullPointerException should have been thrown for 'And(equals1, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110916, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new And(null, (QueryExpression)ex2);
            throw new TCKTestFailureException(1110916, "NullPointerException should have been thrown for 'And(null, equals2)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110916, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new And(new QueryExpression[]{ex1, ex2, ex3});
            this.getLog().fine("'And(QueryExpression[])' works as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110918, "Exception when using 'And(QueryExpression[])': ", e);
        }
        try {
            new And(null);
            throw new TCKTestFailureException(1110919, "NullPointerException should have been thrown for 'And(null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110919, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException");
        }
        try {
            new And(new QueryExpression[]{ex1, ex2, null});
            throw new TCKTestFailureException(1110919, "NullPointerException should have been thrown for 'And(null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110919, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException");
        }
        try {
            new And(new QueryExpression[]{ex1});
            throw new TCKTestFailureException(1110915, "IllegalArgumentException should have been thrown for 'And(QueryExpression[]{ex1})'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110915, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalArgumentException");
        }
        try {
            if (and.and((QueryExpression)ex3) != and) {
                throw new TCKTestFailureException(1110922, "and(QueryExpression) should return reference to this.");
            }
            this.getLog().fine("and(QueryExpression) returned reference to 'this' as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110921, "and(QueryExpression) caused exception: ", e);
        }
        try {
            and.and(null);
            throw new TCKTestFailureException(1110923, "NullPointerException should have been thrown for 'And.and(null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110923, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException");
        }
        try {
            and.and((QueryExpression)new Not((QueryExpression)and));
            throw new TCKTestFailureException(1110924, "IllegalArgumentException should have been thrown when creating cyclic expression via And.and()");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110924, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalArgumentException");
        }
        try {
            And composite = and;
            this.getLog().fine("Instance of 'And' successfully class-casted into 'CompositeQueryExpression'.");
        }
        catch (ClassCastException e) {
            throw new TCKTestFailureException(0x10F1F1, "Unexpected class cast exception when casting instance of 'And' into 'CompositeQueryExpression': " + e);
        }
    }

    private void testOr() throws TCKTestFailureException {
        Or or;
        Equals ex1 = new Equals("stringValue", (Object)"42");
        Equals ex2 = new Equals("intValue", (Object)new Integer(42));
        Equals ex3 = new Equals("byteValue", (Object)new Byte("42"));
        try {
            or = new Or((QueryExpression)ex1, (QueryExpression)ex2);
            this.getLog().fine("'Or(QueryExpression, QueryExpression)' works as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101027, "Exception when using 'Or(QueryExpression, QueryExpression)': ", e);
        }
        try {
            new Or((QueryExpression)ex1, null);
            throw new TCKTestFailureException(11101028, "NullPointerException should have been thrown for 'Or(equals1, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101028, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new Or(null, (QueryExpression)ex2);
            throw new TCKTestFailureException(11101028, "NullPointerException should have been thrown for 'Or(null, equals2)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101028, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            new Or(new QueryExpression[]{ex1, ex2, ex3});
            this.getLog().fine("'Or(QueryExpression[])' works as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101030, "Exception when using 'Or(QueryExpression[])': ", e);
        }
        try {
            new Or(null);
            throw new TCKTestFailureException(11101031, "NullPointerException should have been thrown for 'Or(null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101031, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException");
        }
        try {
            new Or(new QueryExpression[]{ex1, ex2, null});
            throw new TCKTestFailureException(11101031, "NullPointerException should have been thrown for 'Or(null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101031, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException");
        }
        try {
            new Or(new QueryExpression[]{ex1});
            throw new TCKTestFailureException(1110915, "IllegalArgumentException should have been thrown for 'Or(QueryExpression[]{ex1})'");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(1110915, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalArgumentException");
        }
        try {
            if (or.or((QueryExpression)ex3) != or) {
                throw new TCKTestFailureException(11101034, "or(QueryExpression) should return reference to this.");
            }
            this.getLog().fine("and(QueryExpression) returned reference to 'this' as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101033, "or(QueryExpression) caused exception: ", e);
        }
        try {
            or.or(null);
            throw new TCKTestFailureException(11101035, "NullPointerException should have been thrown for 'Or.or(null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101035, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException");
        }
        try {
            or.or((QueryExpression)new Not((QueryExpression)or));
            throw new TCKTestFailureException(11101036, "IllegalArgumentException should have been thrown when creating cyclic expression via Or.or()");
        }
        catch (IllegalArgumentException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101036, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalArgumentException");
        }
        try {
            or.toString();
            this.getLog().fine("'Or.toString()' works as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(1110915, "'Or.toString()' failed", e);
        }
        try {
            Or composite = or;
            this.getLog().fine("Instance of 'Or' successfully class-casted into 'CompositeQueryExpression'.");
        }
        catch (ClassCastException e) {
            throw new TCKTestFailureException(1110520, "Unexpected class cast exception when casting instance of 'Or' into 'CompositeQueryExpression': " + e);
        }
    }

    private void testNot() throws TCKTestFailureException {
        Not not;
        Equals ex = new Equals("intValue", (Object)new Integer(42));
        try {
            not = new Not((QueryExpression)ex);
            this.getLog().fine("'Not(QueryExpression)' works as expected.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101010, "Exception when using 'Not(QueryExpression)': ", e);
        }
        try {
            new Not(null);
            throw new TCKTestFailureException(11101011, "NullPointerException should have been thrown for 'Not(equals1, null)'");
        }
        catch (NullPointerException e) {
            this.getLog().fine("Caught exception as expected: " + e);
        }
        catch (Exception e) {
            if (e instanceof TCKTestFailureException) {
                throw (TCKTestFailureException)e;
            }
            throw new TCKTestFailureException(11101011, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.NullPointerException", e);
        }
        try {
            QueryExpression expr = not.getExpression();
            if (expr != ex) {
                throw new TCKTestFailureException(11101013, "'Not.getExpression()' did not return the nested query.");
            }
            this.getLog().fine("Not.getExpression() worked fine.");
        }
        catch (Exception e) {
            throw new TCKTestFailureException(11101013, "'Not.getExpression()' threw exception: ", e);
        }
        try {
            Not composite = not;
            this.getLog().fine("Instance of 'Not' successfully class-casted into 'QueryExpression'.");
        }
        catch (ClassCastException e) {
            throw new TCKTestFailureException(0x10F1FF, "Unexpected class cast exception when casting instance of 'Not' into 'QueryExpression': " + e);
        }
    }

    public void setUp() throws Exception {
        this.setupService(SERVICE_DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private class MyCompositeQueryExpression
    extends CompositeQueryExpression {
        protected void toString(StringBuffer arg0) {
        }

        public void add2(QueryExpression expr) {
            this.add(expr);
        }
    }

    private class MyOrderedQueryExpression
    extends OrderedQueryExpression {
        public MyOrderedQueryExpression(String attrName, Object attrValue, QueryCollator collator) {
            super(attrName, attrValue, collator);
        }

        protected String getRelation() {
            return "myOrderedQueryExpression";
        }
    }

    private class MySimpleQueryExpression
    extends SimpleQueryExpression {
        public MySimpleQueryExpression(String attrName, Object attrValue, QueryCollator collator) {
            super(attrName, attrValue, collator);
        }

        public String getRelation() {
            return "MySimpleQueryExpression";
        }
    }
}

