/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileID;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class Test4432Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        ProfileID firstProfile = new ProfileID("Test4432ProfileTable", "Test4432Profile");
        ProfileID secondProfile = new ProfileID("Test4432ProfileTable", "Test4432SecondProfile");
        Address address = firstProfile.toAddress();
        if (!address.getAddressPlan().isSleeProfile()) {
            return TCKTestResult.failed(4432, "ProfileID.toAddress() returned freaky address.");
        }
        if (firstProfile.equals((Object)secondProfile)) {
            return TCKTestResult.failed(4434, "ProfileID.equals(different ProfileID) returned true.");
        }
        if (!firstProfile.equals((Object)firstProfile)) {
            return TCKTestResult.failed(4434, "ProfileID.equals(self) returned false.");
        }
        try {
            firstProfile.hashCode();
        }
        catch (Exception e) {
            return TCKTestResult.failed(4436, "ProfileID.hashCode() threw an exception.");
        }
        try {
            firstProfile.toString();
        }
        catch (Exception e) {
            return TCKTestResult.failed(4438, "ProfileID.toString() threw an exception.");
        }
        if (firstProfile.toString() == null) {
            return TCKTestResult.failed(4438, "ProfileID.toString() returned null.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            profileProxy.createProfileTable(profileSpecID, "Test4432ProfileTable");
            ObjectName profile = profileProxy.createProfile("Test4432ProfileTable", "Test4432Profile");
            ProfileMBeanProxy profProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            profile = profileProxy.createProfile("Test4432ProfileTable", "Test4432SecondProfile");
            profProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
        }
    }

    public void tearDown() throws Exception {
        ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        try {
            profileProxy.removeProfile("Test4432ProfileTable", "Test4432Profile");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            profileProxy.removeProfile("Test4432ProfileTable", "Test4432SecondProfile");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            profileProxy.removeProfileTable("Test4432ProfileTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

