/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileID;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110011Test
extends AbstractSleeTCKTest {
    private static final String DU_PATH_PARAM = "DUPath";
    public static final String PROFILE_TABLE_NAME = "Test1110011ProfileTable";
    public static final String PROFILE_TABLE_NAME2 = "Test1110011ProfileTable2";
    public static final String PROFILE_NAME = "Test1110011Profile";
    public static final String PROFILE_NAME2 = "Test1110011Profile2";
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        Logable log = this.getLog();
        ProfileID profileID = null;
        try {
            profileID = new ProfileID(new Address(AddressPlan.SLEE_PROFILE, "Test1110011ProfileTable/Test1110011Profile"));
            log.fine("Created a ProfileID with one-args constructor and valid profile table name");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4471, "Caught exception when creating ProfileID with one-args constructor and valid table name: " + e);
        }
        try {
            new ProfileID(null);
            return TCKTestResult.failed(4422, "Did not get NullPointerException when constructor's 'address' parameter set to 'null'.");
        }
        catch (NullPointerException e) {
            log.fine("NullPointerException correctly thrown by one-args constructor when 'address' parameter set to 'null'.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4422, "Received incorrect exception creating a ProfileID with constructor's 'address' parameter set to 'null', expected NullPointerException. " + e);
        }
        try {
            new ProfileID(new Address(AddressPlan.AESA, "Test1110011ProfileTable/Test1110011Profile"));
            return TCKTestResult.failed(4610, "IllegalArgumentException should have been thrown when using one-args constructor with address plan not 'AddressPlan.SLEE_PROFILE'");
        }
        catch (IllegalArgumentException e) {
            log.fine("IllegalArgumentException correctly thrown by one-args constructor if address plan is not 'AddressPlan.SLEE_PROFILE'");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4610, "Wrong type of exception thrown, expected IllegalArgumentException but caught: " + e);
        }
        try {
            new ProfileID(new Address(AddressPlan.SLEE_PROFILE, "Test1110011ProfileTableTest1110011Profile"));
            return TCKTestResult.failed(4610, "IllegalArgumentException should have been thrown when using one-args constructor without the correct <profile-table-name>/<profile-name> encoding.");
        }
        catch (IllegalArgumentException e) {
            log.fine("IllegalArgumentException correctly thrown by one-args constructor when not using the correct <profile-table-name>/<profile-name> encoding.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4610, "Wrong type of exception thrown, expected IllegalArgumentException but caught: " + e);
        }
        Assert.assertEquals(4425, "Profile table name returned by 'getProfileTableName' is incorrect.", PROFILE_TABLE_NAME, profileID.getProfileTableName());
        log.fine("Profile table name returned by 'getProfileTableName' is correct.");
        Assert.assertEquals(4427, "Profile name returned by 'getProfileName' is incorrect.", PROFILE_NAME, profileID.getProfileName());
        log.fine("Profile name returned by 'getProfileName' is correct.");
        try {
            profileID.setProfileID(PROFILE_TABLE_NAME2, PROFILE_NAME2);
            log.fine("Pointing profileID to different profile via setProfileID() worked fine.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4470, "Received exception when trying to use setProfileID() with valid parameters: " + e);
        }
        try {
            profileID.setProfileID(null, "lala");
            return TCKTestResult.failed(4429, "No exception thrown when calling setProfileID with a 'null' parameter.");
        }
        catch (NullPointerException e) {
            log.fine("NullPointerException correctly thrown by setProfileID() when ProfileTableName parameter set to 'null'.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4429, "Received incorrect exception creating a ProfileID with parameter set to 'null', expected NullPointerException but received: " + e);
        }
        try {
            profileID.setProfileID("lala", null);
            return TCKTestResult.failed(4429, "No exception thrown when calling setProfileID with a 'null' parameter.");
        }
        catch (NullPointerException e) {
            log.fine("NullPointerException correctly thrown by setProfileID() when ProfileName parameter set to 'null'.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4429, "Received incorrect exception creating a ProfileID with parameter set to 'null', expected NullPointerException but received: " + e);
        }
        try {
            profileID.setProfileID("A/A", "A");
            return TCKTestResult.failed(4611, "Creation of ProfileID with invalid name should produce IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            log.fine("Caught IllegalArgumentException creating ProfileID with '/' in table name");
        }
        catch (Exception e) {
            return TCKTestResult.failed(4611, "Received incorrect exception creating a ProfileID with invalid table name, expected IllegalArgumentException but received: " + e);
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        DeployableUnitID duID = this.setupService(DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            this.profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
            ObjectName profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profileProxy.commitProfile();
            profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME2);
            profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profileProxy.commitProfile();
            this.profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME2);
            profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME2, PROFILE_NAME);
            profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profileProxy.commitProfile();
            profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME2, PROFILE_NAME2);
            profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profileProxy.commitProfile();
        }
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile tables:");
            this.getLog().warning(e);
        }
        try {
            this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME2);
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile tables:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

