/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.TraceNotification;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.TraceNotification;

public class Test4185Test
implements SleeTCKTest,
NotificationListener {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 4185;
    private SleeTCKTestUtils utils;
    private FutureResult result;
    private DeployableUnitID duID;
    private TraceNotification firstNotification;
    private SbbID sbbID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test4185InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 4185);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Installing and activating service");
        TraceMBeanProxy traceMBeanProxy = this.utils.getMBeanProxyFactory().createTraceMBeanProxy(this.utils.getSleeManagementMBeanProxy().getTraceMBean());
        traceMBeanProxy.addNotificationListener(this, null, null);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof SbbID)) continue;
            this.utils.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    public synchronized void handleNotification(Notification notification, Object handback) {
        if (notification instanceof TraceNotification) {
            TraceNotification traceNotification = (TraceNotification)notification;
            if (traceNotification.getType() != null && traceNotification.getType().equals("javax.slee.management.trace.raentity")) {
                return;
            }
            if (this.firstNotification == null) {
                this.firstNotification = traceNotification;
                return;
            }
            if (traceNotification.getCause() != null) {
                this.result.setFailed(4191, "TraceNotification.getCause() returned non-null for a notification with no cause.");
                return;
            }
            if (!traceNotification.getMessageType().equals("javax.slee.management.trace")) {
                this.result.setFailed(4185, "TraceNotification.getMessageType() returned incorrect message type.");
                return;
            }
            if (!traceNotification.getMessageSource().equals(this.sbbID)) {
                this.result.setFailed(4187, "TraceNotification.getMessageSource() returned incorrect message source.");
                return;
            }
            if (traceNotification.equals((Object)this.firstNotification)) {
                this.result.setFailed(4193, "TraceNotification.equals(TraceNotification) returned true for non-matching TraceNotification objects.");
                return;
            }
            if (!traceNotification.equals((Object)traceNotification)) {
                this.result.setFailed(4193, "TraceNotification.equals(TraceNotification) returned false for matching TraceNotification objects.");
                return;
            }
            try {
                traceNotification.hashCode();
            }
            catch (Exception e) {
                this.result.setFailed(4195, "TraceNotification.hashCode() threw an exception.");
                return;
            }
            try {
                traceNotification.toString();
            }
            catch (Exception e) {
                this.result.setFailed(4197, "TraceNotification.toString() threw an exception.");
                return;
            }
            if (traceNotification.toString() == null) {
                this.result.setFailed(4197, "TraceNotification.toString() returned null.");
                return;
            }
            this.result.setPassed();
            return;
        }
    }
}

