/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.ServiceUsageMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanLookup;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanLookup;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import javax.slee.SbbID;

public class ResetParametersTest
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_1_PARAM = "serviceDUPath1";
    private static final String SERVICE_DU_PATH_2_PARAM = "serviceDUPath2";
    private static final String PARAMETER_SET_NAME = "NamedParameterSet";
    private QueuingResourceListener resourceListener;
    private QueuingNotificationListener notificationListener;
    private GenericUsageMBeanLookup usageMBeanLookupA;
    private GenericUsageMBeanLookup usageMBeanLookupB;
    private GenericUsageMBeanLookup usageMBeanLookupC;

    public TCKTestResult run() throws Exception {
        int i;
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("ResetParametersTest-Activity");
        GenericUsageSbbInstructions instructionsForNamed = new GenericUsageSbbInstructions(PARAMETER_SET_NAME);
        instructionsForNamed.addFirstCountIncrement(5L);
        instructionsForNamed.addTimeBetweenNewConnectionsSamples(10L);
        GenericUsageSbbInstructions instructionsForUnnamed = new GenericUsageSbbInstructions(null);
        instructionsForUnnamed.addFirstCountIncrement(6L);
        instructionsForUnnamed.addTimeBetweenNewConnectionsSamples(11L);
        GenericUsageSbbInstructions[] instructionSets = new GenericUsageSbbInstructions[]{instructionsForNamed, instructionsForUnnamed};
        this.getLog().fine("Sanity checking that we have zero/empty values for each parameter");
        GenericUsageMBeanLookup[] usageMBeanLookups = new GenericUsageMBeanLookup[]{this.usageMBeanLookupA, this.usageMBeanLookupB, this.usageMBeanLookupC};
        StringBuffer parametersBuf = new StringBuffer();
        for (i = 0; i < usageMBeanLookups.length; ++i) {
            if (!this.areAnyParametersNotReset(usageMBeanLookups[i], parametersBuf)) continue;
            return TCKTestResult.error("The following parameters had non-zero / non-empty values for the " + usageMBeanLookups[i].getSbbID() + " SBB, before any updates were made via the usage parameters interface: " + parametersBuf.toString());
        }
        this.getLog().info("Setting values in each SBB");
        this.sendInstructionsAndWait(activityID, instructionSets);
        this.getLog().fine("Checking for non-zero/non-empty values for each SBB");
        for (i = 0; i < usageMBeanLookups.length; ++i) {
            if (!this.areAnyParametersReset(usageMBeanLookups[i], parametersBuf)) continue;
            return TCKTestResult.error("The following parameters had zero / empty values for the " + usageMBeanLookups[i].getSbbID() + " SBB, after updates were made via the usage parameters interface: " + parametersBuf.toString());
        }
        this.getLog().info("Resetting values in SBB A only");
        SbbID sbbA = this.usageMBeanLookupA.getSbbID();
        this.usageMBeanLookupA.getServiceUsageMBeanProxy().resetAllUsageParameters(sbbA);
        this.getLog().info("Checking for zero/empty values in SBB A");
        if (this.areAnyParametersNotReset(this.usageMBeanLookupA, parametersBuf)) {
            return TCKTestResult.failed(4618, "The following parameters had non-zero / non-empty values for the " + sbbA + " SBB, after " + "resetAllUsageParameters(SbbID) was called with the id of the SBB: " + parametersBuf.toString());
        }
        this.getLog().info("Checking for non-zero/non-empty values for the other SBBs");
        if (this.areAnyParametersReset(this.usageMBeanLookupB, parametersBuf)) {
            return TCKTestResult.failed(4618, "The following parameters had their values reset for the " + this.usageMBeanLookupB.getSbbID() + " SBB, after " + "resetAllUsageParameters(SbbID) was called with the id of another SBB in the same service: " + parametersBuf.toString());
        }
        if (this.areAnyParametersReset(this.usageMBeanLookupC, parametersBuf)) {
            return TCKTestResult.failed(4618, "The following parameters had their values reset for the " + this.usageMBeanLookupC.getSbbID() + " SBB, after " + "resetAllUsageParameters(SbbID) was called with the id of an SBB in another service: " + parametersBuf.toString());
        }
        this.getLog().info("Setting values in each SBB");
        this.sendInstructionsAndWait(activityID, instructionSets);
        this.getLog().fine("Checking for non-zero/non-empty values for each SBB");
        for (int i2 = 0; i2 < usageMBeanLookups.length; ++i2) {
            if (!this.areAnyParametersReset(usageMBeanLookups[i2], parametersBuf)) continue;
            return TCKTestResult.error("The following parameters had zero / empty values for the " + usageMBeanLookups[i2].getSbbID() + " SBB, after updates were made via the usage parameters interface: " + parametersBuf.toString());
        }
        this.getLog().info("Resetting values the service containing A and B, but not C");
        this.usageMBeanLookupA.getServiceUsageMBeanProxy().resetAllUsageParameters();
        this.getLog().info("Checking for zero/empty values in SBB A and B");
        GenericUsageMBeanLookup[] usageMBeanLookupAndB = new GenericUsageMBeanLookup[]{this.usageMBeanLookupA, this.usageMBeanLookupB};
        for (int i3 = 0; i3 < usageMBeanLookupAndB.length; ++i3) {
            GenericUsageMBeanLookup usageMBeanLookup = usageMBeanLookupAndB[i3];
            if (!this.areAnyParametersNotReset(usageMBeanLookup, parametersBuf)) continue;
            return TCKTestResult.failed(4595, "The following parameters had non-zero / non-empty values for the " + usageMBeanLookup.getSbbID() + " SBB, " + "after resetAllUsageParameters() was called on the ServiceUsageMBean representing the service which " + "contained the SBB: " + parametersBuf.toString());
        }
        this.getLog().info("Checking for non-zero/non-empty values for the SBB in the other service");
        if (this.areAnyParametersReset(this.usageMBeanLookupC, parametersBuf)) {
            return TCKTestResult.failed(4595, "The following parameters had their values reset for the " + this.usageMBeanLookupC.getSbbID() + " SBB, after " + "resetAllUsageParameters() was called on a ServiceUsageMBean representing a service which " + "did not contain the SBB: " + parametersBuf.toString());
        }
        return TCKTestResult.passed();
    }

    private boolean areAnyParametersNotReset(GenericUsageMBeanLookup usageMBeanLookup, StringBuffer notResetParametersBuf) throws Exception {
        GenericUsageMBeanProxy usageMBeanProxyUnnamed = usageMBeanLookup.getUnnamedGenericUsageMBeanProxy();
        GenericUsageMBeanProxy usageMBeanProxyNamed = usageMBeanLookup.getNamedGenericSbbUsageMBeanProxy(PARAMETER_SET_NAME);
        long firstCountUnnamed = usageMBeanProxyUnnamed.getFirstCount(false);
        long timeBetweenNewConnectionsUnnamedCount = usageMBeanProxyUnnamed.getTimeBetweenNewConnections(false).getSampleCount();
        long firstCountNamed = usageMBeanProxyNamed.getFirstCount(false);
        long timeBetweenNewConnectionsNamedCount = usageMBeanProxyNamed.getTimeBetweenNewConnections(false).getSampleCount();
        if (firstCountNamed != 0L || firstCountUnnamed != 0L || timeBetweenNewConnectionsNamedCount != 0L || timeBetweenNewConnectionsUnnamedCount != 0L) {
            if (firstCountUnnamed != 0L) {
                notResetParametersBuf.append("(unnamed-parameter-set):firstCount=" + firstCountUnnamed + ";");
            }
            if (firstCountNamed != 0L) {
                notResetParametersBuf.append("NamedParameterSet:firstCount=" + firstCountNamed + ";");
            }
            if (timeBetweenNewConnectionsUnnamedCount != 0L) {
                notResetParametersBuf.append("(unnamed-parameter-set):timeBetweenNewConnections,sample count=" + timeBetweenNewConnectionsUnnamedCount + ";");
            }
            if (timeBetweenNewConnectionsNamedCount != 0L) {
                notResetParametersBuf.append("NamedParameterSet:timeBetweenNewConnections,sample count=" + timeBetweenNewConnectionsNamedCount + ";");
            }
            return true;
        }
        return false;
    }

    private boolean areAnyParametersReset(GenericUsageMBeanLookup usageMBeanLookup, StringBuffer notResetParametersBuf) throws Exception {
        GenericUsageMBeanProxy usageMBeanProxyUnnamed = usageMBeanLookup.getUnnamedGenericUsageMBeanProxy();
        GenericUsageMBeanProxy usageMBeanProxyNamed = usageMBeanLookup.getNamedGenericSbbUsageMBeanProxy(PARAMETER_SET_NAME);
        long firstCountUnnamed = usageMBeanProxyUnnamed.getFirstCount(false);
        long timeBetweenNewConnectionsUnnamedCount = usageMBeanProxyUnnamed.getTimeBetweenNewConnections(false).getSampleCount();
        long firstCountNamed = usageMBeanProxyNamed.getFirstCount(false);
        long timeBetweenNewConnectionsNamedCount = usageMBeanProxyNamed.getTimeBetweenNewConnections(false).getSampleCount();
        if (firstCountNamed == 0L || firstCountUnnamed == 0L || timeBetweenNewConnectionsNamedCount == 0L || timeBetweenNewConnectionsUnnamedCount == 0L) {
            if (firstCountUnnamed == 0L) {
                notResetParametersBuf.append("(unnamed-parameter-set):firstCount;");
            }
            if (firstCountNamed == 0L) {
                notResetParametersBuf.append("NamedParameterSet:firstCount;");
            }
            if (timeBetweenNewConnectionsUnnamedCount == 0L) {
                notResetParametersBuf.append("(unnamed-parameter-set):timeBetweenNewConnections;");
            }
            if (timeBetweenNewConnectionsNamedCount == 0L) {
                notResetParametersBuf.append("NamedParameterSet:timeBetweenNewConnections;");
            }
            return true;
        }
        return false;
    }

    private void sendInstructionsAndWait(TCKActivityID activityID, GenericUsageSbbInstructions[] instructionSets) throws Exception {
        for (int i = 0; i < instructionSets.length; ++i) {
            GenericUsageSbbInstructions instructionSet = instructionSets[i];
            this.getLog().fine("firing event to SBBs");
            this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instructionSet.toExported(), activityID, null);
            this.getLog().fine("waiting for replies");
            this.resourceListener.nextMessage();
            this.resourceListener.nextMessage();
            this.resourceListener.nextMessage();
            this.getLog().info("received replies");
            this.getLog().fine("waiting for usage notifications");
            for (int updateIndex = 0; updateIndex < instructionSet.getTotalUpdates() * 3; ++updateIndex) {
                this.notificationListener.nextNotification();
            }
            this.getLog().info("received all " + instructionSet.getTotalUpdates() * 3 + " usage notifications");
        }
    }

    public void setUp() throws Exception {
        this.setupService(SERVICE_DU_PATH_1_PARAM, true);
        this.setupService(SERVICE_DU_PATH_2_PARAM, true);
        this.resourceListener = new QueuingResourceListener(this.utils());
        this.setResourceListener(this.resourceListener);
        this.notificationListener = new QueuingNotificationListener(this.utils());
        this.usageMBeanLookupA = new GenericUsageMBeanLookup("ResetParametersTestService", "ResetParametersTestChildSbbA", this.utils());
        this.usageMBeanLookupB = new GenericUsageMBeanLookup("ResetParametersTestService", "ResetParametersTestChildSbbB", this.utils());
        this.usageMBeanLookupC = new GenericUsageMBeanLookup(this.utils());
        UsageMBeanLookup[] usageMBeanLookups = new UsageMBeanLookup[]{this.usageMBeanLookupA, this.usageMBeanLookupB, this.usageMBeanLookupC};
        for (int i = 0; i < usageMBeanLookups.length; ++i) {
            UsageMBeanLookup usageMBeanLookup = usageMBeanLookups[i];
            SbbID sbbID = usageMBeanLookup.getSbbID();
            usageMBeanLookup.getServiceUsageMBeanProxy().createUsageParameterSet(sbbID, PARAMETER_SET_NAME);
            usageMBeanLookup.getUnnamedSbbUsageMBeanProxy().addNotificationListener(this.notificationListener, null, null);
            usageMBeanLookup.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).addNotificationListener(this.notificationListener, null, null);
        }
    }

    public void tearDown() throws Exception {
        int i;
        UsageMBeanLookup[] usageMBeanLookups = new UsageMBeanLookup[]{this.usageMBeanLookupA, this.usageMBeanLookupB, this.usageMBeanLookupC};
        for (i = 0; i < usageMBeanLookups.length; ++i) {
            UsageMBeanLookup usageMBeanLookup = usageMBeanLookups[i];
            if (usageMBeanLookup == null) continue;
            usageMBeanLookup.getUnnamedSbbUsageMBeanProxy().removeNotificationListener(this.notificationListener);
            usageMBeanLookup.getNamedSbbUsageMBeanProxy(PARAMETER_SET_NAME).removeNotificationListener(this.notificationListener);
        }
        for (i = 0; i < usageMBeanLookups.length; ++i) {
            if (usageMBeanLookups[i] == null) continue;
            usageMBeanLookups[i].closeAllMBeans();
        }
        super.tearDown();
    }
}

