/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.AlarmMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AlarmMBeanProxyImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.Alarm;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.management.UnrecognizedNotificationSourceException;

public class Test1114768Test
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private ObjectName alarmMBeanName;
    private TCKTestResult result;
    private SbbID sbbID;
    private ServiceID serviceID;
    private SbbNotification sbbNotification;
    private int AlarmInstance;
    private String[] alarmIDs;
    private String alarmType;
    private boolean alarmsCreated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        String activityName = "Test1114768Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        Test1114768Test test1114768Test = this;
        synchronized (test1114768Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (!this.alarmsCreated) {
            TCKTestResult.error("Error: Alarm notification not received");
        }
        return this.result;
    }

    public void setUp() throws Exception {
        TCKTestResult.error("Test did not receive SBB notification");
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.alarmMBeanName = proxy.getAlarmMBean();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy = new AlarmMBeanProxyImpl(this.alarmMBeanName, this.utils().getMBeanFacade());
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    private TCKTestResult doAlarmMBeanCheck(AlarmMBeanProxy alarmMBeanProxy) {
        int numberCleared;
        boolean cleared;
        this.utils().getLog().fine("sbbNotification = " + this.sbbNotification.toString());
        this.utils().getLog().fine("Alarm Type for sbbNotification = " + this.alarmType);
        try {
            this.getLog().fine("1114775: Starting to get all existing unique alarm identifiers for stateful alarms ");
            this.alarmIDs = alarmMBeanProxy.getAlarms();
            this.utils().getLog().info("Number of Alarm IDs in SLEE = " + this.alarmIDs.length);
            if (this.alarmIDs.length <= 0) {
                return TCKTestResult.failed(1114775, "alarmMBeanProxy.getAlarms failed to return any Alarms");
            }
            this.logSuccessfulCheck(1114775);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114775, "alarmMBeanProxy.getAlarms failed");
        }
        try {
            String[] sbbAlarmIDs = alarmMBeanProxy.getAlarms((NotificationSource)this.sbbNotification);
            this.utils().getLog().fine("Number of Alarm IDs for sbbNotification = " + sbbAlarmIDs.length);
            if (sbbAlarmIDs.length < 3) {
                return TCKTestResult.failed(1114768, "alarmMBeanProxy.getAlarms(sbbNotification) failed to return any Alarms");
            }
            this.logSuccessfulCheck(1114768);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114768, "alarmMBeanProxy.getAlarms(sbbNotification) failed");
        }
        NotificationSource nullSbbNotification = null;
        try {
            String[] sbbAlarmIDs = alarmMBeanProxy.getAlarms(nullSbbNotification);
            return TCKTestResult.failed(1114769, "alarmMBeanProxy.getAlarms(null) failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114769);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114769, "alarmMBeanProxy.getAlarms(null) failed");
        }
        ServiceID badServiceID = new ServiceID("bad", "jain.slee.tck", "1.0");
        SbbID badSbbID = new SbbID("bad", "jain.slee.tck", "1.0");
        SbbNotification badSbbNotification1 = new SbbNotification(badServiceID, this.sbbID);
        SbbNotification badSbbNotification2 = new SbbNotification(this.serviceID, badSbbID);
        try {
            String[] sbbAlarmIDs = alarmMBeanProxy.getAlarms((NotificationSource)badSbbNotification1);
            return TCKTestResult.failed(1114981, "alarmMBeanProxy.getAlarms failed to throw UnrecognizedNotificationSourceException");
        }
        catch (UnrecognizedNotificationSourceException e) {
            try {
                String[] sbbAlarmIDs = alarmMBeanProxy.getAlarms((NotificationSource)badSbbNotification2);
                return TCKTestResult.failed(1114981, "alarmMBeanProxy.getAlarms failed to throw UnrecognizedNotificationSourceException");
            }
            catch (UnrecognizedNotificationSourceException e2) {
                this.logSuccessfulCheck(1114981);
            }
            catch (Exception e2) {
                this.getLog().warning(e2);
                return TCKTestResult.failed(1114981, "alarmMBeanProxy.getAlarms(badSbbNotification2) failed");
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114981, "alarmMBeanProxy.getAlarms(badSbbNotification1) failed");
        }
        try {
            Alarm alarm = alarmMBeanProxy.getDescriptor(this.alarmIDs[0]);
            this.logSuccessfulCheck(1114983);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114983, "alarmMBeanProxy.getDescriptor failed");
        }
        String nullAlarmID = null;
        try {
            Alarm alarm = alarmMBeanProxy.getDescriptor(nullAlarmID);
            return TCKTestResult.failed(1114984, "alarmMBeanProxy.getDescriptor(null) failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114984);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114984, "alarmMBeanProxy.getDescriptor(null) failed");
        }
        try {
            Alarm[] alarms = alarmMBeanProxy.getDescriptors(this.alarmIDs);
            if (alarms.length <= 0) {
                return TCKTestResult.failed(1114987, "alarmMBeanProxy.getDescriptors failed to return alarms");
            }
            this.logSuccessfulCheck(1114987);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114987, "alarmMBeanProxy.getDescriptors failed");
        }
        String[] nullAlarmIDs = null;
        try {
            Alarm[] alarms = alarmMBeanProxy.getDescriptors(nullAlarmIDs);
            return TCKTestResult.failed(1114988, "alarmMBeanProxy.getDescriptor(null) failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114988);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114988, "alarmMBeanProxy.getDescriptor(null) failed");
        }
        try {
            cleared = alarmMBeanProxy.clearAlarm(this.alarmIDs[0]);
            if (!cleared) {
                return TCKTestResult.failed(1114760, "alarmMBeanProxy.clearAlarm failed to clear Alarm");
            }
            this.logSuccessfulCheck(1114760);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114760, "alarmMBeanProxy.clearAlarm failed");
        }
        try {
            cleared = alarmMBeanProxy.clearAlarm(nullAlarmID);
            return TCKTestResult.failed(1114761, "alarmMBeanProxy.clearAlarms(null) failed");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114761);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114761, "alarmMBeanProxy.clearAlarms(null) failed");
        }
        try {
            String[] sbbAlarmIDs = alarmMBeanProxy.getAlarms((NotificationSource)this.sbbNotification);
            this.utils().getLog().fine("Number of Alarm IDs for sbbNotification = " + sbbAlarmIDs.length);
            this.utils().getLog().fine("Alarm Type for sbbNotification = " + this.alarmType);
            numberCleared = alarmMBeanProxy.clearAlarms((NotificationSource)this.sbbNotification, this.alarmType);
            if (numberCleared != 2) {
                return TCKTestResult.failed(1114772, "alarmMBeanProxy.clearAlarms failed to clear Alarm");
            }
            this.logSuccessfulCheck(1114772);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114772, "alarmMBeanProxy.clearAlarms failed");
        }
        String nullAlarmType = null;
        try {
            numberCleared = alarmMBeanProxy.clearAlarms(nullSbbNotification, this.alarmType);
            return TCKTestResult.failed(1114773, "alarmMBeanProxy.clearAlarms failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            try {
                int numberCleared2 = alarmMBeanProxy.clearAlarms((NotificationSource)this.sbbNotification, nullAlarmType);
                return TCKTestResult.failed(1114773, "alarmMBeanProxy.clearAlarms failed to throw NullPointerException");
            }
            catch (NullPointerException e2) {
                this.logSuccessfulCheck(1114773);
            }
            catch (Exception e2) {
                this.getLog().warning(e2);
                return TCKTestResult.failed(1114773, "alarmMBeanProxy.clearAlarms failed");
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114773, "alarmMBeanProxy.clearAlarms failed");
        }
        try {
            int numberCleared3 = alarmMBeanProxy.clearAlarms((NotificationSource)badSbbNotification1, this.alarmType);
            return TCKTestResult.failed(1114980, "alarmMBeanProxy.clearAlarms failed to throw UnrecognizedNotificationSourceException");
        }
        catch (UnrecognizedNotificationSourceException e) {
            this.logSuccessfulCheck(1114980);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114980, "alarmMBeanProxy.clearAlarms failed");
        }
        try {
            String[] sbbAlarmIDs = alarmMBeanProxy.getAlarms((NotificationSource)this.sbbNotification);
            this.utils().getLog().fine("Number of Alarm IDs for sbbNotification = " + sbbAlarmIDs.length);
            int numberCleared4 = alarmMBeanProxy.clearAlarms((NotificationSource)this.sbbNotification);
            if (numberCleared4 != 0) {
                return TCKTestResult.failed(1114764, "alarmMBeanProxy.clearAlarms failed to clear Alarms");
            }
            this.logSuccessfulCheck(1114764);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114764, "alarmMBeanProxy.clearAlarms failed");
        }
        try {
            int numberCleared5 = alarmMBeanProxy.clearAlarms(nullSbbNotification);
            return TCKTestResult.failed(1114765, "alarmMBeanProxy.clearAlarms(null) failed to throw NullPointerException");
        }
        catch (NullPointerException e) {
            this.logSuccessfulCheck(1114765);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114765, "alarmMBeanProxy.clearAlarms(null) failed");
        }
        try {
            int numberCleared6 = alarmMBeanProxy.clearAlarms((NotificationSource)badSbbNotification1);
            return TCKTestResult.failed(1114769, "alarmMBeanProxy.clearAlarms failed to throw UnrecognizedNotificationSourceException");
        }
        catch (UnrecognizedNotificationSourceException e) {
            this.logSuccessfulCheck(1114769);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114769, "alarmMBeanProxy.clearAlarms failed");
        }
        return TCKTestResult.passed();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                Test1114768Test.this.getLog().fine("Received Alarm Notification: " + notification);
                if (!Test1114768Test.this.alarmsCreated) {
                    AlarmNotification alarmNotification = (AlarmNotification)notification;
                    String alarmID = alarmNotification.getAlarmID();
                    Test1114768Test.this.sbbNotification = (SbbNotification)alarmNotification.getNotificationSource();
                    Test1114768Test.this.alarmType = alarmNotification.getAlarmType();
                    String instanceID = alarmNotification.getInstanceID();
                    AlarmLevel alarmLevel = alarmNotification.getAlarmLevel();
                    String message = alarmNotification.getMessage();
                    Throwable cause = alarmNotification.getCause();
                    long timestamp = alarmNotification.getTimeStamp();
                    Test1114768Test.this.getLog().fine("Creating Alarm from notification...");
                    Alarm alarm = new Alarm(alarmID, (NotificationSource)Test1114768Test.this.sbbNotification, Test1114768Test.this.alarmType, instanceID, alarmLevel, message, cause, timestamp);
                    try {
                        Test1114768Test.this.result = Test1114768Test.this.doAlarmMBeanCheck(Test1114768Test.this.alarmMBeanProxy);
                    }
                    catch (Exception e) {
                        Test1114768Test.this.getLog().warning(e);
                        Test1114768Test.this.result;
                        TCKTestResult.error("Error in Alarm notification");
                    }
                    Test1114768Test.this.alarmsCreated = true;
                }
            }
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1114768Test";
            Boolean sbbTestResult = (Boolean)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1114768Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
        }

        public void onException(Exception exception) throws RemoteException {
            Test1114768Test.this.getLog().warning("Received Exception from SBB");
            Test1114768Test.this.getLog().warning(exception);
            Test1114768Test.this.result;
            TCKTestResult.error(exception);
        }
    }
}

