/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.ActivityContextInterface.Detach;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.management.DeployableUnitID;

public class DetachNullTest
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        this.utils.getLog().fine("Firing TCKResourceExentX at SBB.");
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        String activityName = "DetachTest";
        TCKActivityID activityID = resource.createActivity(activityName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        this.utils.getLog().fine("Waiting for SBB to indicate pass/fail at attaching a NULL SBB to an Activity Context Interface.");
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "No response from the SBB", 3025);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        DeployableUnitID duID = this.utils.install(duPath);
        this.utils.activateServices(duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            DetachNullTest.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                DetachNullTest.this.result.setPassed();
            } else {
                DetachNullTest.this.result.setFailed(3025, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            DetachNullTest.this.utils.getLog().warning("Received exception from SBB");
            DetachNullTest.this.utils.getLog().warning(e);
            DetachNullTest.this.result.setError(e);
        }
    }
}

