/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.tracefacility.tracer;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;

public class Test1113111Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    private DeployableUnitID duID;
    private FutureResult result;
    private SbbID sbbID;
    private ServiceID serviceID;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        TraceMBeanProxy traceMBeanProxy = this.utils().getMBeanProxyFactory().createTraceMBeanProxy(this.utils().getSleeManagementMBeanProxy().getTraceMBean());
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        SbbNotification sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        try {
            this.getLog().fine("Starting to test a valid length of the tracer name components.");
            traceMBeanProxy.setTraceLevel((NotificationSource)sbbNotification, "com.foo", TraceLevel.FINE);
        }
        catch (UnsupportedOperationException uoe) {
            this.getLog().warning(uoe);
            result.setError("ERROR!", uoe);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            result.setFailed(1113111, "Tracer name components must be at least one character in length, that means that the tracer name com.foois a legal name.");
        }
        boolean passed = false;
        try {
            this.getLog().fine("Starting to test an invalid length of the tracer name components.");
            traceMBeanProxy.setTraceLevel((NotificationSource)sbbNotification, "com..foo", TraceLevel.FINE);
        }
        catch (UnsupportedOperationException uoe) {
            this.getLog().warning(uoe);
            result.setError("ERROR!", uoe);
        }
        catch (InvalidArgumentException iae) {
            passed = true;
        }
        catch (Exception e) {
            this.getLog().warning(e);
            result.setError("ERROR!", e);
        }
        if (!passed) {
            result.setFailed(1113428, "Tracer name components must be at least one character in length, that means that \u201a\u00c4\u00facom..foo\u201a\u00c4\u00f9 is not a legal name because the middle name component of this name is zero-length.");
        }
        try {
            this.getLog().fine("Starting to test the default trace level for all root tracers is TraceLevel.OFF or TraceLevel.INFO.");
            if (traceMBeanProxy.getTraceLevel((NotificationSource)sbbNotification, "") != TraceLevel.INFO) {
                result.setFailed(1113112, "The default trace level for all root tracers must set to TraceLevel.OFF, but it returned " + traceMBeanProxy.getTraceLevel((NotificationSource)sbbNotification, "").toString());
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            result.setError("ERROR!", e);
        }
        try {
            this.getLog().fine("Starting to test the Administrator uses the TraceMBean to change the trace level for a tracer. ");
            traceMBeanProxy.setTraceLevel((NotificationSource)sbbNotification, "com.foo", TraceLevel.FINE);
            if (traceMBeanProxy.getTraceLevel((NotificationSource)sbbNotification, "com.foo") != TraceLevel.FINE) {
                result.setFailed(1113168, "The old TraceLevel for the tracername com.foo did not return TraceLevel.FINE.");
            }
            traceMBeanProxy.setTraceLevel((NotificationSource)sbbNotification, "com.foo", TraceLevel.CONFIG);
            if (traceMBeanProxy.getTraceLevel((NotificationSource)sbbNotification, "com.foo") != TraceLevel.CONFIG) {
                result.setFailed(1113168, "The new TraceLevel for the tracername com.foo did not return TraceLevel.CONFIG.");
            }
        }
        catch (UnsupportedOperationException uoe) {
            this.getLog().warning(uoe);
            result.setError("ERROR!", uoe);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            result.setFailed(1113168, "There is an error when the Administrator uses the TraceMBean to change the trace level for a tracer. ");
        }
        result.setPassed();
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }
}

