/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEventImpl;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.Address;
import javax.slee.ComponentID;
import javax.slee.InitialEventSelector;
import javax.slee.SbbContext;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;

public abstract class SetTimerRefCountSbb
extends BaseTCKSbb {
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private TimerFacility timerFacility;
    private boolean result = false;
    private String message;
    private int failedAssertionID = -1;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.nullActivityFactory = (NullActivityFactory)myEnv.lookup("slee/nullactivity/factory");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.timerFacility = (TimerFacility)myEnv.lookup("slee/facilities/timer");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received start message", null);
            this.setTestName((String)event.getMessage());
            NullActivity nobody = this.nullActivityFactory.createNullActivity();
            ActivityContextInterface nobodyACI = this.nullACIFactory.getActivityContextInterface(nobody);
            if (this.getTestName().equals("setTimerRefCount1")) {
                this.setTimerID(this.timerFacility.setTimer(nobodyACI, null, 0L, new TimerOptions()));
            } else {
                this.setTimerID(this.timerFacility.setTimer(nobodyACI, null, 0L, 60000L, 0, new TimerOptions()));
            }
            this.fireCustomEvent(new TCKSbbEventImpl(new Integer(0)), nobodyACI, null);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onCustomEvent(TCKSbbEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received custom event", null);
            if (this.getReceivedEndEvent()) {
                this.setResultFailed(1185, "setTimer() did not increment aci ref count");
            } else {
                this.setResultPassed("setTimer() incremented aci ref count correctly");
            }
            aci.detach(this.getSbbContext().getSbbLocalObject());
            this.timerFacility.cancelTimer(this.getTimerID());
            this.sendResultToTCK();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received activity end event", null);
            if (aci.getActivity() instanceof NullActivity) {
                this.setReceivedEndEvent(true);
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public InitialEventSelector getStaticConvergenceName(InitialEventSelector ies) {
        ies.setCustomName("foobar");
        return ies;
    }

    public abstract void fireCustomEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void setReceivedEndEvent(boolean var1);

    public abstract boolean getReceivedEndEvent();

    public abstract void setTimerID(TimerID var1);

    public abstract TimerID getTimerID();

    public abstract void setTestName(String var1);

    public abstract String getTestName();

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.getTestName());
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }
}

