/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.SbbContext;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;

public abstract class SetTimerPeriodicSbb
extends BaseTCKSbb {
    private TimerFacility timerFacility;
    private boolean result = false;
    private String message;
    private int failedAssertionID = -1;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)myEnv.lookup("slee/facilities/timer");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received start message", null);
            this.setTestName((String)event.getMessage());
            TimerOptions preserveAll = new TimerOptions();
            preserveAll.setPreserveMissed(TimerPreserveMissed.ALL);
            if (this.getTestName().equals("setTimerPeriodic1")) {
                this.timerFacility.setTimer(aci, null, 0L, 5000L, 1, preserveAll);
            } else if (this.getTestName().equals("setTimerPeriodic2")) {
                this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + 5000L, 2000L, 1, preserveAll);
            } else if (this.getTestName().equals("setTimerPeriodic3")) {
                this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + 5000L, 2000L, 0, preserveAll);
            } else if (this.getTestName().equals("setTimerPeriodic4")) {
                this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + 5000L, 2000L, 2, preserveAll);
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received timer event", null);
            this.setNumTimerEvents(this.getNumTimerEvents() + 1);
            boolean finished = false;
            if (this.getTestName().equals("setTimerPeriodic1") || this.getTestName().equals("setTimerPeriodic2")) {
                this.setResultPassed("setTimer() periodic timer fired correctly");
                finished = true;
            } else if (this.getNumTimerEvents() == 2) {
                this.setResultPassed("setTimer() periodic timer fired correctly");
                finished = true;
            }
            if (finished) {
                this.sendResultToTCK();
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract void setTestName(String var1);

    public abstract String getTestName();

    public abstract void setNumTimerEvents(int var1);

    public abstract int getNumTimerEvents();

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.getTestName());
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }
}

