/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.timerfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventY;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;

public abstract class CancelTimerTestSbb
extends BaseTCKSbb {
    private boolean result = false;
    private String message;
    private static final String JNDI_TIMERFACILITY_NAME = "java:comp/env/slee/facilities/timer";
    private int failedAssertionID = -1;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.setTestName((String)event.getMessage());
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received start message", null);
            TimerFacility tf = this.getTimerFacility();
            TimerOptions preserveAll = new TimerOptions();
            preserveAll.setPreserveMissed(TimerPreserveMissed.ALL);
            TimerID timer = tf.setTimer(aci, null, 0L, 2000L, 0, preserveAll);
            this.setTimer(timer);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventY1(TCKResourceEventY event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received stop message", null);
            if (this.getTimerCancelled()) {
                if (this.getLastTimerCount() == this.getTimerFiredCount()) {
                    this.setResultPassed("Timer cancelled successfully");
                } else {
                    this.setResultFailed(1203, "TimerEvents received after timer cancelled!");
                }
            } else {
                this.setResultFailed(1203, "Error: cancelTimer() never called");
            }
            this.sendResultToTCK();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received timer event", null);
            this.setTimerFiredCount(this.getTimerFiredCount() + 1);
            if (!this.getTimerCancelled()) {
                TimerFacility tf = this.getTimerFacility();
                tf.cancelTimer(this.getTimer());
                this.setTimerCancelled(true);
                this.setLastTimerCount(this.getTimerFiredCount());
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.getTestName());
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }

    private TimerFacility getTimerFacility() throws Exception {
        TimerFacility tf = null;
        try {
            tf = (TimerFacility)new InitialContext().lookup(JNDI_TIMERFACILITY_NAME);
        }
        catch (Exception e) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, "got unexpected Exception: " + e, null);
        }
        return tf;
    }

    public abstract TimerID getTimer();

    public abstract void setTimer(TimerID var1);

    public abstract int getTimerFiredCount();

    public abstract void setTimerFiredCount(int var1);

    public abstract int getLastTimerCount();

    public abstract void setLastTimerCount(int var1);

    public abstract boolean getTimerCancelled();

    public abstract void setTimerCancelled(boolean var1);

    public abstract String getTestName();

    public abstract void setTestName(String var1);
}

