/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.eventlookupfacility;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.MessageHandler;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.facilities.eventlookupfacility.Test1113654ResourceAdaptor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.slee.EventTypeID;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.FireableEventType;

public class Test1113654MessageListener
extends UnicastRemoteObject
implements MessageHandler {
    public static final int CHECK_IGNORE_RA_TYPE_EVENT_TYPE_FALSE = 1;
    public static final int CHECK_IGNORE_RA_TYPE_EVENT_TYPE_TRUE = 2;
    private BaseMessageSender msgSender;
    private RMIObjectChannel out;
    private Test1113654ResourceAdaptor ra;

    public Test1113654MessageListener(Test1113654ResourceAdaptor ra) throws RemoteException {
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            ra.getLog().warning("Exception occurred when trying to acquire RMIObjectChannel: ", e);
        }
        this.ra = ra;
    }

    public boolean handleMessage(Object message) throws RemoteException {
        int type = (Integer)((HashMap)message).get("Type");
        switch (type) {
            case 1: {
                if (this.test_GetEventType() && this.test_GetEventClassName() && this.test_GetEventClassLoader() && this.test_GetFireableEventType()) {
                    this.msgSender.sendSuccess(1113654, "Test successful.");
                }
            }
            case 2: {
                if (!this.test_INGORE_RA_TYPE_EVENT_TYPE_CHECK()) break;
                this.msgSender.sendSuccess(1113665, "Test successful.");
            }
        }
        return true;
    }

    private boolean test_GetEventType() {
        try {
            EventTypeID simpleEventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fet = this.getFireableEventType(simpleEventTypeID);
            try {
                EventTypeID eventTypeID = fet.getEventType();
                if (eventTypeID == null || !eventTypeID.equals((Object)simpleEventTypeID)) {
                    this.msgSender.sendFailure(1113654, "Invalid EventTypeID returned from FireableEventType.getEventType()");
                    return false;
                }
                this.msgSender.sendLogMsg("getEventType() returned expected EventID");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113654, "Invalid EventTypeID returned from FireableEventType.getEventType()", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean test_GetEventClassName() {
        try {
            EventTypeID simpleEventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fet = this.getFireableEventType(simpleEventTypeID);
            try {
                String className = fet.getEventClassName();
                if (className == null || !className.equals("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent")) {
                    this.msgSender.sendFailure(1113655, "Incorrect class name returned from FireableEventType.getEventClassName()");
                    return false;
                }
                this.msgSender.sendLogMsg("getEventClassName() returned expected event class name.");
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113655, "Exception occured when calling FireableEventType.getEventClassName(): ", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    private boolean test_GetEventClassLoader() {
        try {
            EventTypeID simpleEventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
            FireableEventType fet = this.getFireableEventType(simpleEventTypeID);
            try {
                ClassLoader classLoader = fet.getEventClassLoader();
                if (classLoader == null || classLoader.loadClass(fet.getEventClassName()) == null) {
                    this.msgSender.sendFailure(1113656, "Incorrect class name returned from FireableEventType.getEventClassName()");
                    return false;
                }
                this.msgSender.sendLogMsg("getEventClassName() returned expected event class name.");
            }
            catch (ClassNotFoundException cnfe) {
                this.msgSender.sendFailure(1113656, "ClassNotFoundException occured when calling FireableEventType.getEventClassName(): ", cnfe);
            }
            catch (Exception e) {
                this.msgSender.sendFailure(1113656, "Exception occured when calling FireableEventType.getEventClassName(): ", e);
                return false;
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean test_GetFireableEventType() {
        elf = this.getEventLookupFacility();
        eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        try {
            fet = elf.getFireableEventType(eventTypeID);
            if (fet == null || !fet.getEventType().equals((Object)eventTypeID)) {
                this.msgSender.sendFailure(1113662, "Invalid FireableEventType returned from EventLookupFacility.getFireableEventType()");
                return false;
            }
            this.msgSender.sendLogMsg("getEventID()returned expected EventID");
            ** GOTO lbl17
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1113662, "Invalid FireableEventType returned from EventLookupFacility.getFireableEventType(): " + e);
            return false;
        }
        {
            catch (Exception e) {
                this.msgSender.sendException(e);
                return false;
            }
lbl17:
            // 1 sources

            try {
                fet = elf.getFireableEventType(null);
                this.msgSender.sendFailure(1113663, "getFireableEventType with null name did not throw a NullPointerException");
                return false;
            }
            catch (NullPointerException npe) {}
            {
                this.msgSender.sendLogMsg("getFireableEventType threw NullPointerException as expected: " + npe);
                serviceStartedEvent = "javax.slee.serviceactivity.ServiceStartedEvent";
                serviceStartedEventType = new EventTypeID(serviceStartedEvent, "javax.slee", "1.1");
                try {
                    fet = elf.getFireableEventType(serviceStartedEventType);
                    this.msgSender.sendFailure(1113664, "getFireableEventType with an unrecognized event type did not throw a UnrecognizedEventException");
                    return false;
                }
                catch (UnrecognizedEventException uee) {
                    this.msgSender.sendLogMsg("FireableEventType() threw UnrecognizedEventException as expected when called with an unrecognized event type");
                }
                catch (Exception e) {
                    this.msgSender.sendFailure(1113664, "getFireableEventType with an unrecognized event type did not throw a UnrecognizedEventException: " + e);
                    return false;
                }
                catch (Exception e) {
                    this.msgSender.sendFailure(1113663, "getFireableEventType with null name threw unexpected exception: " + e);
                    return false;
                }
                dummyEventTypeID = new EventTypeID("name-does-not-exist", "vendor-does-not-exist", "verson-does-not-exist");
                try {
                    fet = elf.getFireableEventType(dummyEventTypeID);
                    this.msgSender.sendFailure(1113664, "getFireableEventType with an uninstalled event type did not throw a UnrecognizedEventException");
                    return false;
                }
                catch (UnrecognizedEventException uee) {
                    this.msgSender.sendLogMsg("FireableEventType() threw UnrecognizedEventException as expected when called with an unrecognized event type");
                    return true;
                }
                catch (Exception e) {
                    this.msgSender.sendFailure(1113664, "getFireableEventType with an uninstalled event type did not throw a UnrecognizedEventException: " + e);
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean test_INGORE_RA_TYPE_EVENT_TYPE_CHECK() {
        elf = this.getEventLookupFacility();
        eventTypeID = new EventTypeID("com.opencloud.sleetck.lib.testsuite.resource.SimpleEvent", "jain.slee.tck", "1.1");
        try {
            fet = elf.getFireableEventType(eventTypeID);
            if (fet == null || !fet.getEventType().equals((Object)eventTypeID)) {
                this.msgSender.sendFailure(1113662, "Invalid FireableEventType returned from EventLookupFacility.getFireableEventType()");
                return false;
            }
            this.msgSender.sendLogMsg("FireableEventType()returned expected EventID");
            ** GOTO lbl17
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1113662, "Invalid FireableEventType returned from EventLookupFacility.getFireableEventType(): " + e);
            return false;
        }
        {
            catch (Exception e) {
                this.msgSender.sendException(e);
                return false;
            }
lbl17:
            // 1 sources

            try {
                fet = elf.getFireableEventType(null);
                this.msgSender.sendFailure(1113663, "getFireableEventType with null name did not throw a NullPointerException");
                return false;
            }
            catch (NullPointerException npe) {}
            {
                this.msgSender.sendLogMsg("getFireableEventType threw NullPointerException as expected: " + npe);
                serviceStartedEvent = "javax.slee.serviceactivity.ServiceStartedEvent";
                serviceStartedEventType = new EventTypeID(serviceStartedEvent, "javax.slee", "1.1");
                try {
                    fet = elf.getFireableEventType(serviceStartedEventType);
                    this.msgSender.sendLogMsg("FireableEventType() didn't threw UnrecognizedEventException as expected when called with an unrecognized event type");
                }
                catch (UnrecognizedEventException uee) {
                    this.msgSender.sendFailure(1113665, "getFireableEventType threw UnrecognizedEventException as unexpected when called with an unrecognized event type");
                    return false;
                }
                catch (Exception e) {
                    this.msgSender.sendFailure(1113665, "getFireableEventType with an unrecognized event type did not throw a UnrecognizedEventException: " + e + fet.toString());
                    return false;
                }
                catch (Exception e) {
                    this.msgSender.sendFailure(1113663, "getFireableEventType with null name threw unexpected exception: " + e);
                    return false;
                }
                dummyEventTypeID = new EventTypeID("name-does-not-exist", "vendor-does-not-exist", "verson-does-not-exist");
                try {
                    fet = elf.getFireableEventType(dummyEventTypeID);
                    this.msgSender.sendFailure(1113665, "getFireableEventType with an uninstalled event type did not throw a UnrecognizedEventException");
                    return false;
                }
                catch (UnrecognizedEventException uee) {
                    this.msgSender.sendLogMsg("FireableEventType() threw UnrecognizedEventException as expected when called with an unrecognized event type");
                    return true;
                }
                catch (Exception e) {
                    this.msgSender.sendFailure(1113665, "getFireableEventType with an uninstalled event type did not throw a UnrecognizedEventException: " + e);
                    return false;
                }
            }
        }
    }

    private FireableEventType getFireableEventType(EventTypeID eventType) throws NamingException {
        FireableEventType fet;
        EventLookupFacility eventLookup = this.getEventLookupFacility();
        try {
            fet = eventLookup.getFireableEventType(eventType);
        }
        catch (Exception e) {
            this.ra.getLog().warning("getFireableEventType throw a UnrecognizedEventException: " + e);
            fet = null;
        }
        return fet;
    }

    private EventLookupFacility getEventLookupFacility() throws NamingException {
        return this.ra.getResourceAdaptorContext().getEventLookupFacility();
    }
}

