/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility.alarm;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.Alarm;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;

public class Test1113449Test
extends AbstractSleeTCKTest {
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private SbbID sbbID;
    private ServiceID serviceID;
    private String[] alarmIDs;
    private SbbNotification sbbNotification;
    private Alarm firstAlarm;
    private String testName = "Test1113449";

    public void run(FutureResult result) throws Exception {
        this.result = result;
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        this.sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        try {
            this.getLog().fine("Starting to get all existing unique alarm identifiers for stateful alarms currently active in the SLEE that were raised by the specified notification source.");
            this.alarmIDs = this.alarmMBeanProxy.getAlarms((NotificationSource)this.sbbNotification);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            result.setError("ERROR!", e);
        }
        String activityName = "Test1113449Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                if (alarmNotification.getMessage().equals("Test1113449AlarmMessage1")) {
                    long timestamp2;
                    Throwable cause2;
                    String message2;
                    AlarmLevel alarmLevel2;
                    String instanceID2;
                    String alarmType2;
                    SbbNotification notificationSource2;
                    String alarmID = alarmNotification.getAlarmID();
                    SbbNotification notificationSource = (SbbNotification)alarmNotification.getNotificationSource();
                    String alarmType = alarmNotification.getAlarmType();
                    String instanceID = alarmNotification.getInstanceID();
                    AlarmLevel alarmLevel = alarmNotification.getAlarmLevel();
                    String message = alarmNotification.getMessage();
                    Throwable cause = alarmNotification.getCause();
                    long timestamp = alarmNotification.getTimeStamp();
                    Alarm alarm = new Alarm(alarmID, (NotificationSource)notificationSource, alarmType, instanceID, alarmLevel, message, cause, timestamp);
                    if (Test1113449Test.this.firstAlarm == null) {
                        Test1113449Test.this.firstAlarm = alarm;
                        Test1113449Test.this.getLog().info("Received FirstAlarmID: " + Test1113449Test.this.firstAlarm.getAlarmID());
                    }
                    if (alarm == null) {
                        Test1113449Test.this.result.setFailed(1113449, "The Alarm object returned null which was not expected.");
                        return;
                    }
                    if (!alarm.getNotificationSource().equals(Test1113449Test.this.sbbNotification)) {
                        Test1113449Test.this.result.setFailed(1113449, "Alarm.getNotificationSource() returned incorrect notification source.");
                        return;
                    }
                    SbbNotification sbbN = (SbbNotification)alarm.getNotificationSource();
                    SbbID newSbbID = sbbN.getSbb();
                    ServiceID newServiceID = sbbN.getService();
                    if (!newSbbID.equals((Object)Test1113449Test.this.sbbID)) {
                        Test1113449Test.this.result.setFailed(1113450, "The notification source identifies an SBB component didn't match the one which raised the alarm.");
                        return;
                    }
                    if (!newServiceID.equals((Object)Test1113449Test.this.serviceID)) {
                        Test1113449Test.this.result.setFailed(1113450, "The notification source identifies a Serice ID didn't match the one which raised the alarm.");
                        return;
                    }
                    if (!alarm.getAlarmType().equals("javax.slee.management.Alarm")) {
                        Test1113449Test.this.result.setFailed(1113453, "Alarm.getAlarmType() returned incorrect type of the alarm.");
                        return;
                    }
                    if (!alarm.getInstanceID().equals("Test1113449AlarmInstanceID1")) {
                        Test1113449Test.this.result.setFailed(1113459, "Alarm.getInstanceID() returned incorrect alarm instance ID.");
                        return;
                    }
                    String alarmID2 = alarmNotification.getAlarmID().concat("unknown");
                    Alarm alarm2 = new Alarm(alarmID2, (NotificationSource)(notificationSource2 = (SbbNotification)alarmNotification.getNotificationSource()), alarmType2 = alarmNotification.getAlarmType(), instanceID2 = alarmNotification.getInstanceID(), alarmLevel2 = AlarmLevel.INDETERMINATE, message2 = alarmNotification.getMessage().concat("unknown"), cause2 = null, timestamp2 = alarmNotification.getTimeStamp() + 1000L);
                    if (!alarm.equals((Object)alarm2)) {
                        Test1113449Test.this.result.setFailed(1113463, "An alarm didn't consider the same as a alarm2 even its notification source, alarm type and instance ID are the same.");
                        return;
                    }
                    SbbID unknownSbbID = new SbbID("Test1113449SbbUnknown", "jain.slee.tck", "1.1");
                    ServiceID unknownServiceID = new ServiceID("Test1113449ServiceUnknown", "jain.slee.tck", "1.1");
                    SbbNotification newNotificationSource = new SbbNotification(unknownServiceID, unknownSbbID);
                    String newAlarmType = "javax.slee.management.AlarmUnknown";
                    String newInstanceID = "Test1113449AlarmInstanceID1Unknown";
                    Alarm alarmFalseNotiSource = new Alarm(alarmID2, (NotificationSource)newNotificationSource, alarmType2, instanceID2, alarmLevel2, message2, cause2, timestamp2);
                    Alarm alarmFalseType = new Alarm(alarmID2, (NotificationSource)notificationSource2, newAlarmType, instanceID2, alarmLevel2, message2, cause2, timestamp2);
                    Alarm alarmFalseInstanceID = new Alarm(alarmID2, (NotificationSource)notificationSource2, alarmType2, newInstanceID, alarmLevel2, message2, cause2, timestamp2);
                    if (alarm.equals((Object)alarmFalseNotiSource) || alarm.equals((Object)alarmFalseType) || alarm.equals((Object)alarmFalseInstanceID)) {
                        Test1113449Test.this.result.setFailed(1113463, "An alarm shouldn't consider the same as another alarm if  its notification source, alarm type or instance ID are different.");
                        return;
                    }
                    if (!Test1113449Test.this.firstAlarm.getAlarmID().equals(alarm.getAlarmID())) {
                        Test1113449Test.this.getLog().info("Received AlarmID: " + alarm.getAlarmID());
                        Test1113449Test.this.result.setFailed(1113464, "FirstAlarm.getAlarmID().equals(Alarm.getAlarmID()) returned false for the same alarm object.");
                        return;
                    }
                    if (!alarm.getAlarmID().equals(alarm.getAlarmID())) {
                        Test1113449Test.this.result.setFailed(1113464, "Alarm.getAlarmID().equals(Alarm.getAlarmID()) returned false when comparing an alarm with itself.");
                        return;
                    }
                } else if (alarmNotification.getMessage().equals("Test1113449AlarmMessage2")) {
                    Test1113449Test.this.result.setPassed();
                } else {
                    Test1113449Test.this.result.setFailed(1113449, "Test Alarm interface failed!");
                }
                return;
            }
        }
    }
}

