/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Tracer;

public abstract class Test1113497Sbb1
extends BaseTCKSbb {
    public static final String ALARM_MESSAGE = "Test1113497AlarmMessageSbb1";
    public static final String ALARM_INSTANCEID = "Test1113497AlarmInstanceIDSbb1";
    private Tracer tracer;

    public void onTCKResourceEventX1(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Received " + ev + " message", null);
            AlarmFacility facility = this.getAlarmFacility();
            this.setFirstAlarm(facility.raiseAlarm("javax.slee.management.Alarm", ALARM_INSTANCEID, AlarmLevel.MAJOR, ALARM_MESSAGE));
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX ev, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Received " + ev + " message again", null);
            AlarmFacility facility = this.getAlarmFacility();
            if (!facility.clearAlarm(this.getFirstAlarm())) {
                this.sendResultToTCK("Test1113497Test", false, 1113497, "The alarm which has been raised cannot be cleared. The method shouldreturn true!");
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, int failedAssertionID, String message) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private AlarmFacility getAlarmFacility() throws Exception {
        AlarmFacility facility = null;
        String JNDI_ALARMFACILITY_NAME = "java:comp/env/slee/facilities/alarm";
        try {
            facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
        }
        catch (Exception e) {
            this.tracer.warning("got unexpected Exception: " + e, null);
        }
        return facility;
    }

    public abstract void setFirstAlarm(String var1);

    public abstract String getFirstAlarm();
}

